/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sampler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.management.ThreadInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.management.openmbean.CompositeData;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle;

class SamplesOutputStream {
    private static final String[][] methods = new String[][]{{"sun.management.ThreadInfoCompositeData", "toCompositeData"}, {"com.ibm.lang.management.ManagementUtils", "toThreadInfoCompositeData"}};
    static final String ID = "NPSS";
    static final String FILE_EXT = ".npss";
    static final int RESET_THRESHOLD = 5000;
    static final int STEPS = 1000;
    static byte version = 1;
    private static Method toCompositeDataMethod;
    OutputStream outStream;
    Map<Long, ThreadInfo> lastThreadInfos;
    Map<StackTraceElement, StackTraceElement> steCache;
    List<Sample> samples;
    volatile ProgressHandle progress;

    static boolean isSupported() {
        return toCompositeDataMethod != null;
    }

    SamplesOutputStream(OutputStream os) throws IOException {
        this.outStream = os;
        this.writeHeader(os);
        this.lastThreadInfos = new HashMap<Long, ThreadInfo>();
        this.steCache = new HashMap<StackTraceElement, StackTraceElement>(8192);
        this.samples = new ArrayList<Sample>(1024);
    }

    SamplesOutputStream(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    void writeSample(ThreadInfo[] infos, long time, long selfThreadId) throws IOException {
        ArrayList<Long> sameT = new ArrayList<Long>();
        ArrayList<ThreadInfo> newT = new ArrayList<ThreadInfo>();
        ArrayList<Long> tids = new ArrayList<Long>();
        for (ThreadInfo tinfo : infos) {
            Object[] stack;
            Object[] lastStack;
            long id;
            if (tinfo == null || (id = tinfo.getThreadId()) == selfThreadId) continue;
            Long tid = tinfo.getThreadId();
            ThreadInfo lastThread = this.lastThreadInfos.get(tid);
            tids.add(tid);
            if (lastThread != null && lastThread.getThreadState().equals((Object)tinfo.getThreadState()) && Arrays.deepEquals(lastStack = lastThread.getStackTrace(), stack = tinfo.getStackTrace())) {
                sameT.add(tid);
                continue;
            }
            this.internStackTrace(tinfo);
            newT.add(tinfo);
            this.lastThreadInfos.put(tid, tinfo);
        }
        this.samples.add(new Sample(time, sameT, newT));
        HashSet<Long> ids = new HashSet<Long>(this.lastThreadInfos.keySet());
        ids.removeAll(tids);
        this.lastThreadInfos.keySet().removeAll(ids);
    }

    private static CompositeData toCompositeData(ThreadInfo tinfo) {
        try {
            return (CompositeData)toCompositeDataMethod.invoke(null, tinfo);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    void close() throws IOException {
        this.steCache = null;
        GZIPOutputStream stream = new GZIPOutputStream(this.outStream, 65536);
        ObjectOutputStream out = new ObjectOutputStream(stream);
        int size = this.samples.size();
        this.openProgress();
        for (int i = 0; i < size; ++i) {
            Sample s = this.samples.get(i);
            this.samples.set(i, null);
            if (i > 0 && i % 5000 == 0) {
                out.reset();
            }
            s.writeToStream(out);
            if ((i + 40) % 50 != 0) continue;
            this.step(1000 * i / size);
        }
        this.step(1000);
        out.close();
        this.closeProgress();
    }

    private void writeHeader(OutputStream os) throws IOException {
        os.write(ID.getBytes());
        os.write(version);
    }

    private void internStackTrace(ThreadInfo tinfo) {
        StackTraceElement[] stack = tinfo.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement ste = stack[i];
            StackTraceElement oldStack = this.steCache.get(ste);
            if (oldStack != null) {
                stack[i] = oldStack;
                continue;
            }
            this.steCache.put(ste, ste);
        }
    }

    private void openProgress() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SamplesOutputStream.this.progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SamplesOutputStream.class, (String)"Save_Progress"));
                SamplesOutputStream.this.progress.start(1000);
            }
        });
    }

    private void closeProgress() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SamplesOutputStream.this.progress.finish();
                SamplesOutputStream.this.progress = null;
            }
        });
    }

    private void step(int i) {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        if (this.progress != null) {
            this.progress.progress(i);
        }
    }

    static {
        for (String[] method : methods) {
            String className = method[0];
            String methodName = method[1];
            try {
                Class<?> clazz = Class.forName(className);
                toCompositeDataMethod = clazz.getMethod(methodName, ThreadInfo.class);
                if (toCompositeDataMethod == null) continue;
                break;
            }
            catch (ClassNotFoundException ex) {
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
        }
    }

    private static class Sample {
        private final long time;
        private final List<Long> sameThread;
        private final List<ThreadInfo> newThreads;

        Sample(long t, List<Long> sameT, List<ThreadInfo> newT) {
            this.time = t;
            this.sameThread = sameT;
            this.newThreads = newT;
        }

        private long getTime() {
            return this.time;
        }

        private List<Long> getSameThread() {
            return this.sameThread;
        }

        private List<ThreadInfo> getNewThreads() {
            return this.newThreads;
        }

        private void writeToStream(ObjectOutputStream out) throws IOException {
            out.writeLong(this.time);
            out.writeInt(this.sameThread.size());
            for (Long tid : this.sameThread) {
                out.writeLong(tid);
            }
            out.writeInt(this.newThreads.size());
            for (ThreadInfo tic : this.newThreads) {
                out.writeObject(SamplesOutputStream.toCompositeData(tic));
            }
        }
    }
}

