/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.filemodels;

import com.sun.javacard.Portability;
import com.sun.javacard.filemodels.FileModel;
import com.sun.javacard.filemodels.ParseErrorHandler;
import com.sun.javacard.filemodels.WebXmlServletEntry;
import com.sun.javacard.filemodels.WrapperParseErrorHandler;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WebXmlModel
extends FileModel<WebXmlServletEntry> {
    private String defaultServlet;
    private String defaultMapping;
    static final String[] KNOWN_TAGS = new String[]{"display-name", "servlet", "servlet-name", "servlet-class", "servlet-mapping", "url-pattern", "web-app"};
    private String displayName;
    private static final String HEADER = "<web-app xmlns=\"http://java.sun.com/xml/ns/j2ee\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         version=\"2.4\"\n         xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/jcns/jcweb-app_3_0.xsd\">\n";

    public WebXmlModel(InputStream in, ParseErrorHandler handler) throws IOException {
        if (in == null) {
            throw new NullPointerException("Null input stream");
        }
        handler = handler == null ? ParseErrorHandler.DEFAULT : handler;
        handler = new WrapperParseErrorHandler(handler, this);
        this.parse(in, handler);
        this.close();
    }

    public WebXmlModel() {
    }

    private WebXmlServletEntry getByName(String name) {
        for (WebXmlServletEntry info : this.getData()) {
            if (!name.equals(info.getName())) continue;
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream in, ParseErrorHandler handler) throws IOException {
        assert (!EventQueue.isDispatchThread());
        try {
            Node child;
            Node parent;
            Document doc = null;
            doc = Portability.parse(in);
            NodeList names = doc.getElementsByTagName("display-name");
            if (names.getLength() > 0) {
                parent = names.item(0);
                this.setDisplayName(parent.getTextContent());
            }
            NodeList servlets = doc.getElementsByTagName("servlet");
            int len = servlets.getLength();
            int ix = 0;
            for (int i = 0; i < len; ++i) {
                String name = null;
                String clazz = null;
                parent = servlets.item(i);
                NodeList kids = parent.getChildNodes();
                int kl = kids.getLength();
                for (int j = 0; j < kl; ++j) {
                    WebXmlServletEntry info;
                    child = kids.item(j);
                    if (child.getNodeType() == 1) {
                        if ("servlet-name".equals(child.getNodeName())) {
                            name = child.getTextContent();
                        } else if ("servlet-class".equals(child.getNodeName())) {
                            clazz = child.getTextContent();
                        } else {
                            handler.unrecognizedElementEncountered(child.getNodeName());
                        }
                    }
                    if (name == null || clazz == null || (info = this.getByName(name)) != null) continue;
                    info = new WebXmlServletEntry(name, clazz, null, ix);
                    ++ix;
                    this.add(info);
                }
            }
            NodeList mappings = doc.getElementsByTagName("servlet-mapping");
            len = mappings.getLength();
            for (int i = 0; i < len; ++i) {
                String name = null;
                String mapping = null;
                parent = mappings.item(i);
                NodeList kids = parent.getChildNodes();
                int kl = kids.getLength();
                for (int j = 0; j < kl; ++j) {
                    WebXmlServletEntry info;
                    child = kids.item(j);
                    if (child.getNodeType() == 1) {
                        if ("servlet-name".equals(child.getNodeName())) {
                            name = child.getTextContent();
                        } else if ("url-pattern".equals(child.getNodeName())) {
                            mapping = child.getTextContent();
                        } else {
                            handler.unrecognizedElementEncountered(child.getNodeName());
                        }
                    }
                    if (mapping == null || name == null || (info = this.getByName(name)) == null) continue;
                    info.setMapping(mapping);
                }
            }
        }
        catch (IOException ex) {
            handler.handleError(ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                Portability.logException(ex);
            }
        }
    }

    public synchronized String defaultServlet() {
        return this.defaultServlet;
    }

    public synchronized String defaultMapping() {
        return this.defaultMapping;
    }

    public synchronized void setDefaultServlet(String defaultServlet) {
        this.defaultServlet = defaultServlet;
    }

    public synchronized void setDefaultMapping(String defaultMapping) {
        this.defaultMapping = defaultMapping;
    }

    public synchronized void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public synchronized String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o != null && o.getClass() == WebXmlModel.class;
        if (result) {
            WebXmlModel other = (WebXmlModel)o;
            String odn = other.getDisplayName();
            String dn = this.getDisplayName();
            boolean bl2 = !(dn != null ? !dn.equals(odn) : odn != null) ? true : (result = false);
            if (result) {
                List odata = other.getData();
                List myData = this.getData();
                result = ((Object)myData).equals(odata);
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        List myData = this.getData();
        String dn = this.getDisplayName();
        hash = 23 * hash + ((Object)myData).hashCode();
        hash = 23 * hash + (dn != null ? dn.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.toXml();
    }

    @Override
    public String toXml() {
        StringBuilder sb = new StringBuilder(HEADER);
        sb.append("    <display-name>");
        sb.append(this.getDisplayName());
        sb.append("</display-name>\n");
        List dataCopy = this.getData();
        for (WebXmlServletEntry i : dataCopy) {
            sb.append(i.toXml());
        }
        sb.append("</web-app>");
        return sb.toString();
    }

    @Override
    protected String getProblemInternal() {
        if (this.displayName == null || this.displayName.trim().length() == 0) {
            return Portability.getString("PROBLEM_DISPLAY_NAME_NOT_SET");
        }
        for (WebXmlServletEntry info : this.getData()) {
            String problem = info.getProblem();
            if (problem == null) continue;
            return problem;
        }
        return null;
    }
}

