/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.setup;

import java.awt.Component;
import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.ui.setup.CreateHostWizardPanel0;
import org.netbeans.modules.cnd.remote.ui.wizard.HostValidatorImpl;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.setup.HostSetupProvider;
import org.netbeans.modules.cnd.spi.remote.setup.HostSetupWorker;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class CreateHostWizardIterator
implements WizardDescriptor.Iterator<WizardDescriptor>,
ChangeListener {
    private int index;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private final ToolsCacheManager cacheManager;
    private final List<HostSetupProvider> providers;
    private final CreateHostWizardPanel0 panel0;
    final List<ChangeListener> changeListeners = new CopyOnWriteArrayList<ChangeListener>();

    private CreateHostWizardIterator(List<HostSetupProvider> providers, ToolsCacheManager cacheManager) {
        this.providers = providers;
        this.cacheManager = cacheManager;
        this.panel0 = new CreateHostWizardPanel0(this, providers, cacheManager);
    }

    private HostSetupWorker getSelectedWorker() {
        return this.panel0.getSelectedWorker();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.panels = null;
        this.getPanels();
        this.fireStateChanged();
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanelsUnchecked() {
        ArrayList<WizardDescriptor.Panel<WizardDescriptor>> pList = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        if (this.providers.size() > 1) {
            pList.add(this.panel0);
        }
        HostSetupWorker worker = this.panel0.getSelectedWorker();
        pList.addAll(worker.getWizardPanels(new HostValidatorImpl(this.cacheManager)));
        WizardDescriptor.Panel[] result = new WizardDescriptor.Panel[pList.size()];
        pList.toArray(result);
        return result;
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        if (this.panels == null) {
            this.panels = this.getPanelsUnchecked();
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    private void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(event);
        }
    }

    public static ServerRecord invokeMe(ToolsCacheManager cacheManager) {
        boolean cancelled;
        ArrayList<HostSetupProvider> providers = new ArrayList<HostSetupProvider>();
        for (HostSetupProvider provider : Lookup.getDefault().lookupAll(HostSetupProvider.class)) {
            if (!provider.isApplicable()) continue;
            providers.add(provider);
        }
        if (providers.isEmpty()) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(CreateHostWizardIterator.class, (String)"NoProviders_Message"), NbBundle.getMessage(CreateHostWizardIterator.class, (String)"NoProviders_Title"), 0);
            return null;
        }
        CreateHostWizardIterator iterator = new CreateHostWizardIterator(providers, cacheManager);
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(NbBundle.getMessage(CreateHostWizardIterator.class, (String)"CreateNewHostWizardTitle"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (cancelled) {
            return null;
        }
        HostSetupWorker worker = iterator.getSelectedWorker();
        if (worker == null) {
            return null;
        }
        HostSetupWorker.Result result = worker.getResult();
        if (result == null) {
            return null;
        }
        Runnable r = result.getRunOnFinish();
        CndUtils.assertFalse((r == null ? 1 : 0) != 0);
        if (r != null) {
            r.run();
        }
        ExecutionEnvironment execEnv = result.getExecutionEnvironment();
        String displayName = result.getDisplayName();
        if (displayName == null) {
            displayName = execEnv.getDisplayName();
        }
        RemoteSyncFactory syncFactory = result.getSyncFactory();
        ServerRecord record = ServerList.get((ExecutionEnvironment)execEnv);
        RemoteServerRecord rsr = (RemoteServerRecord)record;
        rsr.setSyncFactory(syncFactory);
        rsr.setDisplayName(displayName);
        return record;
    }
}

