/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Exceptions;

public abstract class RunFacade {
    protected String output = null;

    public static RunFacade getInstance(ExecutionEnvironment env) {
        if (env.isLocal()) {
            return new RunFacadeLocal();
        }
        return new RunFacadeRemote(env);
    }

    public boolean run(String command) {
        return this.doRun(command) != -1;
    }

    protected abstract int doRun(String var1);

    public String getOutput() {
        return this.output;
    }

    private static class RunFacadeRemote
    extends RunFacade {
        private ExecutionEnvironment executionEnvironment;

        public RunFacadeRemote(ExecutionEnvironment env) {
            this.executionEnvironment = env;
        }

        @Override
        public int doRun(String command) {
            RemoteCommandSupport support = new RemoteCommandSupport(this.executionEnvironment, command);
            int result = support.run();
            this.output = support.getOutput();
            return result;
        }
    }

    private static class RunFacadeLocal
    extends RunFacade {
        private RunFacadeLocal() {
        }

        @Override
        public int doRun(String command) {
            int exitValue = -1;
            try {
                Process process = Runtime.getRuntime().exec(command);
                InputStream is = process.getInputStream();
                if (is != null) {
                    String line;
                    StringBuilder out = new StringBuilder();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    while ((line = reader.readLine()) != null) {
                        if (line == null) continue;
                        out.append(line).append('\n');
                    }
                    this.output = out.toString();
                    reader.close();
                }
                process.waitFor();
                exitValue = process.exitValue();
            }
            catch (InterruptedException ex) {
            }
            catch (InterruptedIOException ex) {
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return exitValue;
        }
    }
}

