/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.FindDialogPanel;
import org.netbeans.editor.ext.KeyEventBlocker;
import org.openide.util.NbBundle;

public class FindDialogSupport
extends WindowAdapter
implements ActionListener {
    private static Object dialogLock = new Object();
    private static boolean isReplaceDialog = false;
    private static JButton[] findButtons;
    private static JButton[] findDialogButtons;
    private static JButton[] replaceDialogButtons;
    private static FindPanel findPanel;
    private static Dialog findDialog;
    private int caretPosition;
    private static FindDialogSupport singleton;
    private static PropertyChangeListener historyChangeListener;
    private boolean findPerformed = false;
    private static int xPos;
    private static int yPos;
    private static boolean dialogInvokedViaKeystroke;
    private static boolean expectedBlockSearchItemChange;

    public static FindDialogSupport getFindDialogSupport() {
        if (singleton == null) {
            singleton = new FindDialogSupport();
        }
        return singleton;
    }

    private FindDialogSupport() {
    }

    private void createFindButtons() {
        if (findButtons == null) {
            ResourceBundle bundle = NbBundle.getBundle(BaseKit.class);
            findButtons = new JButton[]{new JButton(bundle.getString("find-button-find")), new JButton(bundle.getString("find-button-replace")), new JButton(bundle.getString("find-button-replace-all")), new JButton(bundle.getString("find-button-cancel"))};
            findButtons[0].setMnemonic(bundle.getString("find-button-find-mnemonic").charAt(0));
            findButtons[1].setMnemonic(bundle.getString("find-button-replace-mnemonic").charAt(0));
            findButtons[2].setMnemonic(bundle.getString("find-button-replace-all-mnemonic").charAt(0));
            findButtons[0].getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_find-button-find"));
            findButtons[1].getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_find-button-replace"));
            findButtons[2].getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_find-button-replace-all"));
            findButtons[3].getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_find-button-cancel"));
            findDialogButtons = new JButton[2];
            FindDialogSupport.findDialogButtons[0] = findButtons[0];
            FindDialogSupport.findDialogButtons[1] = findButtons[3];
            replaceDialogButtons = new JButton[4];
            FindDialogSupport.replaceDialogButtons[0] = findButtons[0];
            FindDialogSupport.replaceDialogButtons[1] = findButtons[1];
            FindDialogSupport.replaceDialogButtons[2] = findButtons[2];
            FindDialogSupport.replaceDialogButtons[3] = findButtons[3];
        }
    }

    private void createFindPanel() {
        if (findPanel == null) {
            findPanel = new FindPanel();
        }
    }

    private Dialog createFindDialog(JPanel findPanel, JButton[] buttons, ActionListener l) {
        Dialog d = DialogSupport.createDialog(isReplaceDialog ? NbBundle.getBundle(BaseKit.class).getString("replace-title") : NbBundle.getBundle(BaseKit.class).getString("find-title"), findPanel, false, buttons, true, 0, isReplaceDialog ? 3 : 1, l);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showFindDialogImpl(boolean isReplace, KeyEventBlocker blocker) {
        dialogInvokedViaKeystroke = true;
        Object object = dialogLock;
        synchronized (object) {
            if (findDialog != null && isReplaceDialog != isReplace) {
                xPos = FindDialogSupport.findDialog.getLocation().x;
                yPos = FindDialogSupport.findDialog.getLocation().y;
                findDialog.dispose();
                findDialog = null;
            }
            if (findDialog == null) {
                isReplaceDialog = isReplace;
                this.createFindButtons();
                this.createFindPanel();
                findPanel.changeVisibility(isReplace);
                findDialog = this.createFindDialog(findPanel, isReplace ? replaceDialogButtons : findDialogButtons, this);
                findDialog.addWindowListener(this);
                ((JDialog)findDialog).getRootPane().setFocusable(false);
                if (xPos > Integer.MIN_VALUE) {
                    findDialog.setLocation(xPos, yPos);
                }
            }
        }
        findDialog.pack();
        findPanel.init(isReplace, blocker);
        findDialog.setVisible(true);
        findPanel.showNotify();
        FindDialogSupport.findPanel.initBlockSearch();
        this.updateCaretPosition();
    }

    private void updateCaretPosition() {
        JTextComponent c = Utilities.getLastActiveComponent();
        if (c != null) {
            this.caretPosition = c.getCaret().getDot();
        }
    }

    @Override
    public void windowActivated(WindowEvent evt) {
        this.findPerformed = false;
        this.createFindPanel();
        FindDialogSupport.findPanel.initBlockSearch();
        this.updateCaretPosition();
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
        JTextComponent c = Utilities.getLastActiveComponent();
        FindSupport.getFindSupport().incSearchReset();
        KeyEventBlocker blocker = FindDialogSupport.findPanel.getBlocker();
        if (blocker != null) {
            blocker.stopBlocking(false);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.hideDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosed(WindowEvent e) {
        Object object = dialogLock;
        synchronized (object) {
            if (findDialog != null) {
                xPos = FindDialogSupport.findDialog.getLocation().x;
                yPos = FindDialogSupport.findDialog.getLocation().y;
            }
        }
        Map findProps = findPanel.getFindProps();
        if (Boolean.TRUE.equals(findProps.get("find-block-search"))) {
            JTextComponent c;
            Position startPos = (Position)findProps.get("find-block-search-start");
            Position endPos = (Position)findProps.get("find-block-search-end");
            if (startPos != null && endPos != null && (c = Utilities.getLastActiveComponent()) != null) {
                c.select(startPos.getOffset(), endPos.getOffset());
            }
        }
        FindSupport.getFindSupport().incSearchReset();
        FindDialogSupport.findPanel.resetBlockSearch();
        FindSupport.getFindSupport().setBlockSearchHighlight(0, 0);
        findProps.put("find-block-search", Boolean.FALSE);
        findProps.put("find-block-search-start", null);
        findProps.put("find-block-search-end", null);
        FindSupport.getFindSupport().putFindProperties(findProps);
        KeyEventBlocker blocker = FindDialogSupport.findPanel.getBlocker();
        if (blocker != null) {
            blocker.stopBlocking(false);
        }
        findPanel.reset();
        Utilities.returnFocus();
    }

    public void showFindDialog(KeyEventBlocker blocker) {
        this.showFindDialogImpl(false, blocker);
    }

    public void showReplaceDialog(KeyEventBlocker blocker) {
        this.showFindDialogImpl(true, blocker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideDialog() {
        Object object = dialogLock;
        synchronized (object) {
            if (findDialog != null) {
                xPos = FindDialogSupport.findDialog.getLocation().x;
                yPos = FindDialogSupport.findDialog.getLocation().y;
                findDialog.dispose();
            }
            findDialog = null;
        }
    }

    private Vector getHistoryVector() {
        ArrayList histList = FindSupport.getFindSupport().getHistory();
        if (histList == null) {
            histList = new ArrayList();
        }
        boolean isRegExpChecked = (Boolean)findPanel.getFindProps().get("find-reg-exp");
        Vector<String> vec = new Vector<String>();
        for (int i = 0; i < histList.size(); ++i) {
            FindSupport.SearchPatternWrapper spw = (FindSupport.SearchPatternWrapper)histList.get(i);
            String searchExpression = spw.getSearchExpression();
            if (isRegExpChecked != spw.isRegExp() || vec.contains(searchExpression)) continue;
            vec.add(searchExpression);
        }
        return vec;
    }

    private boolean getBooleanProp(String propName, Map map) {
        Boolean b = (Boolean)map.get(propName);
        return b != null ? b : false;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (findButtons == null) {
            return;
        }
        Object src = evt.getSource();
        FindSupport fSup = FindSupport.getFindSupport();
        Map findPanelMap = findPanel.getFindProps();
        FindSupport.SearchPatternWrapper spw = new FindSupport.SearchPatternWrapper((String)findPanelMap.get("find-what"), this.getBooleanProp("find-whole-words", findPanelMap), this.getBooleanProp("find-match-case", findPanelMap), this.getBooleanProp("find-reg-exp", findPanelMap));
        if (src == findButtons[0]) {
            fSup.addToHistory(spw);
            fSup.putFindProperties(findPanelMap);
            fSup.find(null, false);
            this.updateCaretPosition();
            this.findPerformed = true;
        } else if (src == findButtons[1]) {
            fSup.addToHistory(spw);
            findPanel.updateReplaceHistory();
            fSup.putFindProperties(findPanelMap);
            try {
                if (fSup.replace(null, false)) {
                    findPanelMap.put("find-block-search-start", fSup.getFindProperty("find-block-search-start"));
                    fSup.find(null, false);
                }
            }
            catch (GuardedException e) {
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.updateCaretPosition();
            this.findPerformed = true;
        } else if (src == findButtons[2]) {
            fSup.addToHistory(spw);
            findPanel.updateReplaceHistory();
            fSup.putFindProperties(findPanelMap);
            fSup.replaceAll(null);
            findPanelMap.put("find-block-search-start", fSup.getFindProperty("find-block-search-start"));
            this.findPerformed = true;
        } else if (src == findButtons[3]) {
            this.hideDialog();
        }
    }

    static {
        findDialog = null;
        singleton = null;
        xPos = Integer.MIN_VALUE;
        yPos = Integer.MIN_VALUE;
    }

    private class FindPanel
    extends FindDialogPanel
    implements ItemListener,
    KeyListener,
    ActionListener,
    FocusListener {
        private Map findProps = Collections.synchronizedMap(new HashMap(20));
        private Map objToProps = Collections.synchronizedMap(new HashMap(20));
        private DefaultComboBoxModel findHistory = new DefaultComboBoxModel();
        private DefaultComboBoxModel replaceHistory = new DefaultComboBoxModel();
        private KeyEventBlocker blocker;
        private Position blockSearchStartPos;
        private Position blockSearchEndPos;

        FindPanel() {
            this.objToProps.put(this.findWhat, "find-what");
            this.objToProps.put(this.replaceWith, "find-replace-with");
            this.objToProps.put(this.highlightSearch, "find-highlight-search");
            this.objToProps.put(this.incSearch, "find-inc-search");
            this.objToProps.put(this.matchCase, "find-match-case");
            this.objToProps.put(this.wholeWords, "find-whole-words");
            this.objToProps.put(this.regExp, "find-reg-exp");
            this.objToProps.put(this.bwdSearch, "find-backward-search");
            this.objToProps.put(this.wrapSearch, "find-wrap-search");
            this.objToProps.put(this.blockSearch, "find-block-search");
            this.findProps.putAll(FindSupport.getFindSupport().getFindProperties());
            this.revertMap();
            this.findWhat.setModel(this.findHistory);
            this.findWhat.getEditor().setItem(this.getProperty(this.findWhat));
            Component editorC = this.findWhat.getEditor().getEditorComponent();
            if (editorC instanceof JComponent) {
                InputMap inputMap = ((JComponent)editorC).getInputMap();
                inputMap.put(KeyStroke.getKeyStroke(155, 1), "paste-from-clipboard");
                inputMap.put(KeyStroke.getKeyStroke(155, 2), "copy-to-clipboard");
            }
            this.replaceWith.setModel(this.replaceHistory);
            this.replaceWith.getEditor().setItem(this.getProperty(this.replaceWith));
            this.highlightSearch.setSelected(this.getBooleanProperty(this.highlightSearch));
            this.incSearch.setSelected(this.getBooleanProperty(this.incSearch));
            this.matchCase.setSelected(this.getBooleanProperty(this.matchCase));
            this.wholeWords.setSelected(this.getBooleanProperty(this.wholeWords));
            this.regExp.setSelected(this.getBooleanProperty(this.regExp));
            this.bwdSearch.setSelected(this.getBooleanProperty(this.bwdSearch));
            this.wrapSearch.setSelected(this.getBooleanProperty(this.wrapSearch));
            this.updateFindDialogUI();
            this.findWhat.getEditor().getEditorComponent().addKeyListener(this);
            this.findWhat.addActionListener(this);
            this.replaceWith.getEditor().getEditorComponent().addKeyListener(this);
            this.replaceWith.addActionListener(this);
            this.highlightSearch.addItemListener(this);
            this.incSearch.addItemListener(this);
            this.matchCase.addItemListener(this);
            this.wholeWords.addItemListener(this);
            this.regExp.addItemListener(this);
            this.bwdSearch.addItemListener(this);
            this.wrapSearch.addItemListener(this);
            this.blockSearch.addItemListener(this);
            historyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt == null || !"find-history-changed-prop".equals(evt.getPropertyName())) {
                        return;
                    }
                    FindPanel.this.updateFindHistory();
                }
            };
            FindSupport.getFindSupport().addPropertyChangeListener(historyChangeListener);
        }

        protected Map getFindProps() {
            return this.findProps;
        }

        private KeyEventBlocker getBlocker() {
            return this.blocker;
        }

        private void putProperty(Object component, Object value) {
            String prop = (String)this.objToProps.get(component);
            if (prop != null) {
                this.findProps.put(prop, value);
            }
        }

        private Object getProperty(Object component) {
            String prop = (String)this.objToProps.get(component);
            return prop != null ? this.findProps.get(prop) : null;
        }

        private boolean getBooleanProperty(Object component) {
            Object prop = this.getProperty(component);
            return prop != null ? (Boolean)prop : false;
        }

        protected void changeVisibility(boolean v) {
            this.replaceWith.setVisible(v);
            this.replaceWithLabel.setVisible(v);
        }

        private void updateFindDialogUI() {
            boolean wrongFindPattern = false;
            boolean wrongReplacePattern = false;
            String what = this.findWhat.getEditor().getItem().toString();
            String toWhat = this.replaceWith.getEditor().getItem().toString();
            if (what == null || what.length() == 0) {
                wrongFindPattern = true;
            }
            if (toWhat == null) {
                wrongReplacePattern = true;
            }
            if (this.regExp.isSelected()) {
                Pattern searchPattern = null;
                int numGroups = 0;
                if (!wrongFindPattern) {
                    try {
                        searchPattern = Pattern.compile(what);
                        numGroups = searchPattern.matcher("").groupCount();
                    }
                    catch (PatternSyntaxException ex) {
                        wrongFindPattern = true;
                    }
                }
                if (!wrongReplacePattern) {
                    String pseudoText = "0123456789";
                    String pseudoWhat = "";
                    for (int i = 0; i < numGroups; ++i) {
                        pseudoWhat = pseudoWhat + "(" + i + ")";
                    }
                    Pattern pseudoP = Pattern.compile(pseudoWhat);
                    try {
                        pseudoP.matcher(pseudoText).replaceFirst(toWhat);
                    }
                    catch (Exception ex) {
                        wrongReplacePattern = true;
                    }
                }
            }
            findButtons[0].setEnabled(!wrongFindPattern);
            findButtons[1].setEnabled(!wrongReplacePattern && !wrongFindPattern);
            findButtons[2].setEnabled(!wrongReplacePattern && !wrongFindPattern);
            this.findWhat.getEditor().getEditorComponent().setForeground(wrongFindPattern ? Color.RED : UIManager.getColor("textText"));
            this.replaceWith.getEditor().getEditorComponent().setForeground(wrongReplacePattern ? Color.RED : UIManager.getColor("textText"));
        }

        private void resetBlockSearch() {
            this.findProps.put("find-block-search", Boolean.FALSE);
            FindSupport.getFindSupport().setBlockSearchHighlight(0, 0);
            FindSupport.getFindSupport().putFindProperties(this.findProps);
        }

        private void initBlockSearch() {
            JTextComponent c = Utilities.getLastActiveComponent();
            String selText = null;
            boolean invokedViaKeystroke = dialogInvokedViaKeystroke;
            dialogInvokedViaKeystroke = false;
            if (c != null) {
                boolean multiLineSelection;
                Document doc = c.getDocument();
                int blockSearchStartOffset = c.getSelectionStart();
                int blockSearchEndOffset = c.getSelectionEnd();
                try {
                    this.blockSearchStartPos = doc.createPosition(blockSearchStartOffset);
                    this.blockSearchEndPos = doc.createPosition(blockSearchEndOffset);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                BaseDocument bdoc = (BaseDocument)doc;
                try {
                    multiLineSelection = blockSearchEndOffset != blockSearchStartOffset && doc instanceof BaseDocument && Utilities.getLineOffset((BaseDocument)doc, blockSearchEndOffset) > Utilities.getLineOffset((BaseDocument)doc, blockSearchStartOffset);
                }
                catch (BadLocationException ble) {
                    multiLineSelection = false;
                }
                FindDialogSupport.this.caretPosition = this.bwdSearch.isSelected() ? blockSearchEndOffset : blockSearchStartOffset;
                if (!multiLineSelection && invokedViaKeystroke && (selText = c.getSelectedText()) != null && selText.length() > 0) {
                    int n = selText.indexOf(10);
                    if (n >= 0) {
                        selText = selText.substring(0, n);
                    }
                    this.findWhat.getEditor().setItem(selText);
                }
                if (invokedViaKeystroke) {
                    expectedBlockSearchItemChange = true;
                    this.blockSearch.setSelected(multiLineSelection);
                }
                this.findProps.put("find-block-search", this.blockSearch.isSelected());
                this.findProps.put("find-block-search-start", this.blockSearchStartPos);
                this.findProps.put("find-block-search-end", this.blockSearchEndPos);
                FindSupport.getFindSupport().setBlockSearchHighlight(blockSearchStartOffset, blockSearchEndOffset);
            }
        }

        protected void init(boolean isReplace, KeyEventBlocker blocker) {
            this.blocker = blocker;
            this.findHistory.setSelectedItem(null);
            this.replaceHistory.setSelectedItem(null);
            this.findWhat.getEditor().getEditorComponent().addFocusListener(this);
            if (isReplace) {
                this.replaceWith.getEditor().getEditorComponent().addFocusListener(this);
            }
            this.findProps.putAll(FindSupport.getFindSupport().getFindProperties());
            this.revertMap();
            this.highlightSearch.setSelected(this.getBooleanProperty(this.highlightSearch));
            this.incSearch.setSelected(this.getBooleanProperty(this.incSearch));
            this.matchCase.setSelected(this.getBooleanProperty(this.matchCase));
            this.wholeWords.setSelected(this.getBooleanProperty(this.wholeWords));
            boolean regExpValue = this.getBooleanProperty(this.regExp);
            this.regExp.setSelected(regExpValue);
            this.wholeWords.setEnabled(!regExpValue);
            this.incSearch.setEnabled(!regExpValue);
            this.bwdSearch.setSelected(this.getBooleanProperty(this.bwdSearch));
            this.wrapSearch.setSelected(this.getBooleanProperty(this.wrapSearch));
            this.findHistory = new DefaultComboBoxModel(FindDialogSupport.this.getHistoryVector());
            this.findWhat.setModel(this.findHistory);
        }

        protected void reset() {
            this.blocker = null;
        }

        protected void showNotify() {
            boolean focused = this.findWhat.getEditor().getEditorComponent().requestFocusInWindow();
            if (!focused) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FindPanel.this.findWhat.getEditor().getEditorComponent().requestFocusInWindow();
                    }
                });
            }
        }

        private void updateHistory(JComboBox c, DefaultComboBoxModel history) {
            Object item = c.getEditor().getItem();
            if (item != null && !item.equals("")) {
                history.removeElement(item);
                history.insertElementAt(item, 0);
                history.setSelectedItem(null);
            }
            c.getEditor().setItem(item);
        }

        protected void updateFindHistory() {
            Object obj = this.findWhat.getEditor().getItem();
            this.findHistory = new DefaultComboBoxModel(FindDialogSupport.this.getHistoryVector());
            this.findWhat.setModel(this.findHistory);
            if (obj != null) {
                this.findWhat.getEditor().setItem(obj);
            }
        }

        protected void updateReplaceHistory() {
            this.updateHistory(this.replaceWith, this.replaceHistory);
        }

        private void revertMap() {
            Object prop = this.findProps.get("revert-map");
            if (!(prop instanceof Map)) {
                return;
            }
            Map revertMap = (Map)prop;
            for (String key : revertMap.keySet()) {
                boolean value;
                Object obj = this.findProps.get(key);
                boolean bl = value = obj != null ? (Boolean)obj : false;
                if (value != (Boolean)revertMap.get(key)) {
                    // empty if block
                }
                this.findProps.put(key, value ? Boolean.FALSE : Boolean.TRUE);
            }
            this.findProps.put("revert-map", null);
        }

        private void changeFindWhat(boolean performIncSearch) {
            Object old = this.getProperty(this.findWhat);
            Object cur = this.findWhat.getEditor().getItem();
            if (old == null && cur != null && !cur.equals("") || old != null && !old.equals(cur)) {
                this.putProperty(this.findWhat, cur);
                if (performIncSearch) {
                    FindDialogSupport.this.findPerformed = FindSupport.getFindSupport().incSearch(this.getFindProps(), FindDialogSupport.this.caretPosition);
                }
            }
        }

        private void changeReplaceWith() {
            Object old = this.getProperty(this.replaceWith);
            Object cur = this.replaceWith.getEditor().getItem();
            if (old == null && cur != null && !cur.equals("") || old != null && !old.equals(cur)) {
                this.putProperty(this.replaceWith, cur);
            }
        }

        private void postChangeCombos(final boolean performIncSearch) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindPanel.this.updateFindDialogUI();
                    FindPanel.this.changeFindWhat(performIncSearch);
                    FindPanel.this.changeReplaceWith();
                }
            });
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyChar() == '\n') {
                evt.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            if (evt.getKeyChar() == '\n') {
                evt.consume();
            } else if (evt.getKeyCode() == 155) {
                this.postChangeCombos(true);
            }
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            if (evt.getKeyChar() == '\n') {
                findButtons[0].doClick(20);
                evt.consume();
                ((JComboBox)((JTextField)evt.getSource()).getParent()).hidePopup();
            } else {
                this.postChangeCombos(true);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            boolean value;
            Boolean val;
            Boolean bl = val = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
            if (evt.getItem() == this.bwdSearch && this.blockSearch.isSelected()) {
                value = val;
                JTextComponent c = Utilities.getLastActiveComponent();
                if (c != null) {
                    Position pos = value ? this.blockSearchEndPos : this.blockSearchStartPos;
                    c.getCaret().setDot(pos.getOffset());
                    FindDialogSupport.this.updateCaretPosition();
                }
            }
            if (evt.getItem() == this.regExp) {
                value = val == false;
                this.incSearch.setEnabled(value);
                this.wholeWords.setEnabled(value);
                this.updateFindDialogUI();
            }
            if (evt.getItem() == this.blockSearch) {
                boolean expectedChange = expectedBlockSearchItemChange;
                expectedBlockSearchItemChange = false;
                boolean value2 = val;
                if (value2) {
                    JTextComponent c;
                    if (!expectedChange && (c = Utilities.getLastActiveComponent()) != null) {
                        Position pos = this.bwdSearch.isSelected() ? this.blockSearchEndPos : this.blockSearchStartPos;
                        c.getCaret().setDot(pos.getOffset());
                        FindDialogSupport.this.updateCaretPosition();
                        FindDialogSupport.this.findPerformed = FindSupport.getFindSupport().incSearch(this.getFindProps(), FindDialogSupport.this.caretPosition);
                    }
                    FindSupport.getFindSupport().setBlockSearchHighlight(this.blockSearchStartPos.getOffset(), this.blockSearchEndPos.getOffset());
                } else {
                    FindSupport.getFindSupport().putFindProperty("find-block-search", Boolean.FALSE);
                    FindSupport.getFindSupport().setBlockSearchHighlight(0, 0);
                }
            }
            this.putProperty(evt.getSource(), val);
            if (evt.getItem() == this.regExp) {
                this.updateFindHistory();
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.postChangeCombos(false);
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof JTextField) {
                ((JTextField)e.getSource()).selectAll();
                if (this.blocker != null) {
                    this.blocker.stopBlocking();
                }
            }
            ((JComponent)e.getSource()).removeFocusListener(this);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

