/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring;

import java.util.HashSet;
import java.util.Set;
import javax.swing.text.Position;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.api.parser.SourceUtils;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoring;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoringElement;
import org.netbeans.modules.groovy.refactoring.Utils;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class GroovyWhereUsed
extends ProgressProviderAdapter
implements GroovyRefactoring {
    private final WhereUsedQuery whereUsedQuery;
    private final FileObject fileObject;
    private final String fqn;

    public GroovyWhereUsed(FileObject fileObject, String string, WhereUsedQuery whereUsedQuery) {
        this.fqn = string;
        this.fileObject = fileObject;
        this.whereUsedQuery = whereUsedQuery;
    }

    @Override
    public Problem prepare(final RefactoringElementsBag refactoringElementsBag) {
        Set<FileObject> set = this.getRelevantFiles();
        for (final FileObject fileObject : set) {
            try {
                SourceUtils.runUserActionTask((FileObject)fileObject, (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        GroovyParserResult groovyParserResult = AstUtilities.getParseResult((Parser.Result)resultIterator.getParserResult());
                        ModuleNode moduleNode = groovyParserResult.getRootElement().getModuleNode();
                        Set<ASTNode> set = new UsagesVisitor(moduleNode, GroovyWhereUsed.this.fqn).findUsages();
                        BaseDocument baseDocument = Utils.getDocument((ParserResult)groovyParserResult, fileObject);
                        for (ASTNode aSTNode : set) {
                            refactoringElementsBag.add((AbstractRefactoring)GroovyWhereUsed.this.whereUsedQuery, (RefactoringElementImplementation)new WhereUsedElement(new GroovyRefactoringElement(groovyParserResult, moduleNode, aSTNode, fileObject), baseDocument));
                        }
                    }
                });
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    @Override
    public Problem preCheck() {
        return null;
    }

    private Set<FileObject> getRelevantFiles() {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        hashSet.addAll(Utils.getGroovyFilesInProject(this.fileObject));
        return hashSet;
    }

    private static class UsagesVisitor
    extends ClassCodeVisitorSupport {
        private final ModuleNode moduleNode;
        private final String fqn;
        private final Set<ASTNode> usages = new HashSet<ASTNode>();

        public UsagesVisitor(ModuleNode moduleNode, String string) {
            this.moduleNode = moduleNode;
            this.fqn = string;
        }

        public Set<ASTNode> findUsages() {
            for (Object e : this.moduleNode.getClasses()) {
                this.visitClass((ClassNode)e);
            }
            return this.usages;
        }

        protected SourceUnit getSourceUnit() {
            return this.moduleNode.getContext();
        }

        public void visitDeclarationExpression(DeclarationExpression declarationExpression) {
            VariableExpression variableExpression = declarationExpression.getVariableExpression();
            ClassNode classNode = variableExpression.getType();
            if (this.fqn.equals(classNode.getName())) {
                this.usages.add((ASTNode)variableExpression);
            }
            super.visitDeclarationExpression(declarationExpression);
        }

        public void visitField(FieldNode fieldNode) {
            if (this.fqn.equals(fieldNode.getType().getName())) {
                this.usages.add((ASTNode)fieldNode);
            }
            super.visitField(fieldNode);
        }
    }

    private static class WhereUsedElement
    extends SimpleRefactoringElementImplementation {
        private final GroovyRefactoringElement element;
        private final BaseDocument doc;

        public WhereUsedElement(GroovyRefactoringElement groovyRefactoringElement, BaseDocument baseDocument) {
            this.element = groovyRefactoringElement;
            this.doc = baseDocument;
        }

        public String getText() {
            return this.element.getName() + " -";
        }

        public String getDisplayText() {
            Line line = Utils.getLine(this.element.getFileObject(), this.element.getNode().getLineNumber() - 1);
            return line.getText().trim();
        }

        public void performChange() {
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.element.getFileObject();
        }

        public PositionBounds getPosition() {
            OffsetRange offsetRange = AstUtilities.getRange((ASTNode)this.element.getNode(), (BaseDocument)this.doc);
            if (offsetRange == OffsetRange.NONE) {
                return null;
            }
            CloneableEditorSupport cloneableEditorSupport = Utils.findCloneableEditorSupport(this.element.getFileObject());
            PositionRef positionRef = cloneableEditorSupport.createPositionRef(offsetRange.getStart(), Position.Bias.Forward);
            PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(offsetRange.getEnd(), Position.Bias.Forward);
            return new PositionBounds(positionRef, positionRef2);
        }
    }
}

