/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.dashboard.ProjectNode;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class SectionNode
extends TreeListNode
implements PropertyChangeListener {
    private final String displayName;
    private final String propertyName;
    JLabel lblName;
    private TreeListNode.ProgressLabel lblStatus;
    private JLabel lblError;
    private JPanel panel;
    protected final ProjectHandle project;

    public SectionNode(String displayName, ProjectNode parent, String propertyName) {
        super(true, parent);
        this.displayName = displayName;
        this.propertyName = propertyName;
        this.project = parent.getProject();
        this.project.addPropertyChangeListener(this);
    }

    @Override
    protected JComponent getComponent(Color foreground, Color background, boolean isSelected, boolean hasFocus) {
        if (null == this.panel) {
            this.panel = new JPanel(new GridBagLayout());
            this.panel.setOpaque(false);
            this.lblName = new TreeLabel(this.displayName);
            this.lblStatus = this.createProgressLabel(NbBundle.getMessage(SectionNode.class, (String)"LBL_LoadingInProgress"));
            this.lblError = new TreeLabel();
            this.lblStatus.setVisible(false);
            this.lblError.setVisible(false);
            Image img = ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/ui/resources/error.png");
            this.lblError.setIcon(new ImageIcon(img));
            this.panel.add((Component)this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.lblStatus, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            this.panel.add((Component)this.lblError, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.lblName.setForeground(foreground);
        if (isSelected) {
            this.lblStatus.setForeground(foreground);
        } else {
            this.lblStatus.setForeground(ColorManager.getDefault().getDisabledColor());
        }
        if (isSelected) {
            this.lblError.setForeground(foreground);
        } else {
            this.lblError.setForeground(ColorManager.getDefault().getErrorColor());
        }
        return this.panel;
    }

    @Override
    public final void propertyChange(PropertyChangeEvent evt) {
        if (this.propertyName.equals(evt.getPropertyName())) {
            this.refreshChildren();
        }
    }

    @Override
    protected void childrenLoadingFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SectionNode.this.lblStatus.setVisible(false);
                SectionNode.this.lblError.setVisible(false);
                SectionNode.this.fireContentChanged();
            }
        });
    }

    @Override
    protected void childrenLoadingStarted() {
        this.lblStatus.setVisible(true);
        this.lblError.setVisible(false);
        this.fireContentChanged();
    }

    @Override
    protected void childrenLoadingTimedout() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SectionNode.this.lblError.setText(NbBundle.getMessage(SectionNode.class, (String)"LBL_NotResponding"));
                SectionNode.this.lblError.setVisible(true);
                SectionNode.this.lblStatus.setVisible(false);
                SectionNode.this.fireContentChanged();
            }
        });
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.project.removePropertyChangeListener(this);
    }
}

