/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.visitor;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.impl.SchemaGeneratorUtil;
import org.netbeans.modules.xml.axi.visitor.DeepAXITreeVisitor;
import org.netbeans.modules.xml.schema.model.SchemaModel;

public class AXINonCyclicVisitor
extends DeepAXITreeVisitor {
    List<AXIComponent> path = null;
    private AXIModel am;
    private SchemaModel sm;

    public AXINonCyclicVisitor(AXIModel am) {
        this.am = am;
        this.sm = am.getSchemaModel();
        this.path = new ArrayList<AXIComponent>();
    }

    public void expand(AXIDocument root) {
        this.path.clear();
        if (root != null) {
            for (AXIComponent c : root.getChildren()) {
                c.accept(this);
            }
        }
    }

    public void expand(List<Element> elements) {
        this.path.clear();
        for (Element e : elements) {
            e.accept(this);
        }
    }

    @Override
    public void visit(Element e) {
        if (!this.canVisit(e)) {
            return;
        }
        this.visitChildren(e);
    }

    public boolean canVisit(Element e) {
        Element orig = this.getOriginalElement(e);
        return SchemaGeneratorUtil.fromSameSchemaModel(orig, this.sm) && (this.path.size() <= 0 || !this.path.contains(orig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitChildren(Element e) {
        Element orig = this.getOriginalElement(e);
        this.path.add(orig);
        try {
            super.visit(e);
        }
        finally {
            this.path.remove(this.path.size() - 1);
        }
    }

    private Element getOriginalElement(Element e) {
        Element orig = e;
        if (orig.isReference()) {
            orig = SchemaGeneratorUtil.findOriginalElement(e);
        }
        return orig;
    }
}

