/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.util.EnumSet;
import java.util.Set;
import javax.swing.Icon;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;

public final class MemberInfo<H> {
    private final H member;
    private final String htmlText;
    private final Icon icon;
    private final Group group;
    private final Set<CsmVisibility> visibility;
    private boolean makeAbstract;
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public H getElementHandle() {
        return this.member;
    }

    public String getHtmlText() {
        return this.htmlText;
    }

    public static <T extends CsmMember> MemberInfo<T> create(T elem) {
        CharSequence htmlText = elem.getName();
        Group g = null;
        if (CsmKindUtilities.isField(elem)) {
            CsmField field = (CsmField)elem;
            htmlText = ((Object)field.getName()).toString() + ": " + field.getType().getText();
            g = Group.FIELD;
        } else if (CsmKindUtilities.isMethod(elem)) {
            CsmMethod method = (CsmMethod)elem;
            htmlText = method.getSignature() + ": " + method.getReturnType().getText();
            g = Group.METHOD;
        }
        MemberInfo<T> mi = new MemberInfo<T>(elem, ((Object)htmlText).toString(), CsmImageLoader.getIcon(elem), ((Object)elem.getName()).toString(), g, EnumSet.of(elem.getVisibility()), false);
        return mi;
    }

    private MemberInfo(H handle, String htmlText, Icon icon, String name, Group group, Set<CsmVisibility> modifiers, boolean makeAbstract) {
        this.member = handle;
        this.htmlText = htmlText;
        this.icon = icon;
        this.name = name;
        this.group = group;
        this.visibility = modifiers;
        this.makeAbstract = makeAbstract;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Group getGroup() {
        return this.group;
    }

    public boolean equals(Object o) {
        if (o instanceof MemberInfo && ((MemberInfo)o).member instanceof CsmObject) {
            return ((CsmObject)((MemberInfo)o).member).equals((CsmObject)this.member);
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public Set<CsmVisibility> getModifiers() {
        return this.visibility;
    }

    public boolean isMakeAbstract() {
        return this.makeAbstract;
    }

    public void setMakeAbstract(Boolean b) {
        this.makeAbstract = b;
    }

    public String toString() {
        return this.htmlText;
    }

    public static enum Group {
        NONE,
        METHOD,
        FIELD,
        TYPE;

    }
}

