/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import org.netbeans.modules.beans.BeanUtils;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyPattern;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class PropertyPatternNode
extends PatternNode {
    public PropertyPatternNode(PropertyPattern propertyPattern, boolean bl) {
        super(propertyPattern, Children.LEAF, bl);
        this.superSetName(propertyPattern.getName());
    }

    String getTypeForHint() {
        return BeanUtils.getString("HINT_Property");
    }

    @Override
    public String getShortDescription() {
        String string;
        switch (((PropertyPattern)this.pattern).getMode()) {
            case 1: {
                string = BeanUtils.getString("HINT_ReadWriteProperty");
                break;
            }
            case 2: {
                string = BeanUtils.getString("HINT_ReadOnlyProperty");
                break;
            }
            case 4: {
                string = BeanUtils.getString("HINT_WriteOnlyProperty");
                break;
            }
            default: {
                string = "";
            }
        }
        return string + " " + this.getTypeForHint() + " : " + this.getName();
    }

    public Node cloneNode() {
        return new PropertyPatternNode((PropertyPattern)this.pattern, this.writeable);
    }

    @Override
    protected void setPatternName(String string) {
        if (this.pattern.getName().equals(string)) {
            return;
        }
        if (this.testNameValidity(string)) {
            ((PropertyPattern)this.pattern).setName(string);
        }
    }

    boolean testNameValidity(String string) {
        if (!Utilities.isJavaIdentifier((String)string)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)BeanUtils.getString("MSG_Not_Valid_Identifier"), 0));
            return false;
        }
        return true;
    }

    void fire() {
        this.firePropertyChange(null, null, null);
    }
}

