/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.EventBaseCondition;
import com.sun.perseus.model.IntervalTimeInstance;
import com.sun.perseus.model.ModelEvent;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.Time;
import com.sun.perseus.model.TimeCondition;
import com.sun.perseus.model.TimeContainerRootSupport;
import com.sun.perseus.model.TimeContainerSupport;
import com.sun.perseus.model.TimeDependent;
import com.sun.perseus.model.TimeInstance;
import com.sun.perseus.model.TimeInterval;
import java.util.Vector;

public class TimedElementSupport {
    public static final String LAST_DUR_END_EVENT_TYPE = "lastDurEndEvent";
    public static final String SEEK_END_EVENT_TYPE = "seekEndEvent";
    public static final String SEEK_BEGIN_EVENT_TYPE = "seekBeginEvent";
    public static final String END_EVENT_TYPE = "endEvent";
    public static final String BEGIN_EVENT_TYPE = "beginEvent";
    public static final String REPEAT_EVENT_TYPE = "repeat";
    public static final int RESTART_ALWAYS = 1;
    public static final int RESTART_WHEN_NOT_ACTIVE = 2;
    public static final int RESTART_NEVER = 3;
    public static final int FILL_BEHAVIOR_REMOVE = 1;
    public static final int FILL_BEHAVIOR_FREEZE = 2;
    protected static final int STATE_PRE_INIT = 1;
    protected static final int STATE_NO_INTERVAL = 2;
    protected static final int STATE_WAITING_INTERVAL_0 = 3;
    protected static final int STATE_WAITING_INTERVAL_N = 4;
    protected static final int STATE_PLAYING = 5;
    protected static final int STATE_FILL = 6;
    protected final Time eventTime = new Time(0L);
    int state = 1;
    boolean playFill = false;
    int curIter = 0;
    Time dur = Time.INDEFINITE;
    float repeatCount = Float.NaN;
    Time repeatDur = null;
    Time implicitDuration = Time.UNRESOLVED;
    Time min = new Time(0L);
    Time max = Time.INDEFINITE;
    int restart = 1;
    int fillBehavior = 1;
    protected TimeContainerSupport timeContainer;
    TimeInterval currentInterval;
    long lastSampleTime = -1L;
    Time simpleDur = Time.UNRESOLVED;
    TimeInterval previousInterval;
    Vector beginInstances = new Vector(1);
    Vector endInstances = new Vector(1);
    Vector beginConditions = new Vector(1);
    Vector endConditions = new Vector(1);
    Vector beginDependents;
    Vector endDependents;
    ModelNode animationElement;
    boolean timingUpdate = false;
    boolean seeking = false;

    public void setRepeatDur(Time repeatDur) {
        this.checkPreInit();
        this.repeatDur = repeatDur;
    }

    public void setRepeatCount(float repeatCount) {
        this.checkPreInit();
        if (repeatCount <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.repeatCount = repeatCount;
    }

    public void setRestart(int restart) {
        this.checkPreInit();
        switch (restart) {
            case 1: 
            case 2: 
            case 3: {
                this.restart = restart;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMax(Time max) {
        this.checkPreInit();
        if (max == null) {
            throw new IllegalArgumentException();
        }
        this.max = max;
    }

    public void setMin(Time min) {
        this.checkPreInit();
        if (min == null) {
            throw new IllegalArgumentException();
        }
        this.min = min;
    }

    public void setDur(Time dur) {
        this.checkPreInit();
        this.dur = dur;
    }

    public void setFillBehavior(int fillBehavior) {
        this.checkPreInit();
        switch (fillBehavior) {
            case 1: 
            case 2: {
                this.fillBehavior = fillBehavior;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void checkPreInit() {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
    }

    public void begin() {
        this.beginAt(0L);
    }

    public void end() {
        this.endAt(0L);
    }

    public void beginAt(long offset) {
        this.addInstance(true, offset);
    }

    public void endAt(long offset) {
        this.addInstance(false, offset);
    }

    void addInstance(boolean isBegin, long offset) {
        Time currentTime = this.getCurrentTime();
        if (!currentTime.isResolved()) {
            return;
        }
        Time newTime = new Time(currentTime.value + offset);
        TimeInstance newInstance = new TimeInstance(this, newTime, true, isBegin);
    }

    protected void setTimeContainer(TimeContainerSupport timeContainer) {
        if (this.timeContainer != null) {
            this.timeContainer.timedElementChildren.removeElement(this);
        }
        this.timeContainer = timeContainer;
        if (timeContainer != null) {
            timeContainer.timedElementChildren.addElement(this);
            if (timeContainer.state != 1) {
                this.initialize();
            }
        }
    }

    protected TimeContainerSupport getTimeContainer() {
        return this.timeContainer;
    }

    protected void initialize() {
        this.reset();
        if (!this.checkNewInterval(this.computeFirstInterval())) {
            this.state = 2;
        }
    }

    void dispatchOnNewInterval() {
        int i;
        int n = this.beginDependents == null ? 0 : this.beginDependents.size();
        for (i = 0; i < n; ++i) {
            ((TimeDependent)this.beginDependents.elementAt(i)).onNewInterval(this);
        }
        n = this.endDependents == null ? 0 : this.endDependents.size();
        for (i = 0; i < n; ++i) {
            ((TimeDependent)this.endDependents.elementAt(i)).onNewInterval(this);
        }
    }

    Time getTimeAfter(Time after, Vector instances) {
        int n = instances.size();
        for (int i = 0; i < n; ++i) {
            TimeInstance timeInstance = (TimeInstance)instances.elementAt(i);
            if (!timeInstance.time.greaterThan(after)) continue;
            return timeInstance.time;
        }
        return null;
    }

    Time getTimeAfterStrict(Time after, Vector instances) {
        int n = instances.size();
        for (int i = 0; i < n; ++i) {
            TimeInstance timeInstance = (TimeInstance)instances.elementAt(i);
            if (after.greaterThan(timeInstance.time)) continue;
            return timeInstance.time;
        }
        return null;
    }

    Time calculateActiveEnd(Time begin, Time end) {
        Time restartBegin;
        Time result = end;
        Time pad = null;
        if (begin == null) {
            throw new NullPointerException();
        }
        if (!begin.isResolved()) {
            throw new IllegalArgumentException();
        }
        if (end != null && this.dur == null && this.repeatDur == null && Float.isNaN(this.repeatCount)) {
            pad = end.isResolved() ? new Time(end.value - begin.value) : (end == Time.INDEFINITE ? Time.INDEFINITE : Time.UNRESOLVED);
        } else if (end == null || end == Time.INDEFINITE) {
            pad = this.calculateIntermediateActiveDuration(this.computeSimpleDuration(end));
        } else {
            pad = this.calculateIntermediateActiveDuration(this.computeSimpleDuration(end));
            Time pad2 = Time.UNRESOLVED;
            if (end.isResolved()) {
                pad2 = new Time(end.value - begin.value);
            }
            if (pad.greaterThan(pad2)) {
                pad = pad2;
            }
        }
        boolean doMinMax = true;
        if (this.min != null && this.max != null && !this.max.greaterThan(this.min)) {
            doMinMax = false;
        }
        Time ad = null;
        ad = pad.isResolved() ? new Time(pad.value) : pad;
        if (doMinMax) {
            if (this.min != null && this.min.greaterThan(ad)) {
                if (this.min.isResolved()) {
                    ad.value = this.min.value;
                } else {
                    ad = this.min;
                }
            }
            if (this.max != null && !this.max.greaterThan(ad)) {
                if (this.max == Time.INDEFINITE) {
                    ad = Time.INDEFINITE;
                } else if (ad.isResolved()) {
                    ad.value = this.max.value;
                } else {
                    ad = new Time(this.max.value);
                }
            }
        }
        if (ad.isResolved()) {
            ad.value += begin.value;
        }
        if (this.restart == 1 && (restartBegin = this.getTimeAfterStrict(begin, this.beginInstances)) != null && ad.greaterThan(restartBegin)) {
            ad.value = restartBegin.value;
        }
        return ad;
    }

    final Time calculateIntermediateActiveDuration(Time p0) {
        if (p0 == null) {
            throw new NullPointerException();
        }
        if (p0.isResolved() && p0.value == 0L) {
            return new Time(0L);
        }
        if (this.repeatDur == null && Float.isNaN(this.repeatCount)) {
            return p0;
        }
        Time p1 = Time.INDEFINITE;
        Time p2 = this.repeatDur;
        Time iad = Time.UNRESOLVED;
        if (!Float.isNaN(this.repeatCount)) {
            p1 = p0.isResolved() ? (this.repeatCount == Float.MAX_VALUE ? Time.INDEFINITE : new Time((long)((float)p0.value * this.repeatCount))) : p0;
        }
        if (p2 == null) {
            p2 = Time.INDEFINITE;
        }
        if (!p2.greaterThan(iad = Time.INDEFINITE)) {
            iad = p2;
        }
        if (!p1.greaterThan(iad)) {
            iad = p1;
        }
        return iad;
    }

    final Time computeSimpleDuration(Time end) {
        Time implicitDur = this.getImplicitElementDuration();
        if (this.dur == null && this.repeatDur == null && Float.isNaN(this.repeatCount) && end != Time.UNRESOLVED) {
            return Time.INDEFINITE;
        }
        if (this.dur != null && this.dur != Time.UNRESOLVED) {
            return this.dur;
        }
        if (implicitDur != Time.UNRESOLVED) {
            return implicitDur;
        }
        return Time.UNRESOLVED;
    }

    protected Time getImplicitElementDuration() {
        return this.implicitDuration;
    }

    boolean endHasEventConditions() {
        for (int i = 0; i < this.endConditions.size(); ++i) {
            if (!(this.endConditions.elementAt(i) instanceof EventBaseCondition)) continue;
            return true;
        }
        return false;
    }

    TimeInterval computeLastDur(TimeInterval ti) {
        Time simpleDur = this.computeSimpleDuration(ti.end);
        if (simpleDur != null) {
            Time iad = this.calculateIntermediateActiveDuration(simpleDur);
            if (iad.isResolved()) {
                ti.lastDur = new Time(ti.begin.value + iad.value);
                if (ti.lastDur.greaterThan(ti.end)) {
                    ti.lastDur = ti.end;
                }
            } else {
                ti.lastDur = ti.end;
            }
        } else {
            ti.lastDur = ti.end;
        }
        return ti;
    }

    TimeInterval computeFirstInterval() {
        Time beginAfter = new Time(Long.MIN_VALUE);
        Time parentSimpleEnd = this.getContainerSimpleDuration();
        Time tempBegin;
        while ((tempBegin = this.getTimeAfter(beginAfter, this.beginInstances)) != null) {
            if (tempBegin.greaterThan(parentSimpleEnd)) {
                return null;
            }
            Time tempEnd = null;
            if (this.endConditions.size() == 0) {
                tempEnd = this.calculateActiveEnd(tempBegin, null);
            } else {
                tempEnd = this.getTimeAfter(tempBegin, this.endInstances);
                if (tempBegin.isSameTime(tempEnd)) {
                    tempEnd = this.getTimeAfterStrict(tempEnd, this.endInstances);
                }
                if (tempEnd == null) {
                    if (this.endHasEventConditions() || this.endInstances.size() == 0) {
                        tempEnd = Time.UNRESOLVED;
                    } else {
                        return null;
                    }
                }
                tempEnd = this.calculateActiveEnd(tempBegin, tempEnd);
            }
            if (!tempEnd.isResolved() || tempEnd.value > 0L) {
                return this.computeLastDur(new TimeInterval(tempBegin, tempEnd));
            }
            beginAfter = tempEnd;
        }
        return null;
    }

    TimeInterval computeNextInterval() {
        Time curEnd;
        Time beginAfter = curEnd = this.previousInterval.end;
        Time parentSimpleEnd = this.getContainerSimpleDuration();
        Time tempBegin = this.getTimeAfter(beginAfter, this.beginInstances);
        if (tempBegin == null) {
            return null;
        }
        if (tempBegin.greaterThan(parentSimpleEnd)) {
            return null;
        }
        Time tempEnd = null;
        if (this.endConditions.size() == 0) {
            Time tempEnd2;
            tempEnd = this.calculateActiveEnd(tempBegin, null);
            if (this.endInstances.size() > 0 && (tempEnd2 = this.getTimeAfter(tempBegin, this.endInstances)) != null && tempEnd2.isResolved()) {
                tempEnd = tempEnd2;
            }
        } else {
            tempEnd = this.getTimeAfter(tempBegin, this.endInstances);
            if (curEnd.isSameTime(tempEnd)) {
                tempEnd = this.getTimeAfterStrict(tempEnd, this.endInstances);
            }
            if (tempEnd == null) {
                if (this.endHasEventConditions() || this.endInstances.size() == 0) {
                    tempEnd = Time.UNRESOLVED;
                } else {
                    return null;
                }
            }
            tempEnd = this.calculateActiveEnd(tempBegin, tempEnd);
        }
        return this.computeLastDur(new TimeInterval(tempBegin, tempEnd));
    }

    Time computeEndTime(Time tempBegin) {
        if (this.endInstances.size() == 0) {
            return this.calculateActiveEnd(tempBegin, null);
        }
        Time tempEnd = this.getTimeAfter(tempBegin, this.endInstances);
        if (tempBegin.isSameTime(tempEnd)) {
            tempEnd = new Time(tempEnd.value + 1L);
            tempEnd = this.getTimeAfter(tempEnd, this.endInstances);
        }
        if (tempEnd == null) {
            if (this.endHasEventConditions() || this.endInstances.size() == 0) {
                tempEnd = Time.UNRESOLVED;
            } else {
                return null;
            }
        }
        return this.calculateActiveEnd(tempBegin, tempEnd);
    }

    void reset() {
        TimeInstance timeInstance;
        int i;
        this.currentInterval = null;
        this.simpleDur = Time.UNRESOLVED;
        this.previousInterval = null;
        this.curIter = 0;
        this.state = 1;
        this.lastSampleTime = -1L;
        int n = this.beginInstances.size();
        for (i = n - 1; i >= 0; --i) {
            timeInstance = (TimeInstance)this.beginInstances.elementAt(i);
            if (timeInstance.clearOnReset) {
                this.beginInstances.removeElementAt(i);
                continue;
            }
            if (!(timeInstance instanceof IntervalTimeInstance)) continue;
            ((IntervalTimeInstance)timeInstance).syncTime();
        }
        n = this.endInstances.size();
        for (i = n - 1; i >= 0; --i) {
            timeInstance = (TimeInstance)this.endInstances.elementAt(i);
            if (timeInstance.clearOnReset) {
                this.endInstances.removeElementAt(i);
                continue;
            }
            if (!(timeInstance instanceof IntervalTimeInstance)) continue;
            ((IntervalTimeInstance)timeInstance).syncTime();
        }
    }

    void removeSyncBaseTimesUnder(TimeContainerSupport syncTimeContainer) {
        IntervalTimeInstance iti;
        TimeInstance timeInstance;
        int i;
        int n = this.beginInstances.size();
        for (i = n - 1; i >= 0; --i) {
            timeInstance = (TimeInstance)this.beginInstances.elementAt(i);
            if (!(timeInstance instanceof IntervalTimeInstance)) continue;
            iti = (IntervalTimeInstance)timeInstance;
            if (!iti.syncBase.isDescendant(syncTimeContainer)) continue;
            this.beginInstances.removeElementAt(i);
            iti.dispose();
        }
        n = this.endInstances.size();
        for (i = n - 1; i >= 0; --i) {
            timeInstance = (TimeInstance)this.endInstances.elementAt(i);
            if (!(timeInstance instanceof IntervalTimeInstance)) continue;
            iti = (IntervalTimeInstance)timeInstance;
            if (!iti.syncBase.isDescendant(syncTimeContainer)) continue;
            this.endInstances.removeElementAt(i);
            iti.dispose();
        }
    }

    boolean isDescendant(TimeContainerSupport parent) {
        if (parent == this) {
            return true;
        }
        if (this.timeContainer != this) {
            return this.timeContainer.isDescendant(parent);
        }
        return false;
    }

    void dispatchBeginEvent(Time currentTime) {
        if (this.animationElement != null) {
            ModelEvent beginEvent = null;
            beginEvent = this.seeking ? this.animationElement.ownerDocument.initEngineEvent(SEEK_BEGIN_EVENT_TYPE, this.animationElement) : this.animationElement.ownerDocument.initEngineEvent(BEGIN_EVENT_TYPE, this.animationElement);
            this.eventTime.value = this.currentInterval.begin.value;
            beginEvent.eventTime = this.toRootContainerSimpleTimeClamp(this.eventTime);
            this.animationElement.dispatchEvent(beginEvent);
        }
        this.dispatchRepeatEvent(currentTime);
    }

    void dispatchLastDurEndEvent() {
        if (this.animationElement != null) {
            ModelEvent event = this.animationElement.ownerDocument.initEngineEvent(LAST_DUR_END_EVENT_TYPE, this.animationElement);
            this.eventTime.value = this.currentInterval.lastDur.value;
            event.eventTime = this.toRootContainerSimpleTimeClamp(this.eventTime);
            this.animationElement.dispatchEvent(event);
        }
    }

    void dispatchSeekEndEvent() {
        if (this.animationElement != null) {
            ModelEvent event = this.animationElement.ownerDocument.initEngineEvent(SEEK_END_EVENT_TYPE, this.animationElement);
            this.animationElement.dispatchEvent(event);
        }
    }

    void dispatchEndEvent(Time currentTime) {
        if (!(this.seeking && this.state != 5 || this.animationElement == null)) {
            ModelEvent endEvent = this.animationElement.ownerDocument.initEngineEvent(END_EVENT_TYPE, this.animationElement);
            if (this.seeking) {
                this.eventTime.value = this.getRootContainer().lastSampleTime.value;
                endEvent.eventTime = this.eventTime;
            } else {
                this.eventTime.value = this.currentInterval.end.value;
                endEvent.eventTime = this.toRootContainerSimpleTimeClamp(this.eventTime);
            }
            this.animationElement.dispatchEvent(endEvent);
        }
        this.dispatchRepeatEvent(currentTime);
    }

    TimeContainerRootSupport getRootContainer() {
        return this.timeContainer.getRootContainer();
    }

    void dispatchRepeatEvent(Time currentTime) {
        if (!this.seeking && this.simpleDur.isResolved() && this.simpleDur.value > 0L) {
            int prevIter = this.curIter;
            Time maxTime = currentTime;
            if (currentTime.greaterThan(this.currentInterval.end)) {
                maxTime = this.currentInterval.end;
            }
            this.curIter = (int)((maxTime.value - this.currentInterval.begin.value) / this.simpleDur.value);
            if (this.curIter < 0) {
                this.curIter = 0;
            }
            if (maxTime.isSameTime(this.currentInterval.end) && (maxTime.value - this.currentInterval.begin.value) % this.simpleDur.value == 0L) {
                --this.curIter;
            }
            if (this.animationElement != null) {
                for (int i = prevIter; i < this.curIter; ++i) {
                    ModelEvent repeatEvent = this.animationElement.ownerDocument.initEngineEvent(REPEAT_EVENT_TYPE, this.animationElement);
                    Time repeatTime = this.eventTime;
                    repeatTime.value = this.currentInterval.begin.value + (long)(i + 1) * this.simpleDur.value;
                    repeatEvent.eventTime = repeatTime = this.toRootContainerSimpleTimeClamp(repeatTime);
                    repeatEvent.repeatCount = i + 1;
                    this.animationElement.dispatchEvent(repeatEvent);
                }
            }
            if (prevIter != this.curIter) {
                this.onStartingRepeat(prevIter, this.curIter);
            }
        }
    }

    protected void onStartingRepeat(int prevIter, int curIter) {
    }

    boolean checkNewInterval(TimeInterval interval) {
        if (interval == null) {
            return false;
        }
        this.currentInterval = interval;
        this.simpleDur = this.computeSimpleDuration(this.currentInterval.end);
        this.state = this.previousInterval == null ? 3 : 4;
        this.dispatchOnNewInterval();
        return true;
    }

    TimeInterval seekToInterval(Time seekToTime) {
        this.previousInterval = null;
        TimeInterval interval = this.computeFirstInterval();
        if (interval == null) {
            return null;
        }
        while (interval != null && seekToTime.greaterThan(interval.end)) {
            this.previousInterval = interval;
            interval = this.computeNextInterval();
        }
        return interval;
    }

    boolean isSeekingBack() {
        return this.getRootContainer().seekingBack;
    }

    /*
     * Enabled aggressive block sorting
     */
    void sample(Time currentTime) {
        boolean endOfInterval = false;
        boolean seekBack = false;
        switch (this.state) {
            default: {
                return;
            }
            case 6: {
                if (!this.seeking || !this.isSeekingBack()) break;
                seekBack = true;
                break;
            }
            case 3: {
                if (!currentTime.greaterThan(this.currentInterval.begin)) break;
                this.dispatchBeginEvent(currentTime);
                if (currentTime.greaterThan(this.currentInterval.end)) {
                    this.dispatchLastDurEndEvent();
                    this.dispatchEndEvent(currentTime);
                    endOfInterval = true;
                }
                this.state = 5;
                this.playFill = false;
                break;
            }
            case 4: {
                if (currentTime.greaterThan(this.currentInterval.begin)) {
                    this.dispatchBeginEvent(currentTime);
                    if (currentTime.greaterThan(this.currentInterval.end)) {
                        this.dispatchLastDurEndEvent();
                        this.dispatchEndEvent(currentTime);
                        endOfInterval = true;
                    }
                    this.state = 5;
                    this.playFill = false;
                    break;
                }
                if (!this.seeking || !this.isSeekingBack()) break;
                seekBack = true;
                break;
            }
            case 5: {
                if (currentTime.greaterThan(this.currentInterval.lastDur) && !this.playFill) {
                    this.dispatchLastDurEndEvent();
                    this.playFill = true;
                }
                if (currentTime.greaterThan(this.currentInterval.end)) {
                    this.dispatchEndEvent(currentTime);
                    endOfInterval = true;
                    break;
                }
                if (!this.seeking) {
                    this.dispatchRepeatEvent(currentTime);
                    break;
                }
                if (!this.currentInterval.begin.greaterThan(currentTime)) break;
                this.dispatchLastDurEndEvent();
                this.dispatchEndEvent(currentTime);
                endOfInterval = true;
                seekBack = true;
            }
        }
        if (endOfInterval) {
            this.previousInterval = this.currentInterval;
            this.currentInterval = null;
            if (this.restart == 3) {
                this.state = 6;
                this.playFill = false;
            } else {
                TimeInterval nextInterval = null;
                nextInterval = !seekBack ? this.computeNextInterval() : this.seekToInterval(currentTime);
                if (!this.checkNewInterval(nextInterval)) {
                    this.state = 6;
                    this.playFill = false;
                }
            }
            this.sample(currentTime);
            return;
        }
        if (seekBack) {
            if (this.state == 6 && this.restart == 3) {
                if (this.previousInterval.end.greaterThan(currentTime)) {
                    this.dispatchSeekEndEvent();
                    this.state = 2;
                    this.playFill = false;
                    return;
                }
            } else {
                TimeInterval seekInterval = this.seekToInterval(currentTime);
                if (seekInterval == null || this.currentInterval == null || !seekInterval.begin.isSameTime(this.currentInterval.begin) || !seekInterval.end.isSameTime(this.currentInterval.end)) {
                    if (this.checkNewInterval(seekInterval)) {
                        this.dispatchSeekEndEvent();
                        this.sample(currentTime);
                        return;
                    }
                    if (this.previousInterval == null) {
                        this.dispatchSeekEndEvent();
                        this.state = 2;
                        this.playFill = false;
                        return;
                    }
                    this.state = 6;
                    this.playFill = false;
                }
            }
        }
        long localTime = 0L;
        switch (this.state) {
            default: {
                throw new IllegalStateException();
            }
            case 4: 
            case 6: {
                if (this.fillBehavior != 2) {
                    return;
                }
                localTime = this.previousInterval.lastDur.value - this.previousInterval.begin.value;
                break;
            }
            case 3: {
                return;
            }
            case 5: {
                localTime = !this.playFill ? currentTime.value - this.currentInterval.begin.value : this.currentInterval.lastDur.value - this.currentInterval.begin.value;
            }
        }
        if (this.simpleDur.isResolved() && (this.state != 5 || this.playFill) && (localTime %= this.simpleDur.value) == 0L) {
            localTime = this.simpleDur.value;
        }
        this.sampleAt(localTime);
        this.lastSampleTime = localTime;
    }

    void sampleAt(long simpleTime) {
    }

    public void activate() {
        TimeInterval firstInterval;
        if (this.state == 5) {
            Time seekToTime = new Time(this.currentInterval.begin.value);
            if ((seekToTime = this.toRootContainerSimpleTimeClamp(seekToTime)).isResolved()) {
                this.seekTo(seekToTime);
                return;
            }
        }
        if ((firstInterval = this.computeFirstInterval()) != null) {
            Time seekToTime = new Time(firstInterval.begin.value);
            if ((seekToTime = this.toRootContainerSimpleTimeClamp(seekToTime)).isResolved()) {
                this.seekTo(seekToTime);
                return;
            }
        }
        this.seekTo(Time.UNRESOLVED);
    }

    void seekTo(Time seekToTime) {
        if (seekToTime.isResolved()) {
            this.timeContainer.seekTo(seekToTime);
        } else {
            TimeInterval firstInterval;
            if (this.timeContainer.state != 5) {
                TimeInterval firstContainerInterval = this.timeContainer.computeFirstInterval();
                if (firstContainerInterval == null) {
                    this.timeContainer.seekTo(Time.UNRESOLVED);
                } else {
                    Time parentSeekTo = new Time(firstContainerInterval.begin.value);
                    parentSeekTo = this.timeContainer.toRootContainerSimpleTimeClamp(parentSeekTo);
                    this.timeContainer.seekTo(parentSeekTo);
                }
            }
            if ((firstInterval = this.computeFirstInterval()) == null) {
                this.begin();
                firstInterval = this.computeFirstInterval();
            }
            Time goToTime = new Time(firstInterval.begin.value);
            if (goToTime.value < 0L) {
                goToTime.value = 0L;
            }
            this.timeContainer.seekTo(this.toRootContainerSimpleTimeClamp(goToTime));
        }
    }

    private void reEvaluateBeginTime() {
        switch (this.state) {
            case 3: {
                TimeInterval curInt = this.computeFirstInterval();
                if (curInt != null) {
                    this.currentInterval.setBegin(curInt.begin);
                    this.currentInterval.setEnd(curInt.end);
                    this.computeLastDur(this.currentInterval);
                    break;
                }
                this.pruneCurrentInterval();
                break;
            }
            case 4: {
                TimeInterval curInt = this.computeNextInterval();
                if (curInt != null) {
                    this.currentInterval.setBegin(curInt.begin);
                    this.currentInterval.setEnd(curInt.end);
                    this.computeLastDur(this.currentInterval);
                } else {
                    this.pruneCurrentInterval();
                }
            }
            default: {
                return;
            }
        }
    }

    void reEvaluateEndTime() {
        switch (this.state) {
            case 3: 
            case 4: 
            case 5: {
                Time newEnd = this.computeEndTime(this.currentInterval.begin);
                if (newEnd == null) break;
                this.currentInterval.setEnd(newEnd);
                this.computeLastDur(this.currentInterval);
                break;
            }
        }
    }

    private void pruneCurrentInterval() {
        TimeInterval prunedInterval = this.currentInterval;
        this.currentInterval = null;
        this.state = this.previousInterval != null ? 6 : 2;
        prunedInterval.prune();
    }

    private void insertTimeInstance(TimeInstance newInstance) {
        Vector instances = this.beginInstances;
        if (!newInstance.isBegin) {
            instances = this.endInstances;
        }
        int n = instances.size();
        int i = 0;
        Time newTime = newInstance.time;
        for (i = 0; i < n; ++i) {
            TimeInstance timeInstance = (TimeInstance)instances.elementAt(i);
            if (newTime.greaterThan(timeInstance.time)) continue;
            instances.insertElementAt(newInstance, i);
            break;
        }
        if (i == n) {
            instances.addElement(newInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addTimeInstance(TimeInstance newInstance) {
        if (this.timingUpdate) {
            return;
        }
        this.timingUpdate = true;
        try {
            this.insertTimeInstance(newInstance);
            if (this.state == 1) {
                return;
            }
            if (!newInstance.isBegin) {
                this.reEvaluateEndTime();
                return;
            }
            switch (this.state) {
                case 2: {
                    this.checkNewInterval(this.computeFirstInterval());
                    return;
                }
                case 6: {
                    if (this.restart == 3) return;
                    this.checkNewInterval(this.computeNextInterval());
                    return;
                }
                case 3: {
                    TimeInterval curInt = this.computeFirstInterval();
                    if (curInt == null) return;
                    this.currentInterval.setBegin(curInt.begin);
                    this.currentInterval.setEnd(curInt.end);
                    this.computeLastDur(this.currentInterval);
                    return;
                }
                case 4: {
                    TimeInterval curInt = this.computeNextInterval();
                    this.currentInterval.setBegin(curInt.begin);
                    this.currentInterval.setEnd(curInt.end);
                    this.computeLastDur(this.currentInterval);
                    return;
                }
                case 5: {
                    if (!newInstance.isBegin || this.restart != 1 || !this.currentInterval.end.greaterThan(newInstance.time) || !newInstance.time.greaterThan(this.currentInterval.begin)) return;
                    this.currentInterval.setEnd(newInstance.time);
                    this.computeLastDur(this.currentInterval);
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.timingUpdate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTimeInstanceUpdate(TimeInstance timeInstance) {
        if (this.timingUpdate) {
            return;
        }
        this.timingUpdate = true;
        try {
            if (timeInstance.isBegin) {
                this.beginInstances.removeElement(timeInstance);
            } else {
                this.endInstances.removeElement(timeInstance);
            }
            this.insertTimeInstance(timeInstance);
            if (this.state == 1) {
                return;
            }
            if (timeInstance.isBegin) {
                this.reEvaluateBeginTime();
            } else {
                this.reEvaluateEndTime();
            }
        }
        finally {
            this.timingUpdate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTimeInstance(TimeInstance timeInstance) {
        if (timeInstance.isBegin) {
            this.beginInstances.removeElement(timeInstance);
        } else {
            this.endInstances.removeElement(timeInstance);
        }
        if (this.timingUpdate) {
            return;
        }
        this.timingUpdate = true;
        try {
            if (this.state != 1) {
                if (timeInstance.isBegin) {
                    this.reEvaluateBeginTime();
                } else {
                    this.reEvaluateEndTime();
                }
            }
        }
        finally {
            this.timingUpdate = false;
        }
    }

    void addTimeCondition(TimeCondition newCondition) {
        if (newCondition.isBegin) {
            this.beginConditions.addElement(newCondition);
        } else {
            this.endConditions.addElement(newCondition);
        }
    }

    boolean hasBeginCondition(EventBaseCondition eventCondition) {
        int n = this.beginConditions.size();
        for (int i = 0; i < n; ++i) {
            TimeCondition condition = (TimeCondition)this.beginConditions.elementAt(i);
            if (!(condition instanceof EventBaseCondition)) continue;
            EventBaseCondition beginCondition = (EventBaseCondition)condition;
            if (!beginCondition.eventType.equals(eventCondition.eventType) || beginCondition.eventBase != eventCondition.eventBase) continue;
            return true;
        }
        return false;
    }

    Time getCurrentTime() {
        return this.timeContainer.getSimpleTime();
    }

    long toWallClockTime(long localTime) {
        return this.timeContainer.toWallClockTime(localTime);
    }

    Time toRootContainerSimpleTime(Time simpleTime) {
        if (this.timeContainer.currentInterval == null) {
            return Time.UNRESOLVED;
        }
        if (!simpleTime.isResolved()) {
            return simpleTime;
        }
        if (this.timeContainer.simpleDur.isResolved()) {
            simpleTime.value += (long)this.timeContainer.curIter * this.timeContainer.simpleDur.value;
        }
        simpleTime.value += this.timeContainer.currentInterval.begin.value;
        return this.timeContainer.toRootContainerSimpleTime(simpleTime);
    }

    Time toRootContainerSimpleTimeClamp(Time simpleTime) {
        long maxDur;
        if (this.timeContainer.currentInterval == null) {
            return Time.UNRESOLVED;
        }
        if (!simpleTime.isResolved()) {
            return simpleTime;
        }
        if (simpleTime.value < 0L) {
            simpleTime.value = 0L;
        }
        if (this.timeContainer.simpleDur.isResolved()) {
            if (simpleTime.value > this.timeContainer.simpleDur.value) {
                simpleTime.value = this.timeContainer.simpleDur.value;
            }
            simpleTime.value += (long)this.timeContainer.curIter * this.timeContainer.simpleDur.value;
        } else if (this.timeContainer.currentInterval.end.isResolved() && simpleTime.value > (maxDur = this.timeContainer.currentInterval.end.value - this.timeContainer.currentInterval.begin.value)) {
            simpleTime.value = maxDur;
        }
        simpleTime.value += this.timeContainer.currentInterval.begin.value;
        return this.timeContainer.toRootContainerSimpleTimeClamp(simpleTime);
    }

    Time toContainerSimpleTime(Time simpleTime) {
        if (this.timeContainer.currentInterval == null) {
            return Time.UNRESOLVED;
        }
        if (!simpleTime.isResolved()) {
            return simpleTime;
        }
        simpleTime = this.timeContainer.toContainerSimpleTime(simpleTime);
        simpleTime.value -= this.timeContainer.currentInterval.begin.value;
        if (this.timeContainer.simpleDur.isResolved()) {
            simpleTime.value -= (long)this.timeContainer.curIter * this.timeContainer.simpleDur.value;
        }
        return simpleTime;
    }

    Time getContainerSimpleDuration() {
        return this.timeContainer.simpleDur;
    }

    public String toString() {
        String str = "[Animation: " + this.animationElement + "] [" + this.getStateString() + "]";
        switch (this.state) {
            case 3: 
            case 4: 
            case 5: {
                str = str + "[" + this.currentInterval.begin + ", " + this.currentInterval.end + "]";
                break;
            }
        }
        return str;
    }

    String getStateString() {
        switch (this.state) {
            case 1: {
                return "PRE_INIT";
            }
            case 3: {
                return "WAITING_INTERVAL_0";
            }
            case 4: {
                return "WAITING_INTERVAL_N";
            }
            case 2: {
                return "NO_INTERVAL";
            }
            case 6: {
                return "FILL";
            }
            case 5: {
                return "PLAYING";
            }
        }
        return "UNKNOWN";
    }
}

