/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.Path;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.j2d.ViewportProperties;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.Messages;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.StructureNode;
import com.sun.perseus.model.Time;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.model.ViewportNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPath;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRGBColor;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public class SVG
extends StructureNode
implements SVGSVGElement,
SVGPoint,
ViewportNode,
PaintTarget {
    protected float[][] viewBox;
    protected int align = 1;
    protected float width = 100.0f;
    protected float height = 100.0f;
    protected float currentScale = 1.0f;
    protected float tx;
    protected float ty;
    protected float currentRotate;
    protected float currentTimeDelta = 0.0f;
    protected PaintServer viewportFill = INITIAL_VIEWPORT_FILL;
    protected float viewportFillOpacity = 1.0f;
    protected String syncBehaviorDefault = "canSlip";
    protected Time syncToleranceDefault = new Time(2000L);

    public SVG(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    public String getLocalName() {
        return "svg";
    }

    public String[][] getDefaultTraits() {
        return new String[][]{{"width", "100%"}, {"height", "100%"}, {"viewport-fill", "none"}, {"viewport-fill-opacity", "1.0"}, {"syncBehaviorDefault", "canSlip"}, {"syncToleranceDefault", "2.0s"}};
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new SVG(doc);
    }

    public void setWidth(float newWidth) {
        if (newWidth < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (newWidth == this.width) {
            return;
        }
        this.modifyingNode();
        this.width = newWidth;
        this.computeCanRenderWidthBit(this.width);
        this.modifiedNode();
    }

    public float getWidth() {
        return this.width;
    }

    public void setHeight(float newHeight) {
        if (newHeight < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (newHeight == this.height) {
            return;
        }
        this.modifyingNode();
        this.height = newHeight;
        this.computeCanRenderHeightBit(this.height);
        this.modifiedNode();
    }

    public float getHeight() {
        return this.height;
    }

    public void setViewBox(float[][] newViewBox) {
        if (newViewBox != null && (newViewBox.length != 3 || newViewBox[0] == null || newViewBox[1] == null || newViewBox[2] == null || newViewBox[0].length != 2 || newViewBox[1][0] < 0.0f || newViewBox[2][0] < 0.0f)) {
            throw new IllegalArgumentException();
        }
        if (SVG.equal(newViewBox, this.viewBox)) {
            return;
        }
        this.modifyingNode();
        if (newViewBox == null) {
            this.viewBox = null;
        } else {
            if (this.viewBox == null) {
                this.viewBox = new float[3][];
                this.viewBox[0] = new float[2];
                this.viewBox[1] = new float[1];
                this.viewBox[2] = new float[1];
            }
            this.viewBox[0][0] = newViewBox[0][0];
            this.viewBox[0][1] = newViewBox[0][1];
            this.viewBox[1][0] = newViewBox[1][0];
            this.viewBox[2][0] = newViewBox[2][0];
        }
        this.recomputeTransformState();
        this.computeCanRenderEmptyViewBoxBit(this.viewBox);
        this.modifiedNode();
    }

    public float[][] getViewBox() {
        return this.viewBox;
    }

    public void setAlign(int newAlign) {
        if (newAlign != 1 && newAlign != 0) {
            throw new IllegalArgumentException();
        }
        if (newAlign == this.align) {
            return;
        }
        this.modifyingNode();
        this.align = newAlign;
        this.recomputeTransformState();
        this.modifiedNode();
    }

    public int getAlign() {
        return this.align;
    }

    protected Object getPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 0x200000: {
                return this.viewportFill;
            }
        }
        return super.getPropertyState(propertyIndex);
    }

    protected float getFloatPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 0x400000: {
                return this.viewportFillOpacity;
            }
        }
        return super.getFloatPropertyState(propertyIndex);
    }

    protected void setPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 0x200000: {
                this.viewportFill = (PaintServer)propertyValue;
                break;
            }
            default: {
                super.setPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected void setFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 0x400000: {
                this.viewportFillOpacity = propertyValue;
                break;
            }
            default: {
                super.setFloatPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected boolean isPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 0x200000: {
                return this.viewportFill == propertyValue;
            }
        }
        return super.isPropertyState(propertyIndex, propertyValue);
    }

    protected boolean isFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 0x400000: {
                return this.viewportFillOpacity == propertyValue;
            }
        }
        return super.isFloatPropertyState(propertyIndex, propertyValue);
    }

    void recomputeInheritedProperties() {
        ModelNode p = this.ownerDocument;
        if (this.parent != null) {
            p = this.parent;
        }
        this.recomputePropertyState(0x200000, p.getPropertyState(0x200000));
        this.recomputeFloatPropertyState(0x400000, p.getFloatPropertyState(0x400000));
        super.recomputeInheritedProperties();
    }

    public void setViewportFill(PaintServer newViewportFill) {
        if (!this.isInherited(0x200000) && SVG.equal(newViewportFill, this.viewportFill)) {
            return;
        }
        this.modifyingNode();
        if (this.viewportFill != null) {
            this.viewportFill.dispose();
        }
        this.viewportFill = newViewportFill;
        this.setInheritedQuiet(0x200000, false);
        this.propagatePropertyState(0x200000, this.viewportFill);
        this.modifiedNode();
    }

    public PaintServer getViewportFill() {
        return this.viewportFill;
    }

    public float getViewportFillOpacity() {
        return this.viewportFillOpacity;
    }

    public void setViewportFillOpacity(float newViewportFillOpacity) {
        if (!this.isInherited(0x400000) && newViewportFillOpacity == this.getViewportFillOpacity()) {
            return;
        }
        this.modifyingNode();
        if (newViewportFillOpacity > 1.0f) {
            newViewportFillOpacity = 1.0f;
        } else if (newViewportFillOpacity < 0.0f) {
            newViewportFillOpacity = 0.0f;
        }
        this.setInheritedQuiet(0x400000, false);
        this.viewportFillOpacity = newViewportFillOpacity;
        this.propagateFloatPropertyState(0x400000, this.viewportFillOpacity);
        this.modifiedNode();
    }

    public String getSyncBehaviorDefault() {
        return this.syncBehaviorDefault;
    }

    public void setSyncBehaviorDefault(String newSyncBehaviorDefault) {
        if (this.syncBehaviorDefault.equals(newSyncBehaviorDefault)) {
            return;
        }
        this.syncBehaviorDefault = newSyncBehaviorDefault;
    }

    public Time getSyncToleranceDefault() {
        return this.syncToleranceDefault;
    }

    public void setSyncToleranceDefault(Time newSyncToleranceDefault) {
        if (this.syncToleranceDefault.equals(newSyncToleranceDefault)) {
            return;
        }
        this.syncToleranceDefault = newSyncToleranceDefault;
    }

    protected Transform appendTransform(Transform tx, Transform workTx) {
        if (this.viewBox == null) {
            return tx;
        }
        tx = this.recycleTransform(tx, workTx);
        DocumentNode vp = this.getOwnerDocument();
        float w = vp.getWidth();
        float h = vp.getHeight();
        SVG.getFittingTransform(this.viewBox[0][0], this.viewBox[0][1], this.viewBox[1][0], this.viewBox[2][0], 0.0f, 0.0f, w, h, this.align, tx);
        return tx;
    }

    boolean supportsTrait(String traitName) {
        if ("baseProfile" == traitName || "version" == traitName || "viewBox" == traitName || "zoomAndPan" == traitName || "width" == traitName || "height" == traitName || "viewport-fill" == traitName || "viewport-fill-opacity" == traitName || "preserveAspectRatio" == traitName || "syncBehaviorDefault" == traitName || "syncToleranceDefault" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    String getSpecifiedTraitImpl(String name) throws DOMException {
        if ("viewport-fill" == name && this.isInherited(0x200000) || "viewport-fill-opacity" == name && this.isInherited(0x400000)) {
            return "inherit";
        }
        return super.getSpecifiedTraitImpl(name);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("version" == name) {
            return "1.1";
        }
        if ("viewBox" == name) {
            if (this.viewBox == null) {
                return "";
            }
            return "" + this.viewBox[0][0] + ',' + this.viewBox[0][1] + ',' + this.viewBox[1][0] + ',' + this.viewBox[2][0];
        }
        if ("zoomAndPan" == name) {
            switch (this.ownerDocument.zoomAndPan) {
                case 0: {
                    return "magnify";
                }
                case 1: {
                    return "disable";
                }
            }
            throw new Error();
        }
        if ("baseProfile" == name) {
            return "tiny";
        }
        if ("width" == name) {
            return Float.toString(this.getWidth());
        }
        if ("height" == name) {
            return Float.toString(this.getHeight());
        }
        if ("preserveAspectRatio" == name) {
            return SVG.alignToStringTrait(this.align);
        }
        if ("viewport-fill" == name) {
            return this.toString(this.getViewportFill());
        }
        if ("viewport-fill-opacity" == name) {
            return Float.toString(this.getViewportFillOpacity());
        }
        if ("syncBehaviorDefault" == name) {
            return this.getSyncBehaviorDefault();
        }
        if ("syncToleranceDefault" == name) {
            return Time.toStringTrait(this.getSyncToleranceDefault());
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("width" == name) {
            return this.getWidth();
        }
        if ("height" == name) {
            return this.getHeight();
        }
        if ("viewport-fill-opacity" == name) {
            return this.getViewportFillOpacity();
        }
        return super.getFloatTraitImpl(name);
    }

    SVGRect getRectTraitImpl(String name) throws DOMException {
        if ("viewBox".equals(name)) {
            return this.toSVGRect(this.viewBox);
        }
        return super.getRectTraitImpl(name);
    }

    SVGRGBColor getRGBColorTraitImpl(String name) throws DOMException {
        if ("viewport-fill".equals(name)) {
            return this.toSVGRGBColor("viewport-fill", this.getViewportFill());
        }
        return super.getRGBColorTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("viewBox" == traitName) {
            return new FloatTraitAnim(this, traitName, "SVGRect");
        }
        if ("viewport-fill" == traitName) {
            return new FloatTraitAnim(this, traitName, "SVGRGBColor");
        }
        if ("viewport-fill-opacity" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        return super.createTraitAnimImpl(traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("width" == name) {
            this.checkPositive(name, value[0][0]);
            this.setWidth(value[0][0]);
        } else if ("height" == name) {
            this.checkPositive(name, value[0][0]);
            this.setHeight(value[0][0]);
        } else if ("viewBox" == name) {
            this.setViewBox(value);
        } else if ("viewport-fill" == name) {
            if (value == null || value.length == 0) {
                this.setViewportFill(null);
            } else {
                this.setViewportFill(this.toRGB(name, value));
            }
        } else if ("viewport-fill-opacity" == name) {
            this.setViewportFillOpacity(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    String validateTraitNS(String namespaceURI, String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if (namespaceURI != null && namespaceURI != "#!null/ns@!") {
            return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
        }
        if ("viewport-fill" == traitName || "viewport-fill-opacity" == traitName) {
            throw this.unsupportedTraitType(traitName, "float");
        }
        return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("viewBox" == traitName) {
            return this.ownerDocument.viewBoxParser.parseViewBox(value);
        }
        if ("width" == traitName || "height" == traitName) {
            return new float[][]{{this.parsePositiveLengthTrait(traitName, value, false)}};
        }
        if ("viewport-fill" == traitName) {
            RGB color = ViewportProperties.INITIAL_VIEWPORT_FILL;
            color = "inherit".equals(value) ? (RGB)this.getInheritedPropertyState(0x200000) : this.parseColorTrait("viewport-fill", value);
            if (color == null) {
                throw this.illegalTraitValue(traitName, value);
            }
            return new float[][]{{color.getRed(), color.getGreen(), color.getBlue()}};
        }
        if ("viewport-fill-opacity" == traitName) {
            float v = 1.0f;
            if ("inherit".equals(value)) {
                if (this.parent != null) {
                    v = this.getInheritedFloatPropertyState(0x400000);
                }
            } else {
                v = this.parseFloatTrait(traitName, value);
                if (v < 0.0f) {
                    v = 0.0f;
                } else if (v > 1.0f) {
                    v = 1.0f;
                }
            }
            return new float[][]{{v}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTraitImpl(String name, String value) throws DOMException {
        if ("version" == name) {
            this.checkWriteLoading(name);
            if ("1.1".equals(value) || "1.2".equals(value)) return;
            throw this.illegalTraitValue(name, value);
        }
        if ("baseProfile" == name) {
            this.checkWriteLoading(name);
            if ("tiny".equals(value)) return;
            throw this.illegalTraitValue(name, value);
        }
        if ("viewBox" == name) {
            this.setViewBox(this.toViewBox(name, value));
            return;
        } else if ("zoomAndPan" == name) {
            if ("magnify".equals(value)) {
                this.ownerDocument.setZoomAndPan(0);
                this.applyUserTransform();
                return;
            } else {
                if (!"disable".equals(value)) throw this.illegalTraitValue(name, value);
                this.ownerDocument.setZoomAndPan(1);
                this.applyUserTransform();
            }
            return;
        } else if ("width" == name) {
            this.checkWriteLoading(name);
            this.setWidth(this.parsePositiveLengthTrait(name, value, true));
            return;
        } else if ("height" == name) {
            this.checkWriteLoading(name);
            this.setHeight(this.parsePositiveLengthTrait(name, value, false));
            return;
        } else if ("preserveAspectRatio" == name) {
            this.checkWriteLoading(name);
            if ("xMidYMid meet".equals(value)) {
                this.setAlign(1);
                return;
            } else {
                if (!"none".equals(value)) throw this.illegalTraitValue(name, value);
                this.setAlign(0);
            }
            return;
        } else if ("viewport-fill" == name) {
            if ("inherit".equals(value)) {
                this.setInherited(0x200000, true);
                return;
            } else if ("none".equals(value)) {
                this.setViewportFill(null);
                return;
            } else {
                PaintServer viewportFill = this.parsePaintTrait("viewport-fill", this, value);
                if (viewportFill == null) return;
                this.setViewportFill(viewportFill);
            }
            return;
        } else if ("viewport-fill-opacity" == name) {
            if ("inherit".equals(value)) {
                this.setFloatInherited(0x400000, true);
                return;
            } else {
                this.setViewportFillOpacity(this.parseFloatTrait(name, value));
            }
            return;
        } else if ("syncBehaviorDefault" == name) {
            this.checkWriteLoading(name);
            if ("canSlip".equals(value) || "locked".equals(value) || "independent".equals(value)) {
                this.setSyncBehaviorDefault(value);
                return;
            } else {
                if (!"inherit".equals(value)) throw this.illegalTraitValue(name, value);
                this.setSyncBehaviorDefault("canSlip");
            }
            return;
        } else if ("syncToleranceDefault" == name) {
            this.checkWriteLoading(name);
            if ("inherit".equals(value)) {
                this.setSyncToleranceDefault(this.parseClockTrait(name, "2s"));
                return;
            } else {
                this.setSyncToleranceDefault(this.parseClockTrait(name, value));
            }
            return;
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setRectTraitImpl(String name, SVGRect rect) throws DOMException {
        if ("viewBox".equals(name)) {
            if (rect == null) {
                throw this.illegalTraitValue(name, null);
            }
            if (rect.getWidth() < 0.0f || rect.getHeight() < 0.0f) {
                throw this.illegalTraitValue(name, this.toStringTrait(new float[]{rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight()}));
            }
            this.setViewBox(new float[][]{{rect.getX(), rect.getY()}, {rect.getWidth()}, {rect.getHeight()}});
        } else {
            super.setRectTraitImpl(name, rect);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        try {
            if ("width" == name) {
                this.setWidth(value);
            } else if ("height" == name) {
                this.setHeight(value);
            } else if ("viewport-fill-opacity" == name) {
                this.setViewportFillOpacity(value);
            } else {
                super.setFloatTraitImpl(name, value);
            }
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, Float.toString(value));
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("width" == name || "viewport-fill-opacity" == name || "height" == name) {
            return Float.toString(value[0][0]);
        }
        if ("viewBox" == name) {
            float[] vb = new float[]{value[0][0], value[0][1], value[1][0], value[2][0]};
            return this.toStringTrait(vb);
        }
        if ("viewport-fill" == name) {
            if (value == null || value.length == 0) {
                return "none";
            }
            return this.toRGBString(name, value);
        }
        return super.toStringTrait(name, value);
    }

    void setRGBColorTraitImpl(String name, SVGRGBColor color) throws DOMException {
        try {
            if ("viewport-fill".equals(name)) {
                this.setViewportFill((RGB)color);
            } else {
                super.setRGBColorTraitImpl(name, color);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new DOMException(15, iae.getMessage());
        }
    }

    public void setCurrentScale(float value) throws DOMException {
        if (value == 0.0f) {
            throw new DOMException(15, Messages.formatMessage("error.invalid.parameter.value", new String[]{"SVGSVGElement", "setCurrentScale", "value", Float.toString(value)}));
        }
        this.currentScale = value;
        this.applyUserTransform();
    }

    public boolean animationsPaused() {
        throw new Error("NOT IMPLEMENTED");
    }

    public void pauseAnimations() {
        throw new Error("NOT IMPLEMENTED");
    }

    public void unpauseAnimations() {
        throw new Error("NOT IMPLEMENTED");
    }

    public float getCurrentScale() {
        return this.currentScale;
    }

    public SVGRect getViewport() {
        throw new Error("NOT IMPLEMENTED");
    }

    public void setCurrentRotate(float value) {
        this.currentRotate = value;
        this.applyUserTransform();
    }

    public float getCurrentRotate() {
        return this.currentRotate;
    }

    public SVGPoint getCurrentTranslate() {
        return this;
    }

    public float getCurrentTime() {
        return (float)this.ownerDocument.timeContainerRootSupport.lastSampleTime.value / 1000.0f + this.currentTimeDelta;
    }

    public void setCurrentTime(float seconds) {
        this.currentTimeDelta = seconds - (float)((long)(seconds * 1000.0f)) / 1000.0f;
        this.ownerDocument.timeContainerRootSupport.seekTo(new Time((long)(seconds * 1000.0f)));
        this.ownerDocument.applyAnimations();
    }

    public SVGMatrix createSVGMatrixComponents(float a, float b, float c, float d, float e, float f) {
        return new Transform(a, b, c, d, e, f);
    }

    public SVGRect createSVGRect() {
        return new Box(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public SVGPath createSVGPath() {
        return new Path();
    }

    public SVGRGBColor createSVGRGBColor(int red, int green, int blue) throws SVGException {
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            throw new SVGException(1, null);
        }
        return new RGB(red, green, blue);
    }

    public void setX(float value) {
        this.tx = value;
        this.applyUserTransform();
    }

    public void setY(float value) {
        this.ty = value;
        this.applyUserTransform();
    }

    public float getX() {
        return this.tx;
    }

    public float getY() {
        return this.ty;
    }

    void applyUserTransform() {
        if (this.ownerDocument.zoomAndPan == 0) {
            Transform txf = new Transform(this.currentScale, 0.0f, 0.0f, this.currentScale, this.tx, this.ty);
            txf.mRotate(this.currentRotate);
            this.ownerDocument.setTransform(txf);
        } else if (this.ownerDocument.getTransform() != null) {
            this.ownerDocument.setTransform(new Transform(null));
        }
    }

    public void paint(RenderGraphics rg) {
        if (this.canRenderState != 0) {
            return;
        }
        if (this.viewportFill != null) {
            rg.setFill(this.viewportFill);
            rg.setFillOpacity(this.viewportFillOpacity);
            rg.setTransform(null);
            rg.fillRect(0.0f, 0.0f, this.ownerDocument.getWidth(), this.ownerDocument.getHeight(), 0.0f, 0.0f);
        }
        SVG.paint(this.getFirstChildNode(), rg);
    }

    public void onPaintServerUpdate(String paintType, PaintServer paintServer) {
        if (paintType == "viewport-fill") {
            this.setViewportFill(paintServer);
        } else {
            super.onPaintServerUpdate(paintType, paintServer);
        }
    }
}

