/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.Anchor;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.Time;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class ModelEvent
implements Event {
    public static final char CHAR_UNDEFINED = '\uffff';
    protected String type;
    protected ModelNode target;
    protected EventTarget currentTarget;
    protected Anchor anchor;
    protected boolean stopPropagation;
    protected Time eventTime = Time.UNRESOLVED;
    protected int repeatCount = 0;
    protected char keyChar = (char)65535;

    public ModelEvent(String type, ModelNode target) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
        if (target == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.eventTime = target.ownerDocument.timeContainerRootSupport.getCurrentTime();
    }

    public ModelEvent(String type, ModelNode target, char keyChar) {
        this(type, target);
        this.keyChar = keyChar;
    }

    public String getType() {
        return this.type;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public EventTarget getTarget() {
        return this.target;
    }

    public EventTarget getCurrentTarget() {
        return this.currentTarget;
    }

    public void stopPropagation() {
        this.stopPropagation = true;
    }

    public boolean getStopPropagation() {
        return this.stopPropagation;
    }

    public void setAnchor(Anchor anchor) {
        if (this.anchor != null) {
            throw new IllegalStateException();
        }
        this.anchor = anchor;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }
}

