/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.GraphicsProperties;
import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.RasterImage;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.j2d.ViewportProperties;
import com.sun.perseus.model.AbstractRenderingNode;
import com.sun.perseus.model.AbstractRenderingNodeProxy;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.RasterImageConsumer;
import com.sun.perseus.model.StringTraitAnim;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.model.ViewportNode;
import com.sun.perseus.util.RunnableQueue;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGRGBColor;

public class ImageNode
extends AbstractRenderingNode
implements RasterImageConsumer,
ViewportNode,
PaintTarget {
    static final String[] REQUIRED_TRAITS = new String[]{"width", "height"};
    static final String[][] REQUIRED_TRAITS_NS = new String[][]{{"http://www.w3.org/1999/xlink", "href"}};
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    protected RasterImage image;
    protected boolean imageLoaded;
    protected String href;
    protected String absoluteURI;
    protected int align = 1;
    protected static final String BROKEN_URI = "broken uri";
    protected PaintServer viewportFill = INITIAL_VIEWPORT_FILL;
    protected float viewportFillOpacity = 1.0f;

    public ImageNode(DocumentNode ownerDocument) {
        super(ownerDocument);
        this.image = ownerDocument.getImageLoader().getLoadingImage();
        this.canRenderState |= 0x40;
        this.canRenderState |= 0x80;
    }

    public String getLocalName() {
        return "image";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new ImageNode(doc);
    }

    public void setX(float newX) {
        if (newX == this.x) {
            return;
        }
        this.modifyingNode();
        this.x = newX;
        this.modifiedNode();
    }

    public void setY(float newY) {
        if (newY == this.y) {
            return;
        }
        this.modifyingNode();
        this.y = newY;
        this.modifiedNode();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setWidth(float newWidth) {
        if (newWidth < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (newWidth == this.width) {
            return;
        }
        this.modifyingNode();
        this.width = newWidth;
        this.computeCanRenderWidthBit(this.width);
        this.modifiedNode();
    }

    public float getWidth() {
        return this.width;
    }

    public void setHeight(float newHeight) {
        if (newHeight < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (newHeight == this.height) {
            return;
        }
        this.modifyingNode();
        this.height = newHeight;
        this.computeCanRenderHeightBit(this.height);
        this.modifiedNode();
    }

    public float getHeight() {
        return this.height;
    }

    protected Object getPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 0x200000: {
                return this.viewportFill;
            }
        }
        return super.getPropertyState(propertyIndex);
    }

    protected float getFloatPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 0x400000: {
                return this.viewportFillOpacity;
            }
        }
        return super.getFloatPropertyState(propertyIndex);
    }

    protected void setPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 0x200000: {
                this.viewportFill = (PaintServer)propertyValue;
                break;
            }
            default: {
                super.setPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected void setFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 0x400000: {
                this.viewportFillOpacity = propertyValue;
                break;
            }
            default: {
                super.setFloatPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected boolean isPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 0x200000: {
                return this.viewportFill == propertyValue;
            }
        }
        return super.isPropertyState(propertyIndex, propertyValue);
    }

    protected boolean isFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 0x400000: {
                return this.viewportFillOpacity == propertyValue;
            }
        }
        return super.isFloatPropertyState(propertyIndex, propertyValue);
    }

    void recomputeInheritedProperties() {
        ModelNode p = this.ownerDocument;
        if (this.parent != null) {
            p = this.parent;
        }
        this.recomputePropertyState(0x200000, p.getPropertyState(0x200000));
        this.recomputeFloatPropertyState(0x400000, p.getFloatPropertyState(0x400000));
        super.recomputeInheritedProperties();
    }

    public void setViewportFill(PaintServer newViewportFill) {
        if (!this.isInherited(0x200000) && ImageNode.equal(newViewportFill, this.viewportFill)) {
            return;
        }
        this.modifyingNode();
        if (this.viewportFill != null) {
            this.viewportFill.dispose();
        }
        this.viewportFill = newViewportFill;
        this.setInheritedQuiet(0x200000, false);
        this.propagatePropertyState(0x200000, this.viewportFill);
        this.modifiedNode();
    }

    public PaintServer getViewportFill() {
        return this.viewportFill;
    }

    public float getViewportFillOpacity() {
        return this.viewportFillOpacity;
    }

    public void setViewportFillOpacity(float newViewportFillOpacity) {
        if (!this.isInherited(0x400000) && newViewportFillOpacity == this.getViewportFillOpacity()) {
            return;
        }
        this.modifyingNode();
        if (newViewportFillOpacity > 1.0f) {
            newViewportFillOpacity = 1.0f;
        } else if (newViewportFillOpacity < 0.0f) {
            newViewportFillOpacity = 0.0f;
        }
        this.setInheritedQuiet(0x400000, false);
        this.viewportFillOpacity = newViewportFillOpacity;
        this.propagateFloatPropertyState(0x400000, this.viewportFillOpacity);
        this.modifiedNode();
    }

    protected void setParentQuiet(ModelNode newParent) {
        super.setParentQuiet(newParent);
        if (this.href != null && !this.href.equals(this.absoluteURI)) {
            this.willNeedImage();
        }
    }

    public void setHref(String newHref) {
        if (newHref == null) {
            throw new IllegalArgumentException();
        }
        if (ImageNode.equal(newHref, this.href)) {
            return;
        }
        this.modifyingNode();
        this.href = newHref;
        this.image = this.ownerDocument.getImageLoader().getLoadingImage();
        this.ownerDocument.getImageLoader().removeRasterImageConsumer(this.absoluteURI, this);
        this.absoluteURI = null;
        this.imageLoaded = false;
        if (this.isInDocumentTree() && this.href != null) {
            this.willNeedImage();
        }
        this.modifiedNode();
    }

    void willNeedImage() {
        this.imageLoaded = false;
        this.image = this.ownerDocument.getImageLoader().getLoadingImage();
        this.absoluteURI = this.ownerDocument.getImageLoader().resolveURI(this.href, this.getURIBase());
        if (this.absoluteURI == null) {
            if (this.paintNeedsLoad) {
                throw new IllegalArgumentException();
            }
            this.absoluteURI = BROKEN_URI;
            this.imageLoaded = true;
            this.image = this.ownerDocument.getImageLoader().getBrokenImage();
            return;
        }
        this.ownerDocument.getImageLoader().addRasterImageConsumer(this.absoluteURI, this);
        this.ownerDocument.getImageLoader().needsURI(this.absoluteURI);
    }

    public String getHref() {
        return this.href;
    }

    public RasterImage getImage() {
        return this.image;
    }

    public void setImage(RasterImage image, String uri) {
        if (this.absoluteURI != null && this.absoluteURI.equals(uri) && this.image != image) {
            this.modifyingNode();
            this.image = image;
            this.modifiedNode();
        }
    }

    public RunnableQueue getUpdateQueue() {
        return this.ownerDocument.getUpdateQueue();
    }

    public RunnableQueue.RunnableHandler getRunnableHandler() {
        return this.ownerDocument.getRunnableHandler();
    }

    public void setAlign(int newAlign) {
        if (newAlign == this.align) {
            return;
        }
        this.modifyingNode();
        this.align = newAlign;
        this.modifiedNode();
    }

    public int getAlign() {
        return this.align;
    }

    void paintRendered(RenderGraphics rg, GraphicsProperties gp, PaintTarget pt, Transform tx) {
        if (!gp.getVisibility()) {
            return;
        }
        rg.setTransform(tx);
        rg.setOpacity(this.getOpacity());
        if (this.viewportFill != null) {
            rg.setFill(this.viewportFill);
            rg.setFillOpacity(this.viewportFillOpacity);
            rg.fillRect(this.x, this.y, this.width, this.height, 0.0f, 0.0f);
        }
        if (!this.imageLoaded) {
            this.loadImage();
        }
        int iw = this.image.getWidth();
        int ih = this.image.getHeight();
        if (this.align == 0) {
            rg.drawImage(this.image, this.x, this.y, this.width, this.height);
        } else {
            float ws = this.width / (float)iw;
            float hs = this.height / (float)ih;
            float is = ws;
            if (hs < ws) {
                is = hs;
            }
            float oh = (float)ih * is;
            float ow = (float)iw * is;
            float dx = (this.width - ow) / 2.0f;
            float dy = (this.height - oh) / 2.0f;
            rg.drawImage(this.image, this.x + dx, this.y + dy, ow, oh);
        }
    }

    public void loadImage() {
        if (this.absoluteURI != null) {
            if (this.paintNeedsLoad) {
                this.image = this.ownerDocument.getImageLoader().getImageAndWait(this.absoluteURI);
                if (this.image == this.ownerDocument.getImageLoader().getBrokenImage()) {
                    throw new IllegalStateException();
                }
            } else {
                this.ownerDocument.getImageLoader().getImageLater(this.absoluteURI, this);
            }
        }
        this.imageLoaded = true;
    }

    public boolean hasNodeRendering() {
        return true;
    }

    protected boolean isHitVP(float[] pt) {
        if (!this.getVisibility()) {
            return false;
        }
        this.getInverseTransformState().transformPoint(pt, this.ownerDocument.upt);
        pt = this.ownerDocument.upt;
        return pt[0] > this.x && pt[0] < this.x + this.width && pt[1] > this.y && pt[1] < this.y + this.height;
    }

    protected boolean isProxyHitVP(float[] pt, AbstractRenderingNodeProxy proxy) {
        proxy.getInverseTransformState().transformPoint(pt, this.ownerDocument.upt);
        pt = this.ownerDocument.upt;
        return pt[0] > this.x && pt[0] < this.x + this.width && pt[1] > this.y && pt[1] < this.y + this.height;
    }

    boolean supportsTrait(String traitName) {
        if ("x" == traitName || "y" == traitName || "width" == traitName || "height" == traitName || "viewport-fill" == traitName || "viewport-fill-opacity" == traitName || "preserveAspectRatio" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String[] getRequiredTraits() {
        return REQUIRED_TRAITS;
    }

    public String[][] getRequiredTraitsNS() {
        return REQUIRED_TRAITS_NS;
    }

    String getSpecifiedTraitImpl(String name) throws DOMException {
        if ("viewport-fill" == name && this.isInherited(0x200000) || "viewport-fill-opacity" == name && this.isInherited(0x400000)) {
            return "inherit";
        }
        return super.getSpecifiedTraitImpl(name);
    }

    boolean supportsTraitNS(String namespaceURI, String traitName) {
        if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == traitName) {
            return true;
        }
        return super.supportsTraitNS(namespaceURI, traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("x" == name) {
            return Float.toString(this.getX());
        }
        if ("y" == name) {
            return Float.toString(this.getY());
        }
        if ("width" == name) {
            return Float.toString(this.getWidth());
        }
        if ("height" == name) {
            return Float.toString(this.getHeight());
        }
        if ("preserveAspectRatio" == name) {
            return ImageNode.alignToStringTrait(this.align);
        }
        if ("viewport-fill" == name) {
            return this.toString(this.getViewportFill());
        }
        if ("viewport-fill-opacity" == name) {
            return Float.toString(this.getViewportFillOpacity());
        }
        return super.getTraitImpl(name);
    }

    String getTraitNSImpl(String namespaceURI, String name) throws DOMException {
        if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == name) {
            if (this.href == null) {
                return "";
            }
            return this.href;
        }
        return super.getTraitNSImpl(namespaceURI, name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("x" == name) {
            return this.getX();
        }
        if ("y" == name) {
            return this.getY();
        }
        if ("width" == name) {
            return this.getWidth();
        }
        if ("height" == name) {
            return this.getHeight();
        }
        if ("viewport-fill-opacity" == name) {
            return this.getViewportFillOpacity();
        }
        return super.getFloatTraitImpl(name);
    }

    SVGRGBColor getRGBColorTraitImpl(String name) throws DOMException {
        if ("viewport-fill".equals(name)) {
            return this.toSVGRGBColor("viewport-fill", this.getViewportFill());
        }
        return super.getRGBColorTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("x" == traitName || "y" == traitName || "width" == traitName || "viewport-fill-opacity" == traitName || "height" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        if ("preserveAspectRatio" == traitName) {
            return new StringTraitAnim(this, "#!null/ns@!", traitName);
        }
        if ("viewport-fill" == traitName) {
            return new FloatTraitAnim(this, traitName, "SVGRGBColor");
        }
        return super.createTraitAnimImpl(traitName);
    }

    TraitAnim createTraitAnimNSImpl(String traitNamespace, String traitName) {
        if (traitNamespace == "http://www.w3.org/1999/xlink" && traitName == "href") {
            return new StringTraitAnim(this, traitNamespace, traitName);
        }
        return super.createTraitAnimNSImpl(traitNamespace, traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("x" == name) {
            this.setX(value[0][0]);
        } else if ("y" == name) {
            this.setY(value[0][0]);
        } else if ("width" == name) {
            this.checkPositive(name, value[0][0]);
            this.setWidth(value[0][0]);
        } else if ("height" == name) {
            this.checkPositive(name, value[0][0]);
            this.setHeight(value[0][0]);
        } else if ("viewport-fill" == name) {
            if (value == null || value.length == 0) {
                this.setViewportFill(null);
            } else {
                this.setViewportFill(this.toRGB(name, value));
            }
        } else if ("viewport-fill-opacity" == name) {
            this.setViewportFillOpacity(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("x" == traitName || "y" == traitName) {
            return new float[][]{{this.parseFloatTrait(traitName, value)}};
        }
        if ("width" == traitName || "height" == traitName) {
            return new float[][]{{this.parsePositiveFloatTrait(traitName, value)}};
        }
        if ("viewport-fill" == traitName) {
            RGB color = ViewportProperties.INITIAL_VIEWPORT_FILL;
            color = "inherit".equals(value) ? (RGB)this.getInheritedPropertyState(0x200000) : this.parseColorTrait("viewport-fill", value);
            if (color == null) {
                throw this.illegalTraitValue(traitName, value);
            }
            return new float[][]{{color.getRed(), color.getGreen(), color.getBlue()}};
        }
        if ("viewport-fill-opacity" == traitName) {
            float v = 1.0f;
            if ("inherit".equals(value)) {
                if (this.parent != null) {
                    v = this.getInheritedFloatPropertyState(0x400000);
                }
            } else {
                v = this.parseFloatTrait(traitName, value);
                if (v < 0.0f) {
                    v = 0.0f;
                } else if (v > 1.0f) {
                    v = 1.0f;
                }
            }
            return new float[][]{{v}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    String validateTraitNS(String namespaceURI, String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if (namespaceURI != null) {
            return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
        }
        if ("viewport-fill" == traitName || "viewport-fill-opacity" == traitName) {
            throw this.unsupportedTraitType(traitName, "float");
        }
        if ("preserveAspectRatio".equals(traitName)) {
            if (!"xMidYMid meet".equals(value) && !"none".equals(value)) {
                throw this.illegalTraitValue(traitName, value);
            }
            return value;
        }
        return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTraitImpl(String name, String value) throws DOMException {
        if ("x" == name) {
            this.setX(this.parseFloatTrait(name, value));
            return;
        } else if ("y" == name) {
            this.setY(this.parseFloatTrait(name, value));
            return;
        } else if ("width" == name) {
            this.setWidth(this.parsePositiveFloatTrait(name, value));
            return;
        } else if ("height" == name) {
            this.setHeight(this.parsePositiveFloatTrait(name, value));
            return;
        } else if ("preserveAspectRatio".equals(name)) {
            if ("xMidYMid meet".equals(value)) {
                this.setAlign(1);
                return;
            } else {
                if (!"none".equals(value)) throw this.illegalTraitValue(name, value);
                this.setAlign(0);
            }
            return;
        } else if ("viewport-fill" == name) {
            if ("inherit".equals(value)) {
                this.setInherited(0x200000, true);
                return;
            } else if ("none".equals(value)) {
                this.setViewportFill(null);
                return;
            } else {
                PaintServer vFill = this.parsePaintTrait("viewport-fill", this, value);
                if (vFill == null) return;
                this.setViewportFill(vFill);
            }
            return;
        } else if ("viewport-fill-opacity" == name) {
            if ("inherit".equals(value)) {
                this.setFloatInherited(0x400000, true);
                return;
            } else {
                this.setViewportFillOpacity(this.parseFloatTrait(name, value));
            }
            return;
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setTraitNSImpl(String namespaceURI, String name, String value) throws DOMException {
        try {
            if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == name) {
                this.setHref(value);
            } else {
                super.setTraitNSImpl(namespaceURI, name, value);
            }
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, value);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        try {
            if ("x" == name) {
                this.setX(value);
            } else if ("y" == name) {
                this.setY(value);
            } else if ("width" == name) {
                this.setWidth(value);
            } else if ("height" == name) {
                this.setHeight(value);
            } else if ("viewport-fill-opacity" == name) {
                this.setViewportFillOpacity(value);
            } else {
                super.setFloatTraitImpl(name, value);
            }
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, Float.toString(value));
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("x" == name || "y" == name || "width" == name || "viewport-fill-opacity" == name || "height" == name) {
            return Float.toString(value[0][0]);
        }
        if ("viewport-fill" == name) {
            if (value == null || value.length == 0) {
                return "none";
            }
            return this.toRGBString(name, value);
        }
        return super.toStringTrait(name, value);
    }

    void setRGBColorTraitImpl(String name, SVGRGBColor color) throws DOMException {
        try {
            if ("viewport-fill".equals(name)) {
                this.setViewportFill((RGB)color);
            } else {
                super.setRGBColorTraitImpl(name, color);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new DOMException(15, iae.getMessage());
        }
    }

    public void onPaintServerUpdate(String paintType, PaintServer paintServer) {
        if (paintType != "viewport-fill") {
            throw new Error();
        }
        this.setViewportFill(paintServer);
    }

    Box addNodeBBox(Box bbox, Transform t) {
        return ImageNode.addTransformedBBox(bbox, this.x, this.y, this.width, this.height, t);
    }
}

