/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.netbeans.modules.dlight.dtrace.collector.support.DTraceScriptUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

public final class BootstrapScript {
    private static final String scriptURI = "/org/netbeans/modules/dlight/dtrace/resources/bootstrap.d";
    private final String pattern;
    private String path = null;
    private final String originalScript;

    public BootstrapScript(String originalScript, String pattern) {
        this.originalScript = originalScript;
        if (pattern != null && pattern.trim().length() == 0) {
            pattern = null;
        }
        this.pattern = pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getScriptPath(ExecutionEnvironment env) throws IOException {
        if (this.path != null) {
            return this.path;
        }
        if (!HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env) || !ConnectionManager.getInstance().isConnectedTo(env)) {
            throw new IOException("Env " + env.getDisplayName() + " is not ready!");
        }
        File tmp = File.createTempFile("dlight", ".d", HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getTempDirFile());
        tmp.deleteOnExit();
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            String line;
            InputStream is = BootstrapScript.class.getResourceAsStream(scriptURI);
            br = new BufferedReader(new InputStreamReader(is));
            bw = new BufferedWriter(new FileWriter(tmp));
            StringBuilder predicateBuffer = new StringBuilder("/progenyof(\\$1)");
            if (this.pattern == null) {
                predicateBuffer.append('/');
            } else {
                predicateBuffer.append(" && BSS_active == 1 && strstr(execname, \"").append(this.pattern).append("\") != NULL/");
            }
            String predicate = predicateBuffer.toString();
            while ((line = br.readLine()) != null) {
                line = line.replaceAll("__DLIGHT_PREDICATE__", predicate);
                line = line.replaceAll("__DLIGHT_DSCRIPT__", this.originalScript);
                bw.write(line);
                bw.newLine();
            }
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (br != null) {
                br.close();
            }
        }
        return DTraceScriptUtils.uploadScript(env, tmp);
    }
}

