/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.m2g.SVGImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.mobility.svgcore.util.Util;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComponentCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormSupport;
import org.netbeans.modules.vmd.midpnb.screen.display.SVGPlayerDisplayPresenter;
import org.openide.filesystems.FileObject;

public class SVGComponentDisplayPresenter
extends ScreenDisplayPresenter {
    private Rectangle myBoundsRect = null;
    private JPanel myView = null;

    public boolean isTopLevelDisplay() {
        return false;
    }

    public Collection<DesignComponent> getChildren() {
        return Collections.emptyList();
    }

    public JComponent getView() {
        if (this.myView == null) {
            this.myView = new JPanel();
            this.myView.setPreferredSize(new Dimension(0, 0));
        }
        return this.myView;
    }

    public void reload(ScreenDeviceInfo screenDeviceInfo) {
        this.myBoundsRect = null;
        this.myView = null;
    }

    public Point getLocation() {
        Rectangle rectangle = this.getRectangle();
        return rectangle == null ? super.getLocation() : rectangle.getLocation();
    }

    public Shape getSelectionShape() {
        Rectangle rectangle = this.getRectangle();
        if (rectangle != null) {
            return new Rectangle((int)rectangle.getWidth(), (int)rectangle.getHeight());
        }
        return null;
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        return Collections.emptyList();
    }

    protected DesignComponent getSvgComponent() {
        DesignComponent designComponent = null;
        DescriptorRegistry descriptorRegistry = this.getComponent().getDocument().getDescriptorRegistry();
        if (descriptorRegistry.isInHierarchy(SVGComponentCD.TYPEID, this.getComponent().getType())) {
            return this.getComponent();
        }
        if (this.getComponent().getComponentDescriptor().getPropertyDescriptor("svgButton") == null) {
            return null;
        }
        PropertyValue propertyValue = this.getComponent().readProperty("svgButton");
        if (propertyValue != null && propertyValue.getComponent() != null) {
            designComponent = propertyValue.getComponent();
        }
        return designComponent;
    }

    protected String getSvgComponentId() {
        DesignComponent designComponent = this.getSvgComponent();
        if (designComponent == null) {
            return null;
        }
        return (String)designComponent.readProperty("id").getPrimitiveValue();
    }

    protected SVGImage getSvgImage() {
        SVGImage sVGImage = null;
        DesignComponent designComponent = this.getComponent().getParentComponent();
        if (designComponent == null) {
            return null;
        }
        SVGPlayerDisplayPresenter sVGPlayerDisplayPresenter = (SVGPlayerDisplayPresenter)designComponent.getPresenter(SVGPlayerDisplayPresenter.class);
        if (sVGPlayerDisplayPresenter != null) {
            sVGImage = sVGPlayerDisplayPresenter.getSVGImage();
        }
        if (sVGImage == null) {
            DesignComponent designComponent2 = designComponent.readProperty("svgImage").getComponent();
            if (designComponent2 == null) {
                return null;
            }
            FileObject fileObject = SVGFormSupport.getSVGFile(designComponent2);
            if (fileObject == null) {
                return null;
            }
            try {
                sVGImage = Util.createSVGImage((FileObject)fileObject, (boolean)true);
            }
            catch (IOException iOException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, null, iOException);
            }
        }
        return sVGImage;
    }

    private Rectangle doCalculateRectangle() {
        String string;
        float f = 1.0f;
        float f2 = 1.0f;
        int n = 0;
        int n2 = 0;
        DesignComponent designComponent = this.getComponent().getParentComponent();
        if (designComponent == null) {
            return null;
        }
        SVGPlayerDisplayPresenter sVGPlayerDisplayPresenter = (SVGPlayerDisplayPresenter)designComponent.getPresenter(SVGPlayerDisplayPresenter.class);
        if (sVGPlayerDisplayPresenter != null) {
            f = sVGPlayerDisplayPresenter.getScaleX();
            f2 = sVGPlayerDisplayPresenter.getScaleY();
            n = sVGPlayerDisplayPresenter.getCorrectionX();
            n2 = sVGPlayerDisplayPresenter.getCorrectionY();
        }
        if ((string = this.getSvgComponentId()) == null) {
            return null;
        }
        SVGImage sVGImage = this.getSvgImage();
        if (sVGImage == null) {
            return null;
        }
        Rectangle rectangle = Util.getElementRectangle((SVGImage)sVGImage, (String)string);
        if (rectangle != null) {
            return new Rectangle((int)Math.round(rectangle.getX() * (double)f) + n, (int)Math.round(rectangle.getY() * (double)f2) + n2, (int)Math.round(rectangle.getWidth() * (double)f) + 1, (int)Math.round(rectangle.getHeight() * (double)f2) + 1);
        }
        return null;
    }

    private Rectangle getRectangle() {
        if (this.myBoundsRect == null) {
            this.myBoundsRect = this.doCalculateRectangle();
        }
        return this.myBoundsRect;
    }
}

