/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ruby.railsprojects.SourceRoots;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.SourcesHelper;
import org.openide.util.Mutex;

public class RailsSources
implements Sources,
PropertyChangeListener,
ChangeListener {
    private static final String BUILD_DIR_PROP = "${build.dir}";
    private static final String DIST_DIR_PROP = "${dist.dir}";
    private final Project project;
    private final RakeProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private Sources delegate;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public RailsSources(Project project, RakeProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testRoots) {
        this.project = project;
        this.helper = helper;
        this.evaluator = evaluator;
        this.sourceRoots = sourceRoots;
        this.testRoots = testRoots;
        this.sourceRoots.addPropertyChangeListener(this);
        this.testRoots.addPropertyChangeListener(this);
        this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.initSources();
    }

    public SourceGroup[] getSourceGroups(final String type) {
        return (SourceGroup[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceGroup[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SourceGroup[] run() {
                Sources _delegate;
                RailsSources railsSources = RailsSources.this;
                synchronized (railsSources) {
                    if (RailsSources.this.delegate == null) {
                        RailsSources.this.delegate = RailsSources.this.initSources();
                        RailsSources.this.delegate.addChangeListener((ChangeListener)RailsSources.this);
                    }
                    _delegate = RailsSources.this.delegate;
                }
                return _delegate.getSourceGroups(type);
            }
        });
    }

    void notifyDeleting() {
        this.delegate.removeChangeListener((ChangeListener)this);
        this.sourceRoots.removePropertyChangeListener(this);
        this.testRoots.removePropertyChangeListener(this);
        this.evaluator.removePropertyChangeListener((PropertyChangeListener)this);
    }

    private Sources initSources() {
        String prop;
        String displayName;
        int i;
        SourcesHelper sourcesHelper = new SourcesHelper(this.project, this.helper, this.evaluator);
        String[] propNames = this.sourceRoots.getRootProperties();
        String[] rootNames = this.sourceRoots.getRootNames();
        for (i = 0; i < propNames.length; ++i) {
            displayName = rootNames[i];
            displayName = this.sourceRoots.getRootDisplayName(displayName, propNames[i]);
            prop = propNames[i];
            sourcesHelper.addPrincipalSourceRoot(prop, displayName, null, null);
            sourcesHelper.addTypedSourceRoot(prop, "ruby", displayName, null, null);
        }
        propNames = this.testRoots.getRootProperties();
        rootNames = this.testRoots.getRootNames();
        for (i = 0; i < propNames.length; ++i) {
            displayName = rootNames[i];
            displayName = this.testRoots.getRootDisplayName(displayName, propNames[i]);
            prop = "${" + propNames[i] + "}";
            sourcesHelper.addPrincipalSourceRoot(prop, displayName, null, null);
            sourcesHelper.addTypedSourceRoot(prop, "ruby", displayName, null, null);
        }
        sourcesHelper.addNonSourceRoot(BUILD_DIR_PROP);
        sourcesHelper.addNonSourceRoot(DIST_DIR_PROP);
        sourcesHelper.registerExternalRoots(0);
        return sourcesHelper.createSources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ChangeListener[] _listeners;
        Object object = this;
        synchronized (object) {
            if (this.delegate != null) {
                this.delegate.removeChangeListener((ChangeListener)this);
                this.delegate = null;
            }
        }
        object = this.listeners;
        synchronized (object) {
            if (this.listeners.isEmpty()) {
                return;
            }
            _listeners = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener l : _listeners) {
            l.stateChanged(ev);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("rootProperties".equals(propName) || "build.dir".equals(propName) || "dist.dir".equals(propName)) {
            this.fireChange();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireChange();
    }
}

