/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.ruby.platform.execution.DirectoryFileLocator;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.platform.execution.OutputProcessor;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyLineConvertorFactory;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.railsprojects.FindFileListener;
import org.netbeans.modules.ruby.railsprojects.Generator;
import org.netbeans.modules.ruby.railsprojects.GeneratorPanel;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.RailsProjectGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.OutputListener;

public final class GenerateAction
extends NodeAction {
    public static final String EDITOR_ACTION_NAME = "rails-generator";
    private static final Logger LOGGER = Logger.getLogger(GenerateAction.class.getName());
    private boolean forcing;
    private boolean preview;

    protected void performAction(Node[] activatedNodes) {
        Lookup lookup = activatedNodes[0].getLookup();
        RailsProject project = (RailsProject)((Object)lookup.lookup(RailsProject.class));
        if (project == null) {
            DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
            if (dataObject == null) {
                return;
            }
            Project p = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
            if (p instanceof RailsProject) {
                project = (RailsProject)p;
            }
        }
        if (project == null) {
            return;
        }
        FileObject railsInstall = project.getProjectDirectory().getFileObject("vendor/rails/railties");
        RubyPlatform platform = RubyPlatform.platformFor((Project)project);
        if (railsInstall == null && !platform.hasValidRails(true)) {
            LOGGER.warning("No valid Rails installation found, platform is:" + RubyPlatform.platformFor((Project)project));
            return;
        }
        Generator generator = (Generator)activatedNodes[0].getLookup().lookup(Generator.class);
        if (generator == null) {
            generator = Generator.CONTROLLER;
        }
        this.generate(project, generator, null, null, false, false);
    }

    public void generate(Project project, String generatorName, String name, String params) {
        assert (generatorName.equals("controller")) : "Only the controller generator is supported";
        Generator generator = Generator.CONTROLLER;
        if (project != null) {
            this.generate((RailsProject)project, generator, name, params, true, true);
        } else assert (false);
    }

    public void generate(final RailsProject project, Generator generator, String initialName, String initialParams, boolean initialEnabled, boolean noOverwrite) {
        String type;
        final JButton okButton = new JButton(NbBundle.getMessage(GenerateAction.class, (String)"Ok"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GenerateAction.class, (String)"AD_Ok"));
        final GeneratorPanel panel = new GeneratorPanel((Project)project, generator);
        if (noOverwrite) {
            panel.setForcing(false);
        } else {
            panel.setForcing(this.forcing);
        }
        panel.setPretend(this.preview);
        if (initialName != null) {
            panel.setInitialState(initialName, initialParams);
        }
        Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
        panel.setChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                okButton.setEnabled(panel.isDataValid());
            }
        });
        okButton.setEnabled(initialEnabled);
        String projectName = ProjectUtils.getInformation((Project)project).getDisplayName();
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(GenerateAction.class, (String)"GeneratorTitle", (Object)projectName), true, options, options[0], 0, null, null);
        desc.setMessageType(-1);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GenerateAction.class, (String)"AD_GeneratorDialog"));
        dlg.setVisible(true);
        boolean cancelled = desc.getValue() != options[0];
        dlg.dispose();
        if (!noOverwrite) {
            this.forcing = panel.isForce();
        }
        this.preview = panel.isPretend();
        if (!cancelled && (type = panel.getType()).length() > 0) {
            String[] firstParameterList;
            final FileObject dir = project.getProjectDirectory();
            final File pwd = FileUtil.toFile((FileObject)project.getProjectDirectory());
            Generator.Script generatorScript = panel.getScript();
            final String scriptToRun = "script" + File.separator + generatorScript.script;
            ArrayList<String> argvList = new ArrayList<String>();
            argvList.addAll(generatorScript.args);
            argvList.add(type);
            String[] names = Utilities.parseParameters((String)panel.getGeneratedName());
            if (names != null) {
                for (String name : names) {
                    argvList.add(name);
                }
            }
            if ((firstParameterList = panel.getFirstParameterList()) != null && firstParameterList.length > 0 && firstParameterList[0].length() > 0) {
                for (String parameter : firstParameterList) {
                    argvList.add(parameter);
                }
                String[] remainingParameters = panel.getSecondParameterList();
                if (remainingParameters != null && remainingParameters.length > 0 && remainingParameters[0].length() > 0) {
                    for (String parameter : remainingParameters) {
                        argvList.add(parameter);
                    }
                }
            }
            if (panel.isForce()) {
                argvList.add("--force");
            } else {
                argvList.add("--skip");
            }
            if (panel.isPretend()) {
                argvList.add("--pretend");
            }
            final String[] argv = argvList.toArray(new String[argvList.size()]);
            try {
                final String charsetName = project.evaluator().getProperty("source.encoding");
                project.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        DirectoryFileLocator locator = new DirectoryFileLocator(dir);
                        StatefulConvertor convertor = new StatefulConvertor((LineConvertors.FileLocator)locator, RailsProjectGenerator.RAILS_GENERATOR_PATTERN, RubyLineConvertorFactory.EXT_RE, 2, -1);
                        String displayName = NbBundle.getMessage(GenerateAction.class, (String)"RailsGenerator");
                        HashMap<String, String> env = new HashMap<String, String>();
                        String railsEnv = project.evaluator().getProperty("rails.env");
                        if (railsEnv != null) {
                            env.put("RAILS_ENV", railsEnv);
                        }
                        RubyExecutionDescriptor descriptor = new RubyExecutionDescriptor(RubyPlatform.platformFor((Project)project), displayName, pwd, scriptToRun).additionalArgs(argv).fileLocator((LineConvertors.FileLocator)locator).addStandardRecognizers().addOutConvertor((LineConvertor)convertor).addErrConvertor((LineConvertor)convertor);
                        descriptor.addAdditionalEnv(env);
                        descriptor.setOutProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                                return InputProcessors.ansiStripping((InputProcessor)defaultProcessor);
                            }
                        });
                        RubyProcessCreator rpc = new RubyProcessCreator(descriptor, charsetName);
                        Future execution = ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)descriptor.toExecutionDescriptor(), (String)displayName).run();
                        try {
                            execution.get();
                        }
                        catch (CancellationException ex) {
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (ExecutionException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        project.getProjectDirectory().getFileSystem().refresh(true);
                        List<ExecutionUtils.FileLocation> locations = convertor.getLocations();
                        ArrayList<FileObject> rubyFiles = new ArrayList<FileObject>();
                        ArrayList<FileObject> rhtmlFiles = new ArrayList<FileObject>();
                        for (int i = locations.size() - 1; i >= 0; --i) {
                            FileObject fo;
                            ExecutionUtils.FileLocation loc = locations.get(i);
                            String file = loc.file;
                            if (file == null || (fo = locator.find(file)) == null) continue;
                            String mimeType = fo.getMIMEType();
                            if (mimeType.equals("text/x-ruby")) {
                                rubyFiles.add(fo);
                                continue;
                            }
                            if (!mimeType.equals("application/x-httpd-eruby")) continue;
                            rhtmlFiles.add(fo);
                        }
                        if (rhtmlFiles.size() <= 4) {
                            for (FileObject fo : rhtmlFiles) {
                                OutputProcessor.open((FileObject)fo, (int)1);
                            }
                        }
                        if (rubyFiles.size() <= 4) {
                            for (FileObject fo : rubyFiles) {
                                OutputProcessor.open((FileObject)fo, (int)1);
                            }
                        }
                    }
                });
                project.getProjectDirectory().getFileSystem().refresh(true);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(GenerateAction.class, (String)EDITOR_ACTION_NAME);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        Lookup lookup = activatedNodes[0].getLookup();
        RailsProject project = (RailsProject)((Object)lookup.lookup(RailsProject.class));
        if (project != null) {
            return true;
        }
        DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
        return dataObject != null;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return true;
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        Node[] nodes;
        Node n;
        DataObject dobj = (DataObject)target.getDocument().getProperty("stream");
        if (dobj != null && (n = dobj.getNodeDelegate()) != null && this.enable(nodes = new Node[]{n})) {
            this.performAction(nodes);
        }
    }

    public boolean appliesTo(String mimeType) {
        return "application/x-httpd-eruby".equals(mimeType) || "text/x-ruby".equals(mimeType);
    }

    private static class StatefulConvertor
    implements LineConvertor {
        private final LineConvertors.FileLocator locator;
        private final Pattern linePattern;
        private final Pattern filePattern;
        private final int fileGroup;
        private final int lineGroup;
        private final List<ExecutionUtils.FileLocation> locations = new ArrayList<ExecutionUtils.FileLocation>();

        public StatefulConvertor(LineConvertors.FileLocator locator, Pattern linePattern, Pattern filePattern, int fileGroup, int lineGroup) {
            this.locator = locator;
            this.linePattern = linePattern;
            this.fileGroup = fileGroup;
            this.lineGroup = lineGroup;
            this.filePattern = filePattern;
        }

        public synchronized List<ConvertedLine> convert(String line) {
            if (line.length() > 400) {
                return null;
            }
            Matcher match = this.linePattern.matcher(line);
            if (match.matches()) {
                String file = null;
                int lineno = -1;
                if (this.fileGroup >= 0) {
                    file = match.group(this.fileGroup);
                    if (file.startsWith("\"")) {
                        file = file.substring(1);
                    }
                    if (file.startsWith("./")) {
                        file = file.substring(2);
                    }
                    if (this.filePattern != null && !this.filePattern.matcher(file).matches()) {
                        return null;
                    }
                }
                if (this.lineGroup >= 0) {
                    String linenoStr = match.group(this.lineGroup);
                    try {
                        lineno = Integer.parseInt(linenoStr);
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.INFO, null, nfe);
                        lineno = 0;
                    }
                }
                if (!line.trim().startsWith("skip")) {
                    this.locations.add(new ExecutionUtils.FileLocation(file, lineno));
                }
                return Collections.singletonList(ConvertedLine.forText((String)line, (OutputListener)new FindFileListener(file, lineno, this.locator)));
            }
            return null;
        }

        synchronized List<ExecutionUtils.FileLocation> getLocations() {
            return this.locations;
        }
    }

    public static class EditorAction
    extends BaseAction {
        public EditorAction() {
            super(GenerateAction.EDITOR_ACTION_NAME, 0);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            ((GenerateAction)SystemAction.get(GenerateAction.class)).actionPerformed(evt, target);
        }

        public Class getShortDescriptionBundleClass() {
            return GenerateAction.class;
        }
    }
}

