/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.lang.model.element.AnnotationMirror;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathExpressionException;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.TypeUtil;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.wizard.ClientStubsSetupPanelVisual;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClientStubModel {
    public static final int EXPAND_LEVEL_MAX = 2;

    public ResourceModel createModel(Project project) {
        return new SourceModeler(project);
    }

    public ResourceModel createModel(FileObject fileObject) {
        return new WadlModeler(fileObject);
    }

    public static String normalizeName(String string) {
        return ClientStubModel.toValidJavaName(string);
    }

    private static String toValidJavaName(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        if (Character.isJavaIdentifierStart(string.charAt(0))) {
            stringBuilder.append(string.charAt(0));
        } else {
            stringBuilder.append("_");
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) {
                stringBuilder.append(string.charAt(i));
                continue;
            }
            stringBuilder.append("_");
        }
        return stringBuilder.toString();
    }

    public static enum State {
        VALID("VALID"),
        INVALID("INVALID"),
        APP_MISSING("APP_MISSING"),
        RESOURCES_MISSING("RESOURCES_MISSING"),
        BASE_URL_NULL("BASE_URL_NULL"),
        EMPTY_RESOURCES("EMPTY_RESOURCES");

        String value;

        private State(String string2) {
            this.value = string2;
        }

        public String value() {
            return this.value;
        }
    }

    public class Representation
    implements Comparator {
        private String mime;

        public Representation(String string) {
            this.mime = string;
        }

        public String getMime() {
            return this.mime;
        }

        @Override
        public boolean equals(Object object) {
            return this.getMime().equals(((Representation)object).getMime());
        }

        public int hashCode() {
            return this.getMime().hashCode();
        }

        public int compare(Object object, Object object2) {
            return ((Representation)object).getMime().compareTo(((Representation)object2).getMime());
        }
    }

    public class Response {
        private List<Representation> repList = new ArrayList<Representation>();

        public List<Representation> getRepresentation() {
            return this.repList;
        }

        protected void addRepresentation(Representation representation) {
            this.repList.add(representation);
        }

        protected void setRepresentation(List<Representation> list) {
            this.repList = list;
        }

        protected boolean containsRepresentation(Representation representation) {
            return this.repList.contains(representation);
        }
    }

    public class Request {
        private List<Representation> repList = new ArrayList<Representation>();

        public List<Representation> getRepresentation() {
            return this.repList;
        }

        protected void addRepresentation(Representation representation) {
            this.repList.add(representation);
        }

        protected void setRepresentation(List<Representation> list) {
            this.repList = list;
        }

        protected boolean containsRepresentation(Representation representation) {
            return this.repList.contains(representation);
        }
    }

    public class NavigationMethod
    extends Method {
        private String nUri;
        private String linkName;

        public NavigationMethod(String string) {
            super(string);
        }

        public String getNavigationUri() {
            return this.nUri;
        }

        protected void setNavigationUri(String string) {
            this.nUri = string;
        }

        public String getLinkName() {
            return this.linkName;
        }

        protected void setLinkName(String string) {
            this.linkName = string;
        }
    }

    public class Method {
        private String name;
        private MethodType type;
        private Request request;
        private Response response;
        private MethodTree tree;

        public Method(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public MethodType getType() {
            return this.type;
        }

        protected void setType(MethodType methodType) {
            this.type = methodType;
        }

        public Request getRequest() {
            return this.request;
        }

        protected void setRequest(Request request) {
            this.request = request;
        }

        public Response getResponse() {
            return this.response;
        }

        public void setResponse(Response response) {
            this.response = response;
        }

        protected MethodTree getTree() {
            return this.tree;
        }

        protected void setTree(MethodTree methodTree) {
            this.tree = methodTree;
        }
    }

    public static enum MethodType {
        GET(Constants.HttpMethodType.GET.value()),
        PUT(Constants.HttpMethodType.PUT.value()),
        POST(Constants.HttpMethodType.POST.value()),
        DELETE(Constants.HttpMethodType.DELETE.value()),
        GETCHILD("getChild");

        private String prefix;

        private MethodType(String string2) {
            this.prefix = string2;
        }

        public String value() {
            return this.name();
        }

        public String prefix() {
            return this.prefix;
        }
    }

    public class RepresentationNode
    implements Cloneable {
        private String name;
        private String id;
        private String type;
        private MethodTree link;
        private JavaSource src;
        private List<RepresentationNode> attrList = new ArrayList<RepresentationNode>();
        private List<RepresentationNode> childList = new ArrayList<RepresentationNode>();
        private boolean isRoot;
        private boolean isContainer;

        public RepresentationNode(String string) {
            this.name = string;
            this.id = string;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        private void setId(String string) {
            this.id = string;
        }

        public MethodTree getLink() {
            return this.link;
        }

        protected void setLink(MethodTree methodTree) {
            this.link = methodTree;
        }

        public List<RepresentationNode> getAttributes() {
            return this.attrList;
        }

        public void addAttribute(RepresentationNode representationNode) {
            this.attrList.add(representationNode);
        }

        public List<RepresentationNode> getChildren() {
            return this.childList;
        }

        public void addChild(RepresentationNode representationNode) {
            this.childList.add(representationNode);
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        protected void setIsRoot(boolean bl) {
            this.isRoot = bl;
        }

        public boolean isReference() {
            return this.getAttributes().size() > 0 || this.getChildren().size() > 0;
        }

        public boolean isEntity() {
            return this.src != null;
        }

        protected JavaSource getSource() {
            return this.src;
        }

        protected void setSource(JavaSource javaSource) {
            this.src = javaSource;
        }

        public boolean isContainer() {
            return this.isContainer;
        }

        protected void setIsContainer(boolean bl) {
            this.isContainer = bl;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public RepresentationNode clone() {
            try {
                RepresentationNode representationNode = (RepresentationNode)super.clone();
                return representationNode;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }

        public String toString() {
            return this.getName();
        }
    }

    public class RepresentationDocument {
        private RepresentationNode root;

        public RepresentationNode getRoot() {
            return this.root;
        }

        protected void setRoot(RepresentationNode representationNode) {
            this.root = representationNode;
        }
    }

    public class Resource {
        private String name;
        private String path;
        private String desc;
        private JavaSource src;
        private RepresentationDocument rep;
        private boolean isContainer;
        private boolean isContainerItem;
        private boolean rootResource;
        private List<Method> methodList = Collections.emptyList();

        public Resource(String string, String string2, String string3) {
            this.name = string;
            this.path = string2;
            this.desc = string3;
            this.methodList = new ArrayList<Method>();
            this.rep = new RepresentationDocument();
        }

        public boolean isRootResource() {
            return this.rootResource;
        }

        public void setRootResource(boolean bl) {
            this.rootResource = bl;
        }

        public Resource(String string, String string2) {
            this(string, string2, string);
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String string) {
            this.desc = string;
        }

        public List<Method> getMethods() {
            return this.methodList;
        }

        public void addMethod(Method method) {
            this.methodList.add(method);
        }

        protected JavaSource getSource() {
            return this.src;
        }

        protected void setSource(JavaSource javaSource) {
            this.src = javaSource;
        }

        public RepresentationDocument getRepresentation() {
            return this.rep;
        }

        public boolean isContainer() {
            return this.isContainer;
        }

        public void setIsContainer(boolean bl) {
            this.isContainer = bl;
        }

        public boolean isContainerItem() {
            return !this.isContainer;
        }

        public void setIsContainerItem(boolean bl) {
            this.isContainerItem = bl;
        }

        public String toString() {
            return this.getName() + " : " + this.getPath();
        }
    }

    public class WadlModeler
    extends ResourceModel {
        private Map<String, Resource> staticRMap;
        private FileObject fo;
        private String baseUrl;

        public WadlModeler(FileObject fileObject) {
            this.staticRMap = new HashMap<String, Resource>();
            this.fo = fileObject;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public State validate() {
            Object object;
            InputStream inputStream = null;
            try {
                inputStream = this.fo.getInputStream();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                object = documentBuilderFactory.newDocumentBuilder();
                Document document = ((DocumentBuilder)object).parse(inputStream);
                Element element = document.getDocumentElement();
                if (element == null) {
                    State state = State.APP_MISSING;
                    return state;
                }
                List<Node> list = this.getChildNodes(element, "resources");
                if (list == null || list.size() == 0) {
                    State state = State.RESOURCES_MISSING;
                    return state;
                }
                Node node = list.get(0);
                String string = this.getAttributeValue(node, "base");
                if (string == null || string.trim().equals("")) {
                    State state = State.BASE_URL_NULL;
                    return state;
                }
                List<Node> list2 = this.getChildNodes(node, "resource");
                if (list2.isEmpty()) {
                    State state = State.EMPTY_RESOURCES;
                    return state;
                }
            }
            catch (Exception exception) {
                object = State.INVALID;
                return object;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return State.VALID;
        }

        @Override
        public void build() throws IOException {
            State state = this.validate();
            if (state != State.VALID) {
                throw new IOException(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)("MSG_" + state.value())));
            }
            ArrayList<Node> arrayList = new ArrayList<Node>();
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            InputStream inputStream = null;
            try {
                Object object;
                Object object2;
                inputStream = this.fo.getInputStream();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputStream);
                Element element = document.getDocumentElement();
                Node node = this.getChildNodes(element, "resources").get(0);
                this.baseUrl = this.getAttributeValue(node, "base");
                List<Node> list = this.getChildNodes(node, "resource");
                for (Node object3 : list) {
                    arrayList.add(object3);
                }
                for (Node node2 : arrayList) {
                    object2 = this.getChildNodes(node2, "resource");
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Node node3 = object.next();
                        arrayList2.add(node3);
                        NodeList nodeList = RestUtils.getNodeList(node3, "*/resource");
                        if (nodeList == null) continue;
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            arrayList2.add(nodeList.item(i));
                        }
                    }
                }
                for (Node node4 : arrayList) {
                    object2 = this.createResource(document, node4);
                    this.staticRMap.put(((Resource)object2).getName(), (Resource)object2);
                    this.addResource((Resource)object2);
                }
                for (Node node5 : arrayList2) {
                    object2 = this.createResource(document, node5);
                    object = ((Resource)object2).getName();
                    if (((String)object).endsWith("Collection")) {
                        object = ((String)object).substring(0, ((String)object).indexOf("Collection")) + "s";
                    }
                    if (this.staticRMap.get(object) != null) continue;
                    this.addResource((Resource)object2);
                }
                for (Resource resource : this.getResources()) {
                    if (!resource.isContainer() || !this.baseUrl.endsWith("/")) continue;
                    this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
                    break;
                }
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private Resource createResource(Document document, Node node) throws IOException {
            try {
                Object object;
                String string = this.getAttributeValue(node, "path");
                String string2 = this.findResourceNameFromPath(string);
                if (this.isContainerItem(node)) {
                    object = node.getParentNode();
                    String string3 = this.findResourceNameFromPath(this.getAttributeValue((Node)object, "path"));
                    if (string2.startsWith(string3 = string3.substring(0, string3.length() - 1))) {
                        string2 = string3;
                        string = "/" + string2 + "/";
                    }
                }
                string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
                object = new Resource(string2, string);
                this.buildResource((Resource)object, document, node);
                return object;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }

        private String findResourceNameFromPath(String string) {
            String string2 = string.replaceAll("/", "");
            string2 = string2.replace("{", "");
            string2 = string2.replace("}", "");
            return ClientStubModel.normalizeName(string2);
        }

        private void buildResource(Resource resource, Document document, Node node) throws IOException {
            try {
                NodeList nodeList = RestUtils.getNodeList(node, "method");
                if (nodeList != null && nodeList.getLength() > 0) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node2 = nodeList.item(i);
                        String string = this.getAttributeValue(node2, "name");
                        if (string == null) {
                            string = this.getAttributeValue(node2, "href");
                            if (string == null) {
                                throw new IOException("Method do not have name or href attribute for resource: " + resource.getName());
                            }
                            String string2 = string;
                            if (string2.startsWith("#")) {
                                string2 = string2.substring(1);
                            }
                            node2 = this.findMethodNodeByRef(document, string2);
                            string = this.getAttributeValue(node2, "name");
                            this.addMethod(resource, string, node2);
                            continue;
                        }
                        this.addMethod(resource, string, node2);
                    }
                }
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
            this.buildRepresentationDocument(resource, node);
        }

        private void buildRepresentationDocument(Resource resource, Node node) throws IOException {
            RepresentationDocument representationDocument = resource.getRepresentation();
            if (this.isContainer(node)) {
                RepresentationNode representationNode = this.createRootNode(this.findResourceNameFromPath(resource.getPath()));
                representationDocument.setRoot(representationNode);
                representationNode.setIsContainer(resource.isContainer());
                int n = 0;
                this.processSubResource(node, representationDocument, representationNode, resource, n);
            } else if (this.isContainerItem(node)) {
                RepresentationNode representationNode = this.createRootNode(this.findResourceNameFromPath(resource.getPath()));
                representationDocument.setRoot(representationNode);
                List<Node> list = this.getChildNodes(node, "param");
                for (Node node2 : list) {
                    String string = this.getAttributeValue(node2, "name");
                    RepresentationNode representationNode2 = new RepresentationNode(string);
                    representationNode.addChild(representationNode2);
                }
            }
        }

        private RepresentationNode createRootNode(String string) {
            RepresentationNode representationNode = new RepresentationNode(string);
            representationNode.setIsRoot(true);
            return representationNode;
        }

        private void processSubResource(Node node, RepresentationDocument representationDocument, RepresentationNode representationNode, Resource resource, int n) throws IOException {
            List<Node> list = this.getChildNodes(node, "resource");
            for (Node node2 : list) {
                if (!this.isContainerItem(node2)) continue;
                resource.setIsContainer(true);
                String string = this.findResourceNameFromPath(this.getAttributeValue(node2, "path"));
                String string2 = this.findResourceNameFromPath(this.getAttributeValue(node, "path"));
                string2 = string2.substring(0, string2.length() - 1);
                if (string.startsWith(string2)) {
                    string = string2;
                }
                representationNode.addChild(this.createRootNode(string));
            }
        }

        private boolean isContainer(Node node) {
            List<Node> list = this.getChildNodes(node, "resource");
            for (Node node2 : list) {
                if (!this.isContainerItem(node2)) continue;
                return true;
            }
            return false;
        }

        private boolean isContainerItem(Node node) {
            String string = this.getAttributeValue(node, "path");
            return string.contains("{") && string.contains("}");
        }

        private List<Node> getChildNodes(Node node, String string) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            NodeList nodeList = node.getChildNodes();
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    String string2 = node2.getNodeName();
                    if (string2.indexOf(":") != -1) {
                        string2 = string2.substring(string2.indexOf(":") + 1);
                    }
                    if (!string2.equals(string) || node2.getNamespaceURI() != null && !node2.getNamespaceURI().equals(node.getNamespaceURI())) continue;
                    arrayList.add(node2);
                }
            }
            return arrayList;
        }

        private String getAttributeValue(Node node, String string) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Attr attr = (Attr)namedNodeMap.getNamedItem(string);
            if (attr != null) {
                return attr.getNodeValue();
            }
            return null;
        }

        private Node findMethodNodeByRef(Node node, String string) throws XPathExpressionException {
            Node node2 = null;
            NodeList nodeList = RestUtils.getNodeList(node, "//application/method");
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string2;
                    node2 = nodeList.item(i);
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    Attr attr = (Attr)namedNodeMap.getNamedItem("id");
                    if (attr == null || !(string2 = attr.getNodeValue()).equals(string)) continue;
                    return node2;
                }
            }
            return node2;
        }

        private void addMethod(Resource resource, String string, Node node) throws XPathExpressionException {
            if (string != null) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Method method = new Method(string.toLowerCase());
                method.setType(MethodType.valueOf(string));
                NodeList nodeList = RestUtils.getNodeList(node, "request");
                if (nodeList != null && nodeList.getLength() > 0) {
                    object6 = nodeList.item(0);
                    object5 = new Request();
                    object4 = RestUtils.getNodeList((Node)object6, "representation");
                    if (object4 != null && object4.getLength() > 0) {
                        for (int i = 0; i < object4.getLength(); ++i) {
                            Node node2 = object4.item(i);
                            object3 = Constants.MimeType.XML.value();
                            object2 = (Attr)node2.getAttributes().getNamedItem("mediaType");
                            if (object2 != null) {
                                object3 = object2.getNodeValue();
                            }
                            object = new Representation((String)object3);
                            ((Request)object5).addRepresentation((Representation)object);
                        }
                    }
                    method.setRequest((Request)object5);
                }
                if ((object6 = RestUtils.getNodeList(node, "response")) != null && object6.getLength() > 0) {
                    object5 = object6.item(0);
                    object4 = new Response();
                    NodeList nodeList2 = RestUtils.getNodeList((Node)object5, "representation");
                    if (nodeList2 != null && nodeList2.getLength() > 0) {
                        for (int i = 0; i < nodeList2.getLength(); ++i) {
                            object3 = nodeList2.item(i);
                            object2 = Constants.MimeType.XML.value();
                            object = (Attr)object3.getAttributes().getNamedItem("mediaType");
                            if (object != null) {
                                object2 = object.getNodeValue();
                            }
                            Representation representation = new Representation((String)object2);
                            ((Response)object4).addRepresentation(representation);
                        }
                    }
                    method.setResponse((Response)object4);
                }
                resource.addMethod(method);
            }
        }
    }

    public class SourceModeler
    extends ResourceModel {
        private Project p;
        private SortedMap<String, JavaSource> srcMap;
        private Map<String, RepresentationDocument> documentMap;

        public SourceModeler(Project project) {
            this.srcMap = new TreeMap<String, JavaSource>();
            this.documentMap = new HashMap<String, RepresentationDocument>();
            this.p = project;
        }

        private JavaSource getJavaSource(String string) {
            return (JavaSource)this.srcMap.get(string);
        }

        @Override
        public State validate() {
            return State.VALID;
        }

        @Override
        public void build() throws IOException {
            Object object;
            State state = this.validate();
            if (state != State.VALID) {
                throw new IOException(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"MSG_ProjectsWithoutREST") + ", " + state.value());
            }
            List<JavaSource> list = JavaSourceHelper.getJavaSources(this.p);
            ArrayList<JavaSource> arrayList = new ArrayList<JavaSource>();
            ArrayList<JavaSource> arrayList2 = new ArrayList<JavaSource>();
            ArrayList<JavaSource> arrayList3 = new ArrayList<JavaSource>();
            for (JavaSource javaSource : list) {
                if (JavaSourceHelper.isEntity(javaSource) || (object = JavaSourceHelper.getClassNameQuietly(javaSource)) == null) continue;
                this.srcMap.put((String)object, javaSource);
                if (RestUtils.isStaticResource(javaSource)) {
                    arrayList.add(javaSource);
                    continue;
                }
                if (RestUtils.isConverter(javaSource)) {
                    arrayList3.add(javaSource);
                    continue;
                }
                if (!RestUtils.isDynamicResource(javaSource)) continue;
                arrayList2.add(javaSource);
            }
            for (JavaSource javaSource : arrayList) {
                object = this.createResource(javaSource);
                this.addResource((Resource)object);
            }
            for (JavaSource javaSource : arrayList2) {
                object = this.createResource(javaSource);
                this.addResource((Resource)object);
            }
        }

        private Resource createResource(JavaSource javaSource) throws IOException {
            Object object;
            String string = null;
            String string2 = null;
            String string3 = RestUtils.findUri(javaSource);
            boolean bl = false;
            if (string3 != null) {
                string2 = string3;
                string = string2;
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                string = string.substring(0, 1).toUpperCase() + string.substring(1);
                bl = true;
            } else {
                object = JavaSourceHelper.getClassNameQuietly(javaSource);
                string = RestUtils.findStubNameFromClass((String)object);
                string2 = string.substring(0, 1).toLowerCase() + string.substring(1);
            }
            object = new Resource(ClientStubModel.normalizeName(string), string2);
            ((Resource)object).setRootResource(bl);
            this.buildResource((Resource)object, javaSource);
            return object;
        }

        private void buildResource(Resource resource, JavaSource javaSource) throws IOException {
            resource.setSource(javaSource);
            List<MethodTree> list = JavaSourceHelper.getAllMethods(javaSource);
            for (MethodTree methodTree : list) {
                String string = methodTree.getName().toString();
                Method method = null;
                List<? extends AnnotationTree> list2 = methodTree.getModifiers().getAnnotations();
                if (list2 != null && list2.size() > 0) {
                    for (AnnotationTree annotationTree : list2) {
                        String string2 = annotationTree.getAnnotationType().toString();
                        List<? extends ExpressionTree> list3 = annotationTree.getArguments();
                        if ("Path".equals(string2) || "javax.ws.rs.Path".equals(string2)) {
                            method = this.processPathAnnotation(resource, method, string, methodTree, list3);
                            continue;
                        }
                        if ("Produces".equals(string2) || "javax.ws.rs.Produces".equals(string2)) {
                            method = this.processMimeAnnotation(method, string, methodTree, list3, MethodType.GET);
                            continue;
                        }
                        if ("Consumes".equals(string2) || "javax.ws.rs.Consumes".equals(string2)) {
                            method = this.processMimeAnnotation(method, string, methodTree, list3, MethodType.POST);
                            continue;
                        }
                        if (method != null) continue;
                        if ("GET".equals(string2) || "javax.ws.rs.GET".equals(string2)) {
                            method = this.createMethodFromAnnotation(string, methodTree, MethodType.GET);
                            continue;
                        }
                        if ("POST".equals(string2) || "javax.ws.rs.POST".equals(string2)) {
                            method = this.createMethodFromAnnotation(string, methodTree, MethodType.POST);
                            continue;
                        }
                        if ("PUT".equals(string2) || "javax.ws.rs.PUT".equals(string2)) {
                            method = this.createMethodFromAnnotation(string, methodTree, MethodType.PUT);
                            continue;
                        }
                        if (!"DELETE".equals(string2) && !"javax.ws.rs.DELETE".equals(string2)) continue;
                        method = this.createMethodFromAnnotation(string, methodTree, MethodType.DELETE);
                    }
                }
                if (method == null) continue;
                resource.addMethod(method);
            }
            this.buildRepresentationDocument(resource, javaSource);
        }

        private Method createMethodFromAnnotation(String string, MethodTree methodTree, MethodType methodType) {
            Method method = this.createMethod(string, methodTree);
            method.setType(methodType);
            return method;
        }

        private Method processMimeAnnotation(Method method, String string, MethodTree methodTree, List<? extends ExpressionTree> list, MethodType methodType) {
            if (method == null) {
                method = this.createMethod(string, methodTree);
            }
            for (ExpressionTree expressionTree : list) {
                String[] stringArray;
                String string2 = RestUtils.getValueFromAnnotation(expressionTree);
                for (String string3 : stringArray = string2.split(",")) {
                    if ((string3 = string3.trim()).startsWith("\"")) {
                        string3 = string3.substring(1);
                    }
                    if (string3.endsWith("\"")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    Representation representation = new Representation(string3);
                    if (methodType == MethodType.GET) {
                        if (method.getResponse().containsRepresentation(representation)) continue;
                        method.getResponse().addRepresentation(representation);
                        continue;
                    }
                    if (method.getRequest().containsRepresentation(representation)) continue;
                    method.getRequest().addRepresentation(representation);
                }
            }
            return method;
        }

        private Method processPathAnnotation(Resource resource, Method method, String string, MethodTree methodTree, List<? extends ExpressionTree> list) throws IOException {
            int n;
            method = this.createNavigationMethod(string);
            method.setTree(methodTree);
            method.setType(MethodType.GETCHILD);
            for (ExpressionTree expressionTree : list) {
                String string2 = expressionTree.toString();
                if (string2.contains("{")) {
                    String string3 = methodTree.getReturnType().toString();
                    if (string3.indexOf(".") != -1) {
                        string3 = string3.substring(string3.lastIndexOf(".") + 1);
                    }
                    if (string3.indexOf("Resource") != -1) {
                        string3 = string3.substring(0, string3.indexOf("Resource"));
                    }
                    String string4 = resource.getName();
                    if (Util.pluralize(string3).equals(string4)) {
                        resource.setIsContainer(true);
                    }
                    string2 = string2.substring(string2.indexOf("{") + 1, string2.lastIndexOf("}"));
                } else if (string2.contains("\"") && string2.contains("/")) {
                    string2 = string2.substring(string2.indexOf("\"") + 1, string2.lastIndexOf("/"));
                } else {
                    throw new IOException("Cannot find method with @Path(\"subresource/\") or @Path(\"{containerId}/\")");
                }
                ((NavigationMethod)method).setNavigationUri(string2);
            }
            Object object = methodTree.getReturnType().toString();
            if (object != null && (n = ((String)object).lastIndexOf(".")) != -1) {
                object = ((String)object).substring(n + 1);
            }
            String string5 = RestUtils.findStubNameFromClass((String)object);
            ((NavigationMethod)method).setLinkName(string5);
            return method;
        }

        private Method createMethod(String string, MethodTree methodTree) {
            Method method = new Method(string);
            Representation representation = new Representation(Constants.MimeType.XML.value());
            Request request = new Request();
            request.addRepresentation(representation);
            method.setRequest(request);
            Representation representation2 = new Representation(Constants.MimeType.XML.value());
            Response response = new Response();
            response.addRepresentation(representation2);
            method.setResponse(response);
            method.setTree(methodTree);
            return method;
        }

        private Method createNavigationMethod(String string) {
            NavigationMethod navigationMethod = new NavigationMethod(string);
            Representation representation = new Representation(Constants.MimeType.XML.value());
            Request request = new Request();
            request.addRepresentation(representation);
            navigationMethod.setRequest(request);
            Representation representation2 = new Representation(Constants.MimeType.XML.value());
            Response response = new Response();
            response.addRepresentation(representation2);
            navigationMethod.setResponse(response);
            return navigationMethod;
        }

        private void buildRepresentationDocument(Resource resource, JavaSource javaSource) throws IOException {
            RepresentationDocument representationDocument = resource.getRepresentation();
            MethodTree methodTree = RestUtils.findGetAsXmlMethod(javaSource);
            if (methodTree != null) {
                String string = methodTree.getReturnType().toString();
                RepresentationNode representationNode = null;
                JavaSource javaSource2 = this.getJavaSource(string);
                if (javaSource2 != null) {
                    representationNode = this.createRootNode(javaSource2, representationDocument);
                } else {
                    Class clazz = TypeUtil.getClass(string, javaSource, this.p);
                    if (clazz != null) {
                        representationNode = this.createRootNode(clazz, representationDocument);
                    }
                }
                representationDocument.setRoot(representationNode);
                this.documentMap.put(string, representationDocument);
                if (representationNode != null) {
                    representationNode.setIsContainer(resource.isContainer());
                    int n = 0;
                    this.processConverter(string, representationDocument, representationNode, resource, n);
                }
            }
        }

        private RepresentationNode createRootNode(JavaSource javaSource, RepresentationDocument representationDocument) {
            List<? extends AnnotationMirror> list = JavaSourceHelper.getClassAnnotations(javaSource);
            if (list == null) {
                return null;
            }
            for (int i = 0; i < list.size(); ++i) {
                AnnotationMirror annotationMirror = list.get(i);
                String string = annotationMirror.getAnnotationType().toString();
                if (!"XmlRootElement".equals(string) && !"javax.xml.bind.annotation.XmlRootElement".equals(string)) continue;
                String string2 = RestUtils.getValueFromAnnotation(annotationMirror);
                RepresentationNode representationNode = new RepresentationNode(string2);
                representationNode.setIsRoot(true);
                return representationNode;
            }
            return null;
        }

        private RepresentationNode createRootNode(Class clazz, RepresentationDocument representationDocument) {
            List<Annotation> list = TypeUtil.getAnnotations(clazz, true);
            for (Annotation annotation : list) {
                String string = annotation.annotationType().getName();
                if (!"XmlRootElement".equals(string) && !"javax.xml.bind.annotation.XmlRootElement".equals(string)) continue;
                String string2 = TypeUtil.getAnnotationValueName(annotation);
                RepresentationNode representationNode = new RepresentationNode(string2);
                representationNode.setIsRoot(true);
                return representationNode;
            }
            return null;
        }

        private String findBaseClassName(String string) {
            String string2 = string;
            if ((string2.indexOf("Collection<") > -1 || string2.indexOf("List<") > -1 || string2.indexOf("Set<") > -1) && string2.indexOf("<") != -1) {
                string2 = string2.substring(string2.indexOf("<") + 1, string2.indexOf(">"));
            }
            return string2;
        }

        private void processConverter(String string, RepresentationDocument representationDocument, RepresentationNode representationNode, Resource resource, int n) throws IOException {
            assert (string != null);
            String string2 = this.findBaseClassName(string);
            JavaSource javaSource = this.getJavaSource(string2);
            if (javaSource == null) {
                Class clazz = TypeUtil.getClass(string2, resource.getSource(), this.p);
                if (clazz != null) {
                    this.processConverter(clazz, representationDocument, representationNode, resource, n);
                }
            } else {
                this.processConverter(javaSource, representationDocument, representationNode, resource, n);
            }
        }

        private void processConverter(JavaSource javaSource, RepresentationDocument representationDocument, RepresentationNode representationNode, Resource resource, int n) throws IOException {
            if (n++ == 2) {
                return;
            }
            List<? extends AnnotationMirror> list = JavaSourceHelper.getClassAnnotations(javaSource);
            if (list == null || list.size() == 0) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                int n2;
                AnnotationMirror annotationMirror = list.get(i);
                String string = annotationMirror.getAnnotationType().toString();
                if (!"XmlRootElement".equals(string) && !"javax.xml.bind.annotation.XmlRootElement".equals(string)) continue;
                representationNode.setSource(javaSource);
                List<MethodTree> list2 = JavaSourceHelper.getAllMethods(javaSource);
                if (list2 == null) continue;
                ArrayList<RepresentationNode> arrayList = new ArrayList<RepresentationNode>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    MethodTree methodTree = list2.get(n2);
                    List<? extends AnnotationTree> list3 = methodTree.getModifiers().getAnnotations();
                    if (list3 == null) continue;
                    for (int j = 0; j < list3.size(); ++j) {
                        Object object;
                        String string2;
                        AnnotationTree annotationTree = list3.get(j);
                        String string3 = annotationTree.getAnnotationType().toString();
                        if ("XmlElement".equals(string3) || "javax.xml.bind.annotation.XmlElement".equals(string3)) {
                            string2 = methodTree.getReturnType().toString();
                            object = this.documentMap.get(string2);
                            RepresentationNode representationNode2 = null;
                            String string4 = RestUtils.findElementName(methodTree);
                            if (object == null || ((RepresentationDocument)object).getRoot() == null) {
                                String string5 = this.findRepresentationNameFromClass(string2);
                                if (string5 == null || string5.length() == 0) {
                                    string5 = string4;
                                }
                                representationNode2 = new RepresentationNode(string5);
                                representationNode2.setId(string4);
                                representationNode2.setLink(methodTree);
                                arrayList.add(representationNode2);
                                arrayList2.add(string2);
                            } else {
                                representationNode2 = ((RepresentationDocument)object).getRoot().clone();
                                representationNode2.setId(string4);
                            }
                            representationNode.addChild(representationNode2);
                            continue;
                        }
                        if (!"XmlAttribute".equals(string3) && !"javax.xml.bind.annotation.XmlAttribute".equals(string3)) continue;
                        string2 = RestUtils.findElementName(methodTree);
                        object = new RepresentationNode(string2);
                        ((RepresentationNode)object).setLink(methodTree);
                        representationNode.addAttribute((RepresentationNode)object);
                    }
                }
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    this.processConverter((String)arrayList2.get(n2), representationDocument, (RepresentationNode)arrayList.get(n2), resource, n);
                }
            }
        }

        private String findRepresentationNameFromClass(String string) {
            String string2 = this.findBaseClassName(string);
            JavaSource javaSource = this.getJavaSource(string2);
            if (javaSource != null) {
                string2 = RestUtils.findStubNameFromClass(string2);
                return string2.substring(0, 1).toLowerCase() + string2.substring(1);
            }
            return null;
        }

        private void processConverter(Class clazz, RepresentationDocument representationDocument, RepresentationNode representationNode, Resource resource, int n) throws IOException {
            Annotation annotation;
            Object object;
            Object object2;
            String string;
            if (n++ == 2) {
                return;
            }
            representationNode.setSource(null);
            if (!TypeUtil.isXmlRoot(clazz)) {
                return;
            }
            ArrayList<RepresentationNode> arrayList = new ArrayList<RepresentationNode>();
            for (java.lang.reflect.Method accessibleObject : clazz.getMethods()) {
                string = accessibleObject.getGenericReturnType().toString();
                object2 = accessibleObject.getName();
                if (((String)object2).startsWith("get")) {
                    object2 = ((String)object2).substring(3);
                }
                object = this.documentMap.get(string);
                annotation = TypeUtil.getXmlElementAnnotation(accessibleObject);
                if (annotation == null) continue;
                this.collectElement(annotation, representationNode, (RepresentationDocument)object, arrayList, string, (String)object2);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                string = ((Field)accessibleObject).getGenericType().toString();
                object2 = this.documentMap.get(string);
                object = TypeUtil.getXmlElementAnnotation((Field)accessibleObject);
                if (object != null) {
                    this.collectElement((Annotation)object, representationNode, (RepresentationDocument)object2, arrayList, string, ((Field)accessibleObject).getName());
                }
                if ((annotation = TypeUtil.getXmlAttributeAnnotation((Field)accessibleObject)) == null) continue;
                this.collectAttribute(annotation, representationNode, ((Field)accessibleObject).getName());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                this.processConverter(((RepresentationNode)arrayList.get(i)).getType(), representationDocument, (RepresentationNode)arrayList.get(i), resource, n);
            }
        }

        private void collectElement(Annotation annotation, RepresentationNode representationNode, RepresentationDocument representationDocument, List<RepresentationNode> list, String string, String string2) {
            RepresentationNode representationNode2 = null;
            if (representationDocument == null || representationDocument.getRoot() == null) {
                String string3 = TypeUtil.getAnnotationValueName(annotation);
                if (string3 == null) {
                    string3 = string2;
                }
                representationNode2 = new RepresentationNode(string3);
                representationNode2.setType(string);
                representationNode2.setLink(null);
                list.add(representationNode2);
            } else {
                representationNode2 = representationDocument.getRoot();
            }
            representationNode.addChild(representationNode2);
        }

        private void collectAttribute(Annotation annotation, RepresentationNode representationNode, String string) {
            String string2 = TypeUtil.getAnnotationValueName(annotation);
            if (string2 == null || string2.equals("##default")) {
                string2 = string;
            }
            RepresentationNode representationNode2 = new RepresentationNode(string2);
            representationNode2.setLink(null);
            representationNode.addAttribute(representationNode2);
        }
    }

    public abstract class ResourceModel {
        private List<Resource> resourceList = new ArrayList<Resource>();

        public List<Resource> getResources() {
            return this.resourceList;
        }

        public void addResource(Resource resource) {
            this.resourceList.add(resource);
        }

        public abstract State validate();

        public abstract void build() throws IOException;
    }
}

