/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext.preprocessor;

import org.netbeans.mobility.antext.preprocessor.PPLine;

public final class PPBlockInfo {
    private final PPLine startLine;
    private final boolean active;
    private final boolean valid;
    private final boolean toBeCommented;
    private int endLine;
    private boolean hasFooter;
    private final PPBlockInfo parent;
    private final PPBlockInfo ifChainAncestor;

    PPBlockInfo(PPBlockInfo parent, PPLine startLine, boolean valid, boolean active, PPBlockInfo ifChainAncestor) {
        this.parent = parent;
        this.ifChainAncestor = ifChainAncestor;
        this.startLine = startLine;
        this.valid = !(!valid || parent != null && !parent.isValid() || ifChainAncestor != null && !ifChainAncestor.isValid());
        boolean bl = this.toBeCommented = this.valid || parent != null && parent.isToBeCommented();
        this.active = this.valid ? !(!active || ifChainAncestor != null && ifChainAncestor.hasBeenActive() || parent != null && !parent.isActive()) : (parent == null ? active : parent.isActive());
        this.endLine = -1;
        this.hasFooter = false;
    }

    public int getType() {
        return this.startLine.getType();
    }

    public PPBlockInfo getParent() {
        return this.parent;
    }

    public int getStartLine() {
        return this.startLine.getLineNumber();
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isToBeCommented() {
        return this.toBeCommented;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public boolean hasFooter() {
        return this.hasFooter;
    }

    void addError(String message) {
        this.startLine.addError(message);
    }

    void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    void setHasFooter(boolean footer) {
        this.hasFooter = footer;
    }

    boolean hasBeenActive() {
        return this.active || this.ifChainAncestor != null && this.ifChainAncestor.hasBeenActive();
    }
}

