/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.zend.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.spi.commands.FrameworkCommand;
import org.netbeans.modules.php.spi.commands.FrameworkCommandSupport;
import org.netbeans.modules.php.zend.ZendScript;
import org.netbeans.modules.php.zend.commands.ZendCommand;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class ZendCommandSupport
extends FrameworkCommandSupport {
    static final Logger LOGGER = Logger.getLogger(ZendCommandSupport.class.getName());
    private static final String SEPARATOR = ":NB:";
    private static final String COMMANDS_PROVIDER_REL_PATH = "zend/NetBeansCommandsProvider.php";
    private static final File COMMANDS_PROVIDER;

    public ZendCommandSupport(PhpModule phpModule) {
        super(phpModule);
    }

    public String getFrameworkName() {
        return NbBundle.getMessage(ZendCommandSupport.class, (String)"MSG_Zend");
    }

    public void runCommand(FrameworkCommandSupport.CommandDescriptor commandDescriptor) {
        ExternalProcessBuilder callable = this.createCommand(commandDescriptor.getFrameworkCommand().getCommands(), commandDescriptor.getCommandParams());
        ExecutionDescriptor descriptor = this.getDescriptor();
        String displayName = this.getOutputTitle(commandDescriptor);
        ExecutionService service = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)descriptor, (String)displayName);
        service.run();
    }

    protected String getOptionsPath() {
        return ZendScript.getOptionsPath();
    }

    protected File getPluginsDirectory() {
        return null;
    }

    protected ExternalProcessBuilder getProcessBuilder(boolean warnUser) {
        ZendScript zendScript = null;
        try {
            zendScript = ZendScript.getDefault();
        }
        catch (PhpProgram.InvalidPhpProgramException ex) {
            if (warnUser) {
                UiUtils.invalidScriptProvided((String)ex.getMessage(), (String)ZendScript.getOptionsSubPath());
            }
            return null;
        }
        assert (zendScript.isValid());
        ExternalProcessBuilder externalProcessBuilder = zendScript.getProcessBuilder().workingDirectory(FileUtil.toFile((FileObject)this.phpModule.getSourceDirectory()));
        for (String param : zendScript.getParameters()) {
            externalProcessBuilder = externalProcessBuilder.addArgument(param);
        }
        externalProcessBuilder = ZendCommandSupport.registerIncludePathPrepend(externalProcessBuilder);
        return externalProcessBuilder;
    }

    public static ExternalProcessBuilder registerIncludePathPrepend(ExternalProcessBuilder processBuilder) {
        return processBuilder.addEnvironmentVariable("ZEND_TOOL_INCLUDE_PATH_PREPEND", COMMANDS_PROVIDER.getParentFile().getAbsolutePath());
    }

    protected List<FrameworkCommand> getFrameworkCommandsInternal() {
        ExternalProcessBuilder processBuilder = this.createCommand("show", new String[]{"nb-commands", SEPARATOR});
        if (processBuilder == null) {
            return null;
        }
        processBuilder = processBuilder.redirectErrorStream(true);
        final CommandsLineProcessor lineProcessor = new CommandsLineProcessor();
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.ansiStripping((InputProcessor)InputProcessors.bridge((LineProcessor)lineProcessor));
            }
        });
        List<FrameworkCommand> freshCommands = Collections.emptyList();
        ExecutionService service = ExecutionService.newService((Callable)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)"help");
        Future task = service.run();
        try {
            if ((Integer)task.get() == 0) {
                freshCommands = lineProcessor.getCommands();
            }
            NotifyDescriptor.Confirmation descriptor = null;
            if (freshCommands.isEmpty()) {
                String error;
                descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ZendCommandSupport.class, (String)"MSG_NoCommandsRegisterProvider"), 0);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.YES_OPTION) {
                    ZendScript.registerNetBeansProvider();
                }
                if (StringUtils.hasText((String)(error = lineProcessor.getError()))) {
                    descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ZendCommandSupport.class, (String)"MSG_DisplayOutput"), 0);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.YES_OPTION) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)error));
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(error);
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return freshCommands;
    }

    static {
        File commandsProvider = null;
        try {
            commandsProvider = FileUtil.normalizeFile((File)InstalledFileLocator.getDefault().locate(COMMANDS_PROVIDER_REL_PATH, "org.netbeans.modules.php.zend", false).getCanonicalFile());
            if (commandsProvider == null || !commandsProvider.isFile()) {
                throw new IllegalStateException("Could not locate file zend/NetBeansCommandsProvider.php");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not locate file zend/NetBeansCommandsProvider.php", ex);
        }
        COMMANDS_PROVIDER = commandsProvider;
    }

    class CommandsLineProcessor
    implements LineProcessor {
        private final StringBuffer error = new StringBuffer(1000);
        private final String newLine = System.getProperty("line.separator");
        private final List<FrameworkCommand> commands = new LinkedList<FrameworkCommand>();

        CommandsLineProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLine(String line) {
            if (!StringUtils.hasText((String)line)) {
                return;
            }
            if (!line.contains(ZendCommandSupport.SEPARATOR)) {
                this.error.append(line);
                this.error.append(this.newLine);
                return;
            }
            String trimmed = line.trim();
            List exploded = StringUtils.explode((String)trimmed, (String)ZendCommandSupport.SEPARATOR);
            assert (exploded.size() > 0);
            String command = (String)exploded.get(0);
            String description = "";
            if (exploded.size() > 1) {
                description = (String)exploded.get(1);
            }
            List<FrameworkCommand> list = this.commands;
            synchronized (list) {
                this.commands.add(new ZendCommand(ZendCommandSupport.this.phpModule, StringUtils.explode((String)command, (String)" ").toArray(new String[0]), description, command));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<FrameworkCommand> getCommands() {
            ArrayList<FrameworkCommand> copy = null;
            List<FrameworkCommand> list = this.commands;
            synchronized (list) {
                copy = new ArrayList<FrameworkCommand>(this.commands);
            }
            return copy;
        }

        public String getError() {
            return this.error.toString();
        }

        public void close() {
        }

        public void reset() {
        }
    }
}

