/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class SIOProxyClass {
    static String COPYRIGHT = "/* \n * Copyright (c) 2009 Sun Microsystems, Inc. \n * All rights reserved. \n * Use is subject to license terms. \n */\n";
    String package_name;
    Vector<String> imports;
    String proxy_name;
    Vector<String> all_ref_SIs;
    Map<String, Vector<String>> duplicate_sig_SIs;
    Hashtable<String, Vector<String>> si_method_signatures;
    String formattedSIOProxyClass = null;

    public SIOProxyClass(String string, Vector<String> vector, Map<String, Vector<String>> map, String string2, Hashtable<String, Vector<String>> hashtable) {
        this.proxy_name = string2;
        this.package_name = string.replaceAll("/", ".") + ".proxy";
        this.all_ref_SIs = vector;
        this.all_ref_SIs.addElement("javacard/framework/Shareable");
        this.duplicate_sig_SIs = map;
        this.si_method_signatures = hashtable;
        this.formatClass();
    }

    private void formatImports() {
        this.imports = new Vector();
        this.imports.addElement("javacardx.framework.ClassicSIOProxy");
        Enumeration<String> enumeration = this.si_method_signatures.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = string.replaceAll("/", ".");
            if (!this.imports.contains(string2)) {
                this.imports.addElement(string2);
            }
            Vector<String> vector = this.si_method_signatures.get(string);
            Enumeration<String> enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string3;
                String string4 = enumeration2.nextElement();
                String string5 = MethodDescriptor.getMethodDescriptorFromSignature(string4);
                String string6 = MethodDescriptor.getReturnDescriptor(string5);
                String[] stringArray = MethodDescriptor.getParamDescriptors(string5);
                String string7 = string6;
                while (string7.startsWith("[")) {
                    string7 = string7.substring(1);
                }
                if (DataType.getType(string7) == 10 && !this.imports.contains(string3 = Names.getTypeStringInJavaStyle(string7))) {
                    this.imports.add(string3);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    String string8;
                    string7 = stringArray[i];
                    while (string7.startsWith("[")) {
                        string7 = string7.substring(1);
                    }
                    if (DataType.getType(string7) != 10 || this.imports.contains(string8 = Names.getTypeStringInJavaStyle(string7))) continue;
                    this.imports.add(string8);
                }
            }
        }
    }

    public String getClassName() {
        return this.proxy_name;
    }

    public void formatClass() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COPYRIGHT);
        stringBuffer.append("package " + this.package_name + ";\n\n");
        this.formatImports();
        Iterator<String> iterator = this.imports.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("import " + iterator.next() + ";\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("public class " + this.proxy_name + " extends " + "ClassicSIOProxy \n");
        stringBuffer.append("                    implements ");
        Enumeration<String> enumeration = this.si_method_signatures.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            stringBuffer.append(Names.getClassName((String)object, 47));
            if (enumeration.hasMoreElements()) {
                stringBuffer.append(", ");
                continue;
            }
            stringBuffer.append(" {\n");
        }
        object = this.si_method_signatures.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            Vector<String> vector = this.si_method_signatures.get(string);
            Enumeration<String> enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = enumeration2.nextElement();
                this.formatMethodEntry(stringBuffer, string, string2);
            }
        }
        stringBuffer.append("}\n");
        this.formattedSIOProxyClass = stringBuffer.toString();
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.formattedSIOProxyClass.getBytes());
    }

    private void formatMethodEntry(StringBuffer stringBuffer, String string, String string2) {
        boolean bl = false;
        String string3 = MethodDescriptor.getMethodDescriptorFromSignature(string2);
        String string4 = MethodDescriptor.getReturnDescriptor(string3);
        if (DataType.getType(string4) == 10) {
            bl = true;
        }
        String[] stringArray = MethodDescriptor.getParamDescriptors(string3);
        for (int i = 0; i < stringArray.length; ++i) {
            if (DataType.getType(stringArray[i]) != 10) continue;
            bl = true;
        }
        if (bl) {
            this.formatMethodsWithGetInstance(stringBuffer, string, string2);
        } else {
            this.formatMethods(stringBuffer, string, string2);
        }
    }

    private void formatMethodsWithGetInstance(StringBuffer stringBuffer, String string, String string2) {
        String string3 = MethodDescriptor.getMethodDescriptorFromSignature(string2);
        String string4 = MethodDescriptor.getReturnDescriptor(string3);
        String string5 = Names.getTypeStringInJavaStyle(string4);
        string5 = Names.getClassName(string5, 46);
        String string6 = this.getMethodPrototypeTyped(string2);
        stringBuffer.append("\n");
        stringBuffer.append("    public " + string5 + " " + string6 + " {\n");
        stringBuffer.append("        try {\n");
        stringBuffer.append("            synchronized (CLASSIC_APPLET_CONTAINER_MUTEX) {\n");
        String string7 = this.getReturnPrototype(string, string2);
        stringBuffer.append(string7);
        stringBuffer.append("        } catch (ClassNotFoundException e) {\n");
        stringBuffer.append("            throw new RuntimeException(\"SIO Synchronization Proxy Error: Class Not Found\");\n");
        stringBuffer.append("        } catch (InstantiationException e) {\n");
        stringBuffer.append("            throw new RuntimeException(\"SIO Synchronization Proxy Error: Instantiation Exception\");\n");
        stringBuffer.append("        }\n");
        stringBuffer.append("    }\n");
    }

    private String getMethodPrototypeTyped(String string) {
        String string2 = MethodDescriptor.getMethodNameFromSignature(string);
        String string3 = MethodDescriptor.getMethodDescriptorFromSignature(string);
        String[] stringArray = MethodDescriptor.getParamDescriptors(string3);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2 + "(");
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = Names.getTypeStringInJavaStyle(stringArray[i]);
            string4 = Names.getClassName(string4, 46);
            stringBuffer.append(string4 + " ");
            stringBuffer.append("param" + (i + 1));
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String getMethodPrototype(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "(");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = Names.getTypeStringInJavaStyle(stringArray[i]);
            string2 = string2.replace('.', '/');
            boolean bl = false;
            if (DataType.getType(stringArray[i]) == 10) {
                bl = true;
            }
            if (bl) {
                string2 = Names.getClassName(string2, 47);
                stringBuffer.append("(" + string2 + ")processParam(");
            }
            stringBuffer.append("param" + (i + 1));
            if (bl) {
                stringBuffer.append(")");
            }
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String getReturnPrototype(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = MethodDescriptor.getMethodNameFromSignature(string2);
        String string4 = MethodDescriptor.getMethodDescriptorFromSignature(string2);
        String[] stringArray = MethodDescriptor.getParamDescriptors(string4);
        String string5 = MethodDescriptor.getReturnDescriptor(string4);
        String string6 = this.getMethodPrototype(string3, stringArray);
        if (this.duplicate_sig_SIs.containsKey(string2)) {
            int n = 1;
            Vector<String> vector = this.duplicate_sig_SIs.get(string2);
            String[] stringArray2 = new String[vector.size()];
            for (String string7 : vector.toArray(stringArray2)) {
                string7 = Names.getClassName(string7, 47);
                if (n == 1) {
                    stringBuffer.append("                if (getSIO() instanceof " + string7 + ") {\n");
                } else {
                    stringBuffer.append("                else if (getSIO() instanceof " + string7 + ") {\n");
                }
                boolean bl = false;
                boolean bl2 = false;
                String string8 = null;
                if (DataType.getType(string5) != 9) {
                    bl = true;
                    string8 = Names.getTypeStringInJavaStyle(string5);
                    string8 = string8.replaceAll("\\.", "/");
                    if (DataType.getType(string5) == 10) {
                        bl2 = true;
                    }
                    string8 = Names.getClassName(string8, 47);
                }
                if (bl) {
                    stringBuffer.append("                     return ");
                }
                if (bl2) {
                    stringBuffer.append("(" + string8 + ")" + "processReturn(");
                }
                stringBuffer.append("((" + string7 + ")getSIO())." + string6);
                if (bl2) {
                    stringBuffer.append(")");
                }
                stringBuffer.append(";\n");
                stringBuffer.append("                }\n");
                ++n;
            }
            stringBuffer.append("                else {\n");
            stringBuffer.append("                    throw new RuntimeException(\"SIO Synchronization Proxy Error\");\n");
            stringBuffer.append("                }\n");
            stringBuffer.append("            }\n");
        } else {
            boolean bl = false;
            String string9 = null;
            string = Names.getClassName(string, 47);
            stringBuffer.append("            ");
            if (DataType.getType(string5) != 9) {
                string9 = Names.getTypeStringInJavaStyle(string5);
                string9 = string9.replace('.', '/');
                if (DataType.getType(string5) == 10) {
                    bl = true;
                }
                string9 = Names.getClassName(string9, 47);
                stringBuffer.append("return ");
            }
            if (bl) {
                stringBuffer.append("(" + string9 + ")" + "processReturn(");
            }
            stringBuffer.append("((" + string + ")getSIO())." + string6);
            if (bl) {
                stringBuffer.append(")");
            }
            stringBuffer.append(";\n");
            stringBuffer.append(" }\n");
        }
        return stringBuffer.toString();
    }

    private void formatMethods(StringBuffer stringBuffer, String string, String string2) {
        String string3 = MethodDescriptor.getMethodNameFromSignature(string2);
        String string4 = MethodDescriptor.getMethodDescriptorFromSignature(string2);
        String[] stringArray = MethodDescriptor.getParamDescriptors(string4);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = Names.getTypeStringInJavaStyle(stringArray[i]);
        }
        String string5 = MethodDescriptor.getReturnDescriptor(string4);
        String string6 = Names.getTypeStringInJavaStyle(string5);
        String string7 = Names.getMethodPrototypeInJavaStyle(string3, stringArray2, false);
        String string8 = Names.getMethodPrototypeInJavaStyle(string3, stringArray2, true);
        string6 = Names.getClassName(string6, 46);
        stringBuffer.append("\n");
        stringBuffer.append("    public " + string6 + " " + string8 + " {\n");
        stringBuffer.append("        synchronized (CLASSIC_APPLET_CONTAINER_MUTEX) {\n");
        if (this.duplicate_sig_SIs.containsKey(string2)) {
            int n = 1;
            Vector<String> vector = this.duplicate_sig_SIs.get(string2);
            String[] stringArray3 = new String[vector.size()];
            for (String string9 : vector.toArray(stringArray3)) {
                string9 = Names.getClassName(string9, 47);
                if (n == 1) {
                    stringBuffer.append("            if (getSIO() instanceof " + string9 + ") {\n");
                } else {
                    stringBuffer.append("            else if (getSIO() instanceof " + string9 + ") {\n");
                }
                if (DataType.getType(string5) != 9) {
                    stringBuffer.append("return ");
                }
                stringBuffer.append("                ((" + string9 + ")getSIO())." + string7 + ";\n");
                stringBuffer.append("            }\n");
                ++n;
            }
            stringBuffer.append("            else {\n");
            stringBuffer.append("                throw new RuntimeException(\"SIO Synchronization Proxy Error\");\n");
            stringBuffer.append("            }\n");
        } else {
            string = Names.getClassName(string, 47);
            if (DataType.getType(string5) != 9) {
                stringBuffer.append("return ");
            }
            stringBuffer.append("((" + string + ")getSIO())." + string7 + ";\n");
        }
        stringBuffer.append("}\n");
        stringBuffer.append("    }\n");
    }
}

