/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.debugcomponent.FieldDebugInfo;
import com.sun.javacard.debugcomponent.MethodDebugInfo;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcMethod;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;

public class ClassDebugInfo
extends ClassDefinition {
    private static final int ACC_SHAREABLE = 2048;
    private static final int ACC_REMOTE = 32;
    private int name_index;
    private int location;
    private int superclass_name_index;
    private int[] interface_names_index;
    private int source_file_name_index;
    FieldDebugInfo[] fields;
    MethodDebugInfo[] methods;

    public ClassDebugInfo(JcClass jcClass, DebugComponent debugComponent) {
        super(jcClass);
        this.build(jcClass, debugComponent);
    }

    private void build(JcClass jcClass, DebugComponent debugComponent) {
        this.name_index = debugComponent.addString(this.class_name);
        this.superclass_name_index = this.super_class_name == null ? debugComponent.addString("null") : debugComponent.addString(this.super_class_name);
        if (this.source_file_name == null) {
            throw new RuntimeException();
        }
        if (jcClass.isShareableType()) {
            this.access_flags |= 0x800;
        }
        if (jcClass.isRemote()) {
            this.access_flags |= 0x20;
        }
        this.source_file_name_index = debugComponent.addString(this.source_file_name);
        String[] stringArray = jcClass.getSuperInterfaces();
        this.interface_names_index = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.interface_names_index[i] = debugComponent.addString(stringArray[i]);
        }
        JcField[] jcFieldArray = jcClass.getFields();
        this.fields = new FieldDebugInfo[jcFieldArray.length];
        for (int i = 0; i < jcFieldArray.length; ++i) {
            this.fields[i] = new FieldDebugInfo(jcFieldArray[i], debugComponent);
        }
        JcMethod[] jcMethodArray = jcClass.getMethods();
        this.methods = new MethodDebugInfo[jcMethodArray.length];
        for (int i = 0; i < jcMethodArray.length; ++i) {
            this.methods[i] = new MethodDebugInfo(jcMethodArray[i], debugComponent);
        }
    }

    public int getSize() {
        int n = 0;
        for (FieldDebugInfo object : this.fields) {
            n += object.getSize();
        }
        for (MethodDebugInfo methodDebugInfo : this.methods) {
            n += methodDebugInfo.getSize();
        }
        return n + 15 + this.interface_names_index.length * 2;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        String string = stringBuffer.toString();
        stringBuffer2.append(string + "class_debug_info { ");
        stringBuffer2.append(string + "\tname_index " + this.name_index + "\t\t//" + this.class_name);
        if ((this.access_flags & 0x800) != 0) {
            stringBuffer2.append(string + "\taccess_flags " + Modifier.toString(this.access_flags & 0xFFFFF7FF));
            stringBuffer2.append(" shareable");
        } else {
            stringBuffer2.append(string + "\taccess_flags " + Modifier.toString(this.access_flags));
        }
        stringBuffer2.append(string + "\tlocation " + this.location);
        stringBuffer2.append(string + "\tsuperclass_name_index " + this.superclass_name_index + "\t\t//" + this.super_class_name);
        stringBuffer2.append(string + "\tsource_file_name_index " + this.source_file_name_index + "\t\t//" + this.source_file_name);
        stringBuffer2.append(string + "\tinterface_count " + this.interface_names_index.length);
        stringBuffer2.append(string + "\tfield_count " + this.fields.length);
        stringBuffer2.append(string + "\tmethod_count " + this.methods.length);
        if (this.interface_names_index.length != 0) {
            stringBuffer2.append(string + "\tinterface_names_index ");
            for (int fieldDebugInfo : this.interface_names_index) {
                stringBuffer2.append(fieldDebugInfo + " ");
            }
            stringBuffer2.append("\n");
        }
        for (FieldDebugInfo fieldDebugInfo : this.fields) {
            stringBuffer2.append(fieldDebugInfo.toString(n + 1));
        }
        for (MethodDebugInfo methodDebugInfo : this.methods) {
            stringBuffer2.append(methodDebugInfo.toString(n + 1));
        }
        stringBuffer2.append(string + "}");
        return stringBuffer2.toString();
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.location);
        dataOutputStream.writeShort(this.superclass_name_index);
        dataOutputStream.writeShort(this.source_file_name_index);
        dataOutputStream.writeByte(this.interface_names_index.length);
        dataOutputStream.writeShort(this.fields.length);
        dataOutputStream.writeShort(this.methods.length);
        for (int n : this.interface_names_index) {
            dataOutputStream.writeShort(n);
        }
        for (FieldDebugInfo fieldDebugInfo : this.fields) {
            fieldDebugInfo.toBinary(dataOutputStream);
        }
        for (MethodDebugInfo methodDebugInfo : this.methods) {
            methodDebugInfo.toBinary(dataOutputStream);
        }
        dataOutputStream.flush();
    }
}

