/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.actions.AbstractExecutorRunAction;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.loaders.QtProjectDataObject;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;

public class QMakeAction
extends AbstractExecutorRunAction {
    public String getName() {
        return QMakeAction.getString("BTN_Qmake");
    }

    @Override
    protected boolean accept(DataObject object) {
        return object instanceof QtProjectDataObject;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            this.performAction(activatedNodes[i]);
        }
    }

    protected void performAction(Node node) {
        QMakeAction.performAction(node, null, null, QMakeAction.getProject(node), null);
    }

    public static Future<Integer> performAction(final Node node, final ExecutionListener listener, final Writer outputListener, final Project project, final InputOutput inputOutput) {
        if (SwingUtilities.isEventDispatchThread()) {
            ModalMessageDlg.LongWorker runner = new ModalMessageDlg.LongWorker(){
                private ExecutionService es;

                public void doWork() {
                    this.es = QMakeAction.prepare(node, listener, outputListener, project, inputOutput);
                }

                public void doPostRunInEDT() {
                    if (this.es != null) {
                        this.es.run();
                    }
                }
            };
            Frame mainWindow = WindowManager.getDefault().getMainWindow();
            String title = QMakeAction.getString("DLG_TITLE_Prepare", "qmake");
            String msg = QMakeAction.getString("MSG_TITLE_Prepare", "qmake");
            ModalMessageDlg.runLongTask((Window)mainWindow, (String)title, (String)msg, (ModalMessageDlg.LongWorker)runner, null);
        } else {
            ExecutionService es = QMakeAction.prepare(node, listener, outputListener, project, inputOutput);
            if (es != null) {
                return es.run();
            }
        }
        return null;
    }

    private static ExecutionService prepare(Node node, ExecutionListener listener, Writer outputListener, Project project, InputOutput inputOutput) {
        RemoteSyncWorker syncWorker;
        QMakeAction.saveNode(node);
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        File proFile = FileUtil.toFile((FileObject)fileObject);
        String buildDir = QMakeAction.getBuildDirectory(node, PredefinedToolKind.QMakeTool);
        String executable = QMakeAction.getCommand(node, project, PredefinedToolKind.QMakeTool, "qmake");
        String arguments = proFile.getName();
        String[] args = QMakeAction.getArguments(node, PredefinedToolKind.QMakeTool);
        ExecutionEnvironment execEnv = QMakeAction.getExecutionEnvironment(fileObject, project);
        buildDir = QMakeAction.convertToRemoteIfNeeded(execEnv, buildDir);
        if (buildDir == null) {
            return null;
        }
        Map<String, String> envMap = QMakeAction.getEnv(execEnv, node, null);
        StringBuilder argsFlat = new StringBuilder(arguments);
        for (int i = 0; i < args.length; ++i) {
            argsFlat.append(" ");
            argsFlat.append(args[i]);
        }
        QMakeAction.traceExecutable(executable, buildDir, argsFlat, envMap);
        if (inputOutput == null) {
            String tabName = execEnv.isLocal() ? QMakeAction.getString("QMAKE_LABEL", node.getName()) : QMakeAction.getString("QMAKE_REMOTE_LABEL", node.getName(), execEnv.getDisplayName());
            InputOutput _tab = IOProvider.getDefault().getIO(tabName, false);
            _tab.closeInputOutput();
            InputOutput tab = IOProvider.getDefault().getIO(tabName, true);
            try {
                tab.getOut().reset();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            inputOutput = tab;
        }
        if ((syncWorker = RemoteSyncSupport.createSyncWorker((Project)project, (PrintWriter)inputOutput.getOut(), (PrintWriter)inputOutput.getErr())) != null && !syncWorker.startup(envMap)) {
            return null;
        }
        AbstractExecutorRunAction.ProcessChangeListener processChangeListener = new AbstractExecutorRunAction.ProcessChangeListener(listener, outputListener, null, inputOutput, "QMake", syncWorker);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv).setWorkingDirectory(buildDir).unbufferOutput(false).addNativeProcessListener((ChangeListener)processChangeListener);
        npb.getEnvironment().putAll(envMap);
        npb.redirectError();
        List<String> list = ImportUtils.parseArgs(argsFlat.toString());
        list = ImportUtils.normalizeParameters(list);
        npb.setExecutable(executable);
        npb.setArguments(list.toArray(new String[list.size()]));
        ExecutionDescriptor descr = new ExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).inputOutput(inputOutput).outLineBased(true).showProgress(true).postExecution((Runnable)processChangeListener).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener);
        return ExecutionService.newService((Callable)npb, (ExecutionDescriptor)descr, (String)"qmake");
    }
}

