/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.multiview;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.websvc.design.multiview.MultiViewSupport;
import org.netbeans.modules.websvc.design.multiview.ShowComponentCookie;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class SourceMultiViewElement
extends CloneableEditor
implements MultiViewElement {
    private static final long serialVersionUID = 4403502726950453345L;
    private transient JComponent toolbar;
    private transient MultiViewElementCallback multiViewCallback;
    private transient Lookup myLookup;

    public SourceMultiViewElement() {
        this(null);
    }

    public SourceMultiViewElement(DataEditorSupport dataEditorSupport) {
        super((CloneableEditorSupport)dataEditorSupport);
        this.initialize();
    }

    private void initialize() {
        ShowComponentCookie showComponentCookie = new ShowComponentCookie(){

            @Override
            public void show(Object object) {
                if (!(object instanceof ElementHandle)) {
                    return;
                }
                final ElementHandle elementHandle = (ElementHandle)object;
                try {
                    JavaSource javaSource = JavaSource.forFileObject((FileObject)SourceMultiViewElement.this.getEditorSupport().getDataObject().getPrimaryFile());
                    CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

                        public void run(WorkingCopy workingCopy) throws IOException {
                            workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Element element = elementHandle.resolve((CompilationInfo)workingCopy);
                            SourcePositions sourcePositions = workingCopy.getTrees().getSourcePositions();
                            int n = -1;
                            switch (element.getKind()) {
                                case METHOD: {
                                    BlockTree blockTree;
                                    MethodTree methodTree = workingCopy.getTrees().getTree((ExecutableElement)element);
                                    Tree tree = blockTree = methodTree.getBody();
                                    if (!blockTree.getStatements().isEmpty()) {
                                        tree = blockTree.getStatements().get(0);
                                    }
                                    n = (int)sourcePositions.getStartPosition(workingCopy.getCompilationUnit(), tree);
                                }
                            }
                            if (n > 0) {
                                SourceMultiViewElement.this.getEditorPane().setCaretPosition(n);
                            }
                        }

                        public void cancel() {
                        }
                    };
                    javaSource.runModificationTask((Task)cancellableTask).commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.myLookup = Lookups.fixed((Object[])new Object[]{showComponentCookie});
    }

    public JComponent getToolbarRepresentation() {
        Document document = this.getEditorPane().getDocument();
        if (document instanceof NbDocument.CustomToolbar) {
            if (this.toolbar == null) {
                this.toolbar = ((NbDocument.CustomToolbar)document).createToolbar(this.getEditorPane());
            }
            return this.toolbar;
        }
        return null;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void updateName() {
        super.updateName();
        this.updateMultiViewHtmlDisplayName();
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewCallback = multiViewElementCallback;
        this.updateMultiViewHtmlDisplayName();
    }

    private void updateMultiViewHtmlDisplayName() {
        if (this.multiViewCallback != null) {
            if (EventQueue.isDispatchThread()) {
                this.multiViewCallback.getTopComponent().setHtmlDisplayName(this.getHtmlDisplayName());
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SourceMultiViewElement.this.multiViewCallback.getTopComponent().setHtmlDisplayName(SourceMultiViewElement.this.getHtmlDisplayName());
                    }
                });
            }
        }
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentShowing() {
        super.componentShowing();
        DataObject dataObject = this.getEditorSupport().getDataObject();
        if (dataObject == null || !dataObject.isValid()) {
            this.setActivatedNodes(new Node[0]);
        } else {
            this.setActivatedNodes(new Node[]{this.getEditorSupport().getDataObject().getNodeDelegate()});
        }
    }

    public void componentHidden() {
        super.componentHidden();
        this.setActivatedNodes(new Node[0]);
    }

    public void open() {
        if (this.multiViewCallback != null) {
            this.multiViewCallback.requestVisible();
        } else {
            super.open();
        }
    }

    public void requestVisible() {
        if (this.multiViewCallback != null) {
            this.multiViewCallback.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.multiViewCallback != null) {
            this.multiViewCallback.requestActive();
        } else {
            super.requestActive();
        }
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public UndoRedo getUndoRedo() {
        return super.getUndoRedo();
    }

    protected boolean closeLast() {
        if (MultiViewSupport.getNumberOfClones(this.multiViewCallback.getTopComponent()) == 0) {
            return super.closeLast();
        }
        return true;
    }

    public CloseOperationState canCloseElement() {
        if (!this.getEditorSupport().isModified() || MultiViewSupport.getNumberOfClones(this.multiViewCallback.getTopComponent()) > 1) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)MultiViewSupport.SOURCE_UNSAFE_CLOSE, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SourceMultiViewElement.this.getEditorSupport().saveDocument();
                    SourceMultiViewElement.this.getEditorSupport().getDataObject().setModified(false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
    }

    private DataEditorSupport getEditorSupport() {
        return (DataEditorSupport)this.cloneableEditorSupport();
    }

    public Lookup getLookup() {
        return new ProxyLookup(new Lookup[]{super.getLookup(), this.myLookup});
    }
}

