/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class EjbJarMultiViewDataNode
extends DataNode {
    private static final String DEPLOYMENT = "deployment";
    private EjbJarMultiViewDataObject dataObject;
    public static final String PROPERTY_DOCUMENT_TYPE = "documentType";
    private PropertyChangeListener ddListener;

    public EjbJarMultiViewDataNode(EjbJarMultiViewDataObject ejbJarMultiViewDataObject) {
        this(ejbJarMultiViewDataObject, Children.LEAF);
    }

    public EjbJarMultiViewDataNode(EjbJarMultiViewDataObject ejbJarMultiViewDataObject, Children children) {
        super((DataObject)ejbJarMultiViewDataObject, children);
        this.dataObject = ejbJarMultiViewDataObject;
        this.initListeners();
        this.setIconBase(this.dataObject.getSaxError() == null);
    }

    private void initListeners() {
        this.ddListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getOldValue();
                Object object2 = propertyChangeEvent.getNewValue();
                if ("documentDTD".equals(string)) {
                    EjbJarMultiViewDataNode.this.firePropertyChange(EjbJarMultiViewDataNode.PROPERTY_DOCUMENT_TYPE, object, object2);
                } else if ("valid".equals(string) && Boolean.TRUE.equals(object2)) {
                    EjbJarMultiViewDataNode.this.removePropertyChangeListener(EjbJarMultiViewDataNode.this.ddListener);
                } else if ("document_valid".equals(string)) {
                    EjbJarMultiViewDataNode.this.setIconBase(Boolean.TRUE.equals(object2));
                } else if ("propertySets".equals(string)) {
                    EjbJarMultiViewDataNode.this.firePropertySetsChange(null, null);
                } else if ("sax_error".equals(string)) {
                    EjbJarMultiViewDataNode.this.fireShortDescriptionChange((String)object, (String)object2);
                }
            }
        };
        this.getDataObject().addPropertyChangeListener(this.ddListener);
    }

    private void setIconBase(boolean bl) {
        if (bl) {
            this.setIconBaseWithExtension(this.dataObject.getIconBaseForValidDocument());
        } else {
            this.setIconBaseWithExtension(this.dataObject.getIconBaseForInvalidDocument());
        }
        this.fireIconChange();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = new Sheet.Set();
        set.setName(DEPLOYMENT);
        set.setDisplayName(NbBundle.getMessage(EjbJarMultiViewDataNode.class, (String)"PROP_deploymentSet"));
        set.setShortDescription(NbBundle.getMessage(EjbJarMultiViewDataNode.class, (String)"HINT_deploymentSet"));
        set.setValue("helpID", (Object)"TBD---Ludo ejbjar node");
        PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite(PROPERTY_DOCUMENT_TYPE, String.class, NbBundle.getBundle(EjbJarMultiViewDataNode.class).getString("PROP_documentDTD"), NbBundle.getBundle(EjbJarMultiViewDataNode.class).getString("HINT_documentDTD")){

            public Object getValue() {
                BigDecimal bigDecimal = EjbJarMultiViewDataNode.this.dataObject.getEjbJar().getVersion();
                return bigDecimal == null ? "" : bigDecimal.toString();
            }

            public void setValue(Object object) {
                String string = (String)object;
                if ("2.1".equals(string) && !string.equals(EjbJarMultiViewDataNode.this.dataObject.getEjbJar().getVersion().toString())) {
                    EjbJarMultiViewDataNode.this.dataObject.getEjbJar().setVersion(new BigDecimal(string));
                    EjbJarMultiViewDataNode.this.dataObject.modelUpdatedFromUI();
                }
            }
        };
        set.put((Node.Property)readWrite);
        sheet.put(set);
        return sheet;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Image getIcon(int n) {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/web/resources/DDDataIcon.gif");
        if (this.dataObject.getSaxError() == null) {
            return image;
        }
        Image image2 = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/web/resources/error-badge.gif");
        return ImageUtilities.mergeImages((Image)image, (Image)image2, (int)6, (int)6);
    }

    void descriptionChanged(String string, String string2) {
        this.setShortDescription(string2 == null ? "Enterprise Bean deployment descriptor" : string2);
    }

    public String getShortDescription() {
        SAXException sAXException = this.dataObject.getSaxError();
        if (sAXException == null) {
            return Utils.getBundleMessage("HINT_ejb_dd");
        }
        return sAXException.getMessage();
    }
}

