/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.lexer.api.CssTokenId;
import org.netbeans.modules.css.refactoring.CssElementContext;
import org.netbeans.modules.css.refactoring.CssRenameRefactoringUI;
import org.netbeans.modules.css.refactoring.WhereUsedUI;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class CssActionsImplementationProvider
extends ActionsImplementationProvider {
    private static final Logger LOG = Logger.getLogger(CssActionsImplementationProvider.class.getName());

    public boolean canRename(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node node = (Node)nodes.iterator().next();
        return CssActionsImplementationProvider.isCssContext(node);
    }

    public void doRename(Lookup selectedNodes) {
        EditorCookie ec = (EditorCookie)selectedNodes.lookup(EditorCookie.class);
        if (CssActionsImplementationProvider.isFromEditor(ec)) {
            new TextComponentTask(ec){

                @Override
                protected RefactoringUI createRefactoringUI(CssElementContext context) {
                    return new CssRenameRefactoringUI(context);
                }
            }.run();
        } else {
            Collection nodes = selectedNodes.lookupAll(Node.class);
            assert (nodes.size() == 1);
            Node currentNode = (Node)nodes.iterator().next();
            new NodeToFileTask(currentNode){

                @Override
                protected RefactoringUI createRefactoringUI(CssElementContext context) {
                    return new CssRenameRefactoringUI(context);
                }
            }.run();
        }
    }

    public boolean canFindUsages(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node node = (Node)nodes.iterator().next();
        return CssActionsImplementationProvider.isCssContext(node);
    }

    public void doFindUsages(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (CssActionsImplementationProvider.isFromEditor(ec)) {
            new TextComponentTask(ec){

                @Override
                protected RefactoringUI createRefactoringUI(CssElementContext context) {
                    return new WhereUsedUI(context);
                }
            }.run();
        } else {
            Collection nodes = lookup.lookupAll(Node.class);
            assert (nodes.size() == 1);
            Node currentNode = (Node)nodes.iterator().next();
            new NodeToFileTask(currentNode){

                @Override
                protected RefactoringUI createRefactoringUI(CssElementContext context) {
                    return new WhereUsedUI(context);
                }
            }.run();
        }
    }

    private static boolean isCssContext(Node node) {
        FileObject fo = CssActionsImplementationProvider.getFileObjectFromNode(node);
        if (fo == null) {
            return false;
        }
        if ("text/x-css".equals(fo.getMIMEType())) {
            return true;
        }
        EditorCookie ec = CssActionsImplementationProvider.getEditorCookie(node);
        if (CssActionsImplementationProvider.isFromEditor(ec)) {
            final StyledDocument doc = ec.getDocument();
            JEditorPane pane = ec.getOpenedPanes()[0];
            final int offset = pane.getCaretPosition();
            final AtomicBoolean ref = new AtomicBoolean(false);
            doc.render(new Runnable(){

                @Override
                public void run() {
                    ref.set(null != LexerUtils.getJoinedTokenSequence((Document)doc, (int)offset, CssTokenId.language()));
                }
            });
            return ref.get();
        }
        return false;
    }

    private static FileObject getFileObjectFromNode(Node node) {
        DataObject dobj = (DataObject)node.getLookup().lookup(DataObject.class);
        return dobj != null ? dobj.getPrimaryFile() : null;
    }

    private static boolean isFromEditor(EditorCookie ec) {
        TopComponent activetc;
        return ec != null && ec.getOpenedPanes() != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    private static EditorCookie getEditorCookie(Node node) {
        return (EditorCookie)node.getLookup().lookup(EditorCookie.class);
    }

    public static abstract class TextComponentTask
    extends UserTask
    implements Runnable {
        private final Document document;
        private final int caretOffset;
        private final int selectionStart;
        private final int selectionEnd;
        private RefactoringUI ui;

        public TextComponentTask(EditorCookie ec) {
            JEditorPane textC = ec.getOpenedPanes()[0];
            this.document = textC.getDocument();
            this.caretOffset = textC.getCaretPosition();
            this.selectionStart = textC.getSelectionStart();
            this.selectionEnd = textC.getSelectionEnd();
        }

        public void run(ResultIterator ri) throws ParseException {
            CssParserResult result;
            Snapshot topLevelSnapshot = ri.getSnapshot();
            ResultIterator cssri = WebUtils.getResultIterator((ResultIterator)ri, (String)"text/x-css");
            if (cssri != null && (result = (CssParserResult)cssri.getParserResult()).root() != null) {
                CssElementContext.Editor context = new CssElementContext.Editor(result, topLevelSnapshot, this.caretOffset, this.selectionStart, this.selectionEnd);
                this.ui = ((CssElementContext)context).isRefactoringAllowed() ? this.createRefactoringUI(context) : null;
            }
        }

        @Override
        public final void run() {
            try {
                Source source = Source.create((Document)this.document);
                ParserManager.parse(Collections.singleton(source), (UserTask)this);
            }
            catch (ParseException e) {
                LOG.log(Level.WARNING, null, e);
                return;
            }
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)activetc);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(CssActionsImplementationProvider.class, (String)"ERR_CannotRefactorLoc"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(CssElementContext var1);
    }

    public static abstract class NodeToFileTask
    extends UserTask
    implements Runnable {
        private final Node node;
        private CssElementContext context;
        private FileObject fileObject;

        public NodeToFileTask(Node node) {
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ResultIterator resultIterator) throws Exception {
            ArrayList<CssParserResult> results = new ArrayList<CssParserResult>();
            Snapshot snapshot = resultIterator.getSnapshot();
            try {
                if ("text/x-css".equals(snapshot.getMimeType())) {
                    results.add((CssParserResult)resultIterator.getParserResult());
                    return;
                }
                for (Embedding e : resultIterator.getEmbeddings()) {
                    this.run(resultIterator.getResultIterator(e));
                }
            }
            finally {
                this.context = new CssElementContext.File(this.fileObject, results);
            }
        }

        @Override
        public void run() {
            DataObject dobj = (DataObject)this.node.getLookup().lookup(DataObject.class);
            if (dobj != null) {
                this.fileObject = dobj.getPrimaryFile();
                if (this.fileObject.isFolder()) {
                    UI.openRefactoringUI((RefactoringUI)this.createRefactoringUI(new CssElementContext.Folder(this.fileObject)));
                } else {
                    Source source = Source.create((FileObject)this.fileObject);
                    try {
                        ParserManager.parse(Collections.singletonList(source), (UserTask)this);
                        UI.openRefactoringUI((RefactoringUI)this.createRefactoringUI(this.context));
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }

        protected abstract RefactoringUI createRefactoringUI(CssElementContext var1);
    }
}

