/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.parser;

import org.netbeans.modules.css.parser.CssParser;
import org.netbeans.modules.css.parser.CssParserConstants;
import org.netbeans.modules.css.parser.CssParserTreeConstants;
import org.netbeans.modules.css.parser.Node;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Object value;
    protected CssParser parser;
    protected Token firstToken;
    protected Token lastToken;
    private String image;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(CssParser p, int i) {
        this(i);
        this.parser = p;
    }

    public int kind() {
        return this.id;
    }

    public int startOffset() {
        return this.jjtGetFirstToken().offset;
    }

    public int endOffset() {
        if (this.jjtGetLastToken().image == null) {
            System.err.println("ERROR: lastToken image is null! : " + this.jjtGetLastToken());
            return this.jjtGetLastToken().offset;
        }
        if (this.jjtGetLastToken().kind == 0) {
            return this.jjtGetLastToken().offset + 1;
        }
        return this.jjtGetLastToken().offset + this.jjtGetLastToken().image.length();
    }

    public String image() {
        return this.image(false, new int[0]);
    }

    public String image(int ... filteredTokenKinds) {
        return this.image(false, filteredTokenKinds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String image(boolean debug, int ... filteredTokenKinds) {
        boolean[] filtered = new boolean[CssParserConstants.tokenImage.length];
        for (int i = 0; i < filteredTokenKinds.length; ++i) {
            int kind = filteredTokenKinds[i];
            filtered[kind] = true;
        }
        SimpleNode simpleNode = this;
        synchronized (simpleNode) {
            String retVal = this.image;
            if (retVal == null || debug) {
                retVal = "";
                StringBuffer sb = new StringBuffer();
                if (this.jjtGetFirstToken() == this.jjtGetLastToken()) {
                    if (!filtered[this.jjtGetFirstToken().kind]) {
                        retVal = this.jjtGetFirstToken().image;
                    }
                } else {
                    Token t = this.jjtGetFirstToken();
                    Token last = this.jjtGetLastToken();
                    while (t != null && t.offset <= last.offset) {
                        if (debug) {
                            sb.append("<");
                            sb.append(t.offset);
                            sb.append(",");
                        }
                        if (!filtered[t.kind]) {
                            sb.append(t.image);
                        } else if (debug) {
                            sb.append("filtered node:");
                            sb.append(t.image);
                        }
                        if (debug) {
                            sb.append(">");
                        }
                        t = t.next;
                    }
                    retVal = sb.toString();
                }
            }
            if (debug) {
                return retVal;
            }
            this.image = retVal;
            return this.image;
        }
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object value) {
        this.value = value;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    public Token jjtGetFirstToken() {
        return this.firstToken;
    }

    public void jjtSetFirstToken(Token token) {
        this.firstToken = token;
    }

    public Token jjtGetLastToken() {
        return this.lastToken;
    }

    public void jjtSetLastToken(Token token) {
        this.lastToken = token;
    }

    private String toString(boolean addImage) {
        return CssParserTreeConstants.jjtNodeName[this.id] + " [" + this.startOffset() + " - " + this.endOffset() + "]" + (addImage ? " '" + this.image(true, new int[0]) + "'" : "");
    }

    public String toString() {
        return this.toString(true);
    }

    private String toString(String prefix, boolean addTokenImage) {
        return prefix + this.toString(addTokenImage);
    }

    public String dump() {
        return this.dump("");
    }

    private String dump(String prefix) {
        StringBuilder str = new StringBuilder();
        str.append(this.toString(prefix, this.children == null || this.children.length == 0));
        str.append('\n');
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                str.append(n.dump(prefix + " "));
            }
        }
        return str.toString();
    }

    public void visitChildren(NodeVisitor visitor) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                visitor.visit(n);
                n.visitChildren(visitor);
            }
        }
    }
}

