/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.validation.constraints;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.j2ee.sun.validation.constraints.Constraint;
import org.netbeans.modules.j2ee.sun.validation.constraints.ConstraintFailure;
import org.netbeans.modules.j2ee.sun.validation.constraints.ConstraintUtils;
import org.netbeans.modules.j2ee.sun.validation.util.BundleReader;

public class IntegerGreaterThanConstraint
extends ConstraintUtils
implements Constraint {
    private int value = -1;

    public IntegerGreaterThanConstraint() {
        this.value = -1;
    }

    public IntegerGreaterThanConstraint(String inputValue) {
        try {
            this.value = Integer.parseInt(inputValue);
        }
        catch (NumberFormatException e) {
            String format = BundleReader.getValue("Error_failed_to_create");
            Object[] arguments = new Object[]{"IntegerGreaterThanConstraint"};
            System.out.println(MessageFormat.format(format, arguments));
        }
    }

    @Override
    public Collection match(String inputValue, String name) {
        ArrayList failed_constrained_list = new ArrayList();
        if (inputValue != null && inputValue.length() != 0) {
            try {
                int intValue = Integer.parseInt(inputValue);
                if (intValue <= this.value || intValue > Integer.MAX_VALUE) {
                    this.addFailure(failed_constrained_list, name, inputValue);
                }
            }
            catch (NumberFormatException e) {
                this.addFailure(failed_constrained_list, name, inputValue);
            }
        }
        return failed_constrained_list;
    }

    public void setValue(String value) {
        try {
            this.value = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String format = BundleReader.getValue("Error_failed_to_set");
            Object[] arguments = new Object[]{this.toString(), "Value"};
            System.out.println(MessageFormat.format(format, arguments));
        }
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public void print() {
        super.print();
        String format = BundleReader.getValue("Name_Value_Pair_Format");
        Object[] arguments = new Object[]{"Value", String.valueOf(this.value)};
        System.out.println(MessageFormat.format(format, arguments));
    }

    private void addFailure(Collection failed_constrained_list, String name, String inputValue) {
        String failureMessage = this.formatFailureMessage(this.toString(), inputValue, name);
        String format = BundleReader.getValue("MSG_IntegerGreaterThanConstraint_Failure");
        Object[] arguments = new Object[]{String.valueOf(this.value)};
        String genericFailureMessage = MessageFormat.format(format, arguments);
        failed_constrained_list.add(new ConstraintFailure(this.toString(), inputValue, name, failureMessage, genericFailureMessage));
    }
}

