/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.hostinfo.impl;

import com.jcraft.jsch.JSchException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.JschSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.support.EnvReader;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.hostinfo.HostInfoProvider;
import org.netbeans.modules.nativeexecution.support.hostinfo.impl.HostInfoFactory;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public class UnixHostInfoProvider
implements HostInfoProvider {
    private static final String PATH_VAR = "PATH";
    private static final String PATH_TO_PREPEND = "/bin:/usr/bin";
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final File hostinfoScript;

    @Override
    public HostInfo getHostInfo(ExecutionEnvironment execEnv) throws IOException {
        Properties info;
        Map<String, String> environment;
        if (hostinfoScript == null) {
            return null;
        }
        boolean isLocal = execEnv.isLocal();
        if (isLocal && Utilities.isWindows()) {
            return null;
        }
        if (execEnv.isLocal()) {
            environment = new ProcessBuilder("").environment();
            info = this.getLocalHostInfo();
        } else {
            environment = new HashMap<String, String>();
            info = this.getRemoteHostInfo(execEnv, environment);
        }
        String path = PATH_TO_PREPEND;
        if (environment.containsKey(PATH_VAR)) {
            path = path + ":" + environment.get(PATH_VAR);
        }
        environment.put(PATH_VAR, path);
        return HostInfoFactory.newHostInfo(info, environment);
    }

    private Properties getLocalHostInfo() throws IOException {
        Properties hostInfo = new Properties();
        try {
            ProcessBuilder pb = new ProcessBuilder("/bin/sh", hostinfoScript.getAbsolutePath());
            File tmpDirFile = new File(System.getProperty("java.io.tmpdir"));
            String tmpDirBase = tmpDirFile.getCanonicalPath();
            pb.environment().put("TMPBASE", tmpDirBase);
            pb.environment().put("NB_KEY", HostInfoFactory.getNBKey());
            Process hostinfoProcess = pb.start();
            List<String> errorLines = ProcessUtils.readProcessError(hostinfoProcess);
            int result = hostinfoProcess.waitFor();
            if (result != 0) {
                log.log(Level.INFO, "stderr:", errorLines.toArray(new String[0]));
                throw new IOException(hostinfoScript + " rc == " + result);
            }
            hostInfo.load(hostinfoProcess.getInputStream());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException("HostInfo receiving for localhost interrupted " + ex);
        }
        return hostInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Properties getRemoteHostInfo(ExecutionEnvironment execEnv, Map<String, String> environmentToFill) throws IOException {
        ConnectionManager cm = ConnectionManager.getInstance();
        if (!cm.isConnectedTo(execEnv)) {
            ConnectionManagerAccessor access = ConnectionManagerAccessor.getDefault();
            access.doConnect(execEnv, false);
        }
        Properties hostInfo = new Properties();
        JschSupport.ChannelStreams sh_channels = null;
        try {
            sh_channels = JschSupport.startCommand(execEnv, "/bin/sh -s", null);
            long localStartTime = System.currentTimeMillis();
            OutputStream out = sh_channels.in;
            InputStream in = sh_channels.out;
            out.write(("NB_KEY=" + HostInfoFactory.getNBKey() + '\n').getBytes());
            out.flush();
            BufferedReader scriptReader = new BufferedReader(new FileReader(hostinfoScript));
            String scriptLine = scriptReader.readLine();
            while (scriptLine != null) {
                out.write((scriptLine + '\n').getBytes());
                out.flush();
                scriptLine = scriptReader.readLine();
            }
            scriptReader.close();
            hostInfo.load(in);
            long localEndTime = System.currentTimeMillis();
            hostInfo.put("LOCALTIME", (Object)((localStartTime + localEndTime) / 2L));
        }
        catch (JSchException ex) {
            throw new IOException("Exception while receiving HostInfo for " + ((Object)execEnv).toString() + ": " + (Object)((Object)ex));
        }
        finally {
            if (sh_channels != null && sh_channels.channel != null) {
                sh_channels.channel.disconnect();
            }
        }
        JschSupport.ChannelStreams login_shell_channels = null;
        try {
            login_shell_channels = JschSupport.startLoginShellSession(execEnv);
            login_shell_channels.in.write("/usr/bin/env || /bin/env\n".getBytes());
            login_shell_channels.in.flush();
            login_shell_channels.in.close();
            EnvReader reader = new EnvReader(login_shell_channels.out, true);
            environmentToFill.putAll((Map<String, String>)reader.call());
        }
        catch (Exception ex) {
        }
        finally {
            if (login_shell_channels != null && login_shell_channels.channel != null) {
                login_shell_channels.channel.disconnect();
            }
        }
        return hostInfo;
    }

    static {
        InstalledFileLocator fl = InstalledFileLocatorProvider.getDefault();
        hostinfoScript = fl.locate("bin/nativeexecution/hostinfo.sh", null, false);
        if (hostinfoScript == null) {
            log.severe("Unable to find hostinfo.sh script!");
        }
    }
}

