/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.converter.wizard.Converter;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItem;

public class ConverterUtil {
    static Boolean getBoolean(String string) {
        if (string == null) {
            return null;
        }
        string = ConverterUtil.decryptStringFromJavaCode(string);
        return "true".equalsIgnoreCase(string);
    }

    static Character getChar(String string) {
        return (string = ConverterUtil.decryptStringFromJavaCode(string)).length() > 0 ? Character.valueOf(string.charAt(0)) : null;
    }

    static Byte getByte(String string) {
        if (string == null) {
            return null;
        }
        string = ConverterUtil.decryptStringFromJavaCode(string);
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.warning((Object[])new Object[]{numberFormatException});
            return null;
        }
    }

    static Short getShort(String string) {
        if (string == null) {
            return null;
        }
        string = ConverterUtil.decryptStringFromJavaCode(string);
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.warning((Object[])new Object[]{numberFormatException});
            return null;
        }
    }

    static Integer getInteger(String string) {
        if (string == null) {
            return null;
        }
        string = ConverterUtil.decryptStringFromJavaCode(string);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.warning((Object[])new Object[]{numberFormatException});
            return null;
        }
    }

    static Long getLong(String string) {
        if (string == null) {
            return null;
        }
        string = ConverterUtil.decryptStringFromJavaCode(string);
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.warning((Object[])new Object[]{numberFormatException});
            return null;
        }
    }

    static Float getFloat(String string) {
        if (string == null) {
            return null;
        }
        string = ConverterUtil.decryptStringFromJavaCode(string);
        try {
            return Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            Debug.warning((Object[])new Object[]{numberFormatException});
            return null;
        }
    }

    static Double getDouble(String string) {
        if (string == null) {
            return null;
        }
        string = ConverterUtil.decryptStringFromJavaCode(string);
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.warning((Object[])new Object[]{numberFormatException});
            return null;
        }
    }

    static PropertyValue getStringWithUserCode(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("CODE:")) {
            return PropertyValue.createUserCode((String)ConverterUtil.decryptStringFromJavaCode(string.substring(5)));
        }
        if (string.startsWith("STRING:")) {
            return MidpTypes.createStringValue((String)ConverterUtil.decryptStringFromJavaCode(string.substring(7)));
        }
        Debug.warning((Object[])new Object[]{"Invalid string code value", string});
        return null;
    }

    public static String decryptStringFromJavaCode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        block11: while (n2 < n) {
            char c = string.charAt(n2);
            ++n2;
            if (c != '\\') {
                stringBuffer.append(c);
                continue;
            }
            c = string.charAt(n2);
            ++n2;
            switch (c) {
                case 'r': {
                    stringBuffer.append('\r');
                    continue block11;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    continue block11;
                }
                case 't': {
                    stringBuffer.append('\t');
                    continue block11;
                }
                case 'u': {
                    if (n2 + 4 > n) {
                        Debug.warning((Object[])new Object[]{"Invalid hex number at the end", string.substring(n2)});
                        continue block11;
                    }
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n2, n2 + 4), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        Debug.warning((Object[])new Object[]{"Invalid hex number format", string.substring(n2, n2 + 4)});
                    }
                    n2 += 4;
                    continue block11;
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    stringBuffer.append(c);
                    continue block11;
                }
            }
            if (c < '0' || c > '9') {
                Debug.warning((Object[])new Object[]{"Invalid character after slash", Character.valueOf(c)});
                continue;
            }
            if (--n2 + 3 > n) {
                Debug.warning((Object[])new Object[]{"Invalid octal number at the end: ", string.substring(n2)});
                continue;
            }
            try {
                stringBuffer.append((char)Integer.parseInt(string.substring(n2, n2 + 3), 8));
            }
            catch (NumberFormatException numberFormatException) {
                Debug.warning((Object[])new Object[]{"Invalid octal number format", string.substring(n2, n2 + 3)});
            }
            n2 += 3;
        }
        return stringBuffer.toString();
    }

    static PropertyValue decryptStringArrayArray(String string, TypeID typeID, int n) {
        char c;
        if (string == null) {
            return PropertyValue.createNull();
        }
        if (n <= 0) {
            return MidpTypes.createStringValue((String)string);
        }
        typeID = typeID.getComponentType();
        int n2 = 0;
        int n3 = 0;
        while (Character.isDigit(c = ConverterUtil.lookCharAhead(string, n2++))) {
            n3 = n3 * 10 + (c - 48);
        }
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        for (int i = 0; i < n3; ++i) {
            String string2 = null;
            if (Character.isDigit(ConverterUtil.lookCharAhead(string, n2))) {
                char c2;
                int n4 = 0;
                while (Character.isDigit(c2 = ConverterUtil.lookCharAhead(string, n2++))) {
                    n4 = n4 * 10 + (c2 - 48);
                }
                string2 = string.substring(n2, n2 + n4);
                n2 += n4 + 1;
            } else {
                ++n2;
            }
            arrayList.add(ConverterUtil.decryptStringArrayArray(string2, typeID, n - 1));
        }
        return PropertyValue.createArray((TypeID)typeID, arrayList);
    }

    private static char lookCharAhead(String string, int n) {
        return n < string.length() ? string.charAt(n) : (char)'\u0000';
    }

    static void convertStringWithUserCode(DesignComponent designComponent, String string, String string2) {
        PropertyValue propertyValue = ConverterUtil.getStringWithUserCode(string2);
        if (propertyValue != null) {
            designComponent.writeProperty(string, propertyValue);
        }
    }

    static void convertByte(DesignComponent designComponent, String string, String string2) {
        Byte by = ConverterUtil.getByte(string2);
        if (by != null) {
            designComponent.writeProperty(string, MidpTypes.createByteValue((byte)by));
        }
    }

    static void convertShort(DesignComponent designComponent, String string, String string2) {
        Short s = ConverterUtil.getShort(string2);
        if (s != null) {
            designComponent.writeProperty(string, MidpTypes.createShortValue((short)s));
        }
    }

    static void convertInteger(DesignComponent designComponent, String string, String string2) {
        Integer n = ConverterUtil.getInteger(string2);
        if (n != null) {
            designComponent.writeProperty(string, MidpTypes.createIntegerValue((int)n));
        }
    }

    static void convertLong(DesignComponent designComponent, String string, String string2) {
        Long l = ConverterUtil.getLong(string2);
        if (l != null) {
            designComponent.writeProperty(string, MidpTypes.createLongValue((long)l));
        }
    }

    static void convertFloat(DesignComponent designComponent, String string, String string2) {
        Float f = ConverterUtil.getFloat(string2);
        if (f != null) {
            designComponent.writeProperty(string, MidpTypes.createFloatValue((float)f.floatValue()));
        }
    }

    static void convertDouble(DesignComponent designComponent, String string, String string2) {
        Double d = ConverterUtil.getDouble(string2);
        if (d != null) {
            designComponent.writeProperty(string, MidpTypes.createDoubleValue((double)d));
        }
    }

    static void convertChar(DesignComponent designComponent, String string, String string2) {
        Character c = ConverterUtil.getChar(string2);
        if (c != null) {
            designComponent.writeProperty(string, MidpTypes.createCharValue((char)c.charValue()));
        }
    }

    static void convertString(DesignComponent designComponent, String string, String string2) {
        if ((string2 = ConverterUtil.decryptStringFromJavaCode(string2)) != null) {
            designComponent.writeProperty(string, MidpTypes.createStringValue((String)string2));
        }
    }

    static void convertBoolean(DesignComponent designComponent, String string, String string2) {
        Boolean bl = ConverterUtil.getBoolean(string2);
        if (bl != null) {
            designComponent.writeProperty(string, MidpTypes.createBooleanValue((boolean)bl));
        }
    }

    static void convertConverterItemComponent(DesignComponent designComponent, String string, HashMap<String, ConverterItem> hashMap, String string2) {
        DesignComponent designComponent2 = Converter.convertConverterItemComponent(hashMap, string2, designComponent.getDocument());
        if (designComponent2 != null) {
            designComponent.writeProperty(string, PropertyValue.createComponentReference((DesignComponent)designComponent2));
        }
    }

    static void convertToPropertyValue(DesignComponent designComponent, String string, TypeID typeID, String string2) {
        if (MidpTypes.TYPEID_BOOLEAN.equals((Object)typeID)) {
            ConverterUtil.convertBoolean(designComponent, string, string2);
        } else if (MidpTypes.TYPEID_BYTE.equals((Object)typeID)) {
            ConverterUtil.convertByte(designComponent, string, string2);
        } else if (MidpTypes.TYPEID_CHAR.equals((Object)typeID)) {
            designComponent.writeProperty(string, MidpTypes.createCharValue((char)string2.charAt(0)));
        } else if (MidpTypes.TYPEID_DOUBLE.equals((Object)typeID)) {
            ConverterUtil.convertDouble(designComponent, string, string2);
        } else if (MidpTypes.TYPEID_FLOAT.equals((Object)typeID)) {
            ConverterUtil.convertFloat(designComponent, string, string2);
        } else if (MidpTypes.TYPEID_INT.equals((Object)typeID)) {
            ConverterUtil.convertInteger(designComponent, string, string2);
        } else if (MidpTypes.TYPEID_JAVA_CODE.equals((Object)typeID)) {
            if (string2 != null) {
                designComponent.writeProperty(string, MidpTypes.createJavaCodeValue((String)string2));
            }
        } else if (MidpTypes.TYPEID_JAVA_LANG_STRING.equals((Object)typeID)) {
            ConverterUtil.convertString(designComponent, string, string2);
        } else if (MidpTypes.TYPEID_JAVA_LANG_STRING.equals((Object)typeID)) {
            ConverterUtil.convertString(designComponent, string, string2);
        } else if (MidpTypes.TYPEID_LONG.equals((Object)typeID)) {
            ConverterUtil.convertLong(designComponent, string, string2);
        } else if (MidpTypes.TYPEID_SHORT.equals((Object)typeID)) {
            ConverterUtil.convertShort(designComponent, string, string2);
        }
    }
}

