/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.AdjustmentListener;
import java.util.Hashtable;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JScrollBar;
import javax.swing.plaf.ScrollBarUI;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JScrollBarOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String MINIMUM_DPROP = "Minimum";
    public static final String MAXIMUM_DPROP = "Maximum";
    public static final String VALUE_DPROP = "Value";
    public static final String ORIENTATION_DPROP = "Orientation";
    public static final String HORIZONTAL_ORIENTATION_DPROP_VALUE = "HORIZONTAL";
    public static final String VERTICAL_ORIENTATION_DPROP_VALUE = "VERTICAL";
    private static final long ONE_SCROLL_CLICK_TIMEOUT = 0L;
    private static final long WHOLE_SCROLL_TIMEOUT = 60000L;
    private static final long BEFORE_DROP_TIMEOUT = 0L;
    private static final long DRAG_AND_DROP_SCROLLING_DELTA = 0L;
    private static final int MINIMAL_PAD_SIZE = 10;
    private static final int MINIMAL_DRAGGER_SIZE = 5;
    private Timeouts timeouts;
    private TestOut output;
    private JButtonOperator minButtOperator;
    private JButtonOperator maxButtOperator;
    private ScrollDriver driver = DriverManager.getScrollDriver(this.getClass());

    public JScrollBarOperator(JScrollBar b) {
        super(b);
    }

    public JScrollBarOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JScrollBar)cont.waitSubComponent(new JScrollBarFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JScrollBarOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JScrollBarOperator(ContainerOperator cont, int index) {
        this((JScrollBar)JScrollBarOperator.waitComponent(cont, (ComponentChooser)new JScrollBarFinder(), index));
        this.copyEnvironment(cont);
    }

    public JScrollBarOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JScrollBar findJScrollBar(Container cont, ComponentChooser chooser, int index) {
        return (JScrollBar)JScrollBarOperator.findComponent(cont, new JScrollBarFinder(chooser), index);
    }

    public static JScrollBar findJScrollBar(Container cont, ComponentChooser chooser) {
        return JScrollBarOperator.findJScrollBar(cont, chooser, 0);
    }

    public static JScrollBar findJScrollBar(Container cont, int index) {
        return JScrollBarOperator.findJScrollBar(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th JScrollBar instance"), index);
    }

    public static JScrollBar findJScrollBar(Container cont) {
        return JScrollBarOperator.findJScrollBar(cont, 0);
    }

    public static JScrollBar waitJScrollBar(Container cont, ComponentChooser chooser, int index) {
        return (JScrollBar)JScrollBarOperator.waitComponent(cont, (ComponentChooser)new JScrollBarFinder(chooser), index);
    }

    public static JScrollBar waitJScrollBar(Container cont, ComponentChooser chooser) {
        return JScrollBarOperator.waitJScrollBar(cont, chooser, 0);
    }

    public static JScrollBar waitJScrollBar(Container cont, int index) {
        return JScrollBarOperator.waitJScrollBar(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th JScrollBar instance"), index);
    }

    public static JScrollBar waitJScrollBar(Container cont) {
        return JScrollBarOperator.waitJScrollBar(cont, 0);
    }

    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        super.setTimeouts(timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (ScrollDriver)DriverManager.getDriver("drivers.scroll", this.getClass(), anotherOperator.getProperties());
    }

    public void scroll(boolean increase) {
        this.scrollToValue(this.getValue() + (increase ? 1 : -1));
    }

    public void scrollTo(Waitable w, Object waiterParam, boolean increase) {
        this.scrollTo(new WaitableChecker(w, waiterParam, increase, this));
    }

    public void scrollTo(ScrollChecker checker) {
        this.scrollTo(new CheckerAdjustable(checker, this));
    }

    public void scrollTo(final ScrollAdjuster adj) {
        this.initOperators();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                JScrollBarOperator.this.driver.scroll(JScrollBarOperator.this, adj);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JScrollBarOperator.WholeScrollTimeout"));
    }

    public void scrollToValue(int value) {
        this.output.printTrace("Scroll JScrollBar to " + Integer.toString(value) + " value\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollBar to " + Integer.toString(value) + " value");
        this.scrollTo(new ValueScrollAdjuster(value));
    }

    public void scrollToValue(double proportionalValue) {
        this.output.printTrace("Scroll JScrollBar to " + Double.toString(proportionalValue) + " proportional value\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollBar to " + Double.toString(proportionalValue) + " proportional value");
        this.scrollTo(new ValueScrollAdjuster((int)((double)this.getMinimum() + (double)(this.getMaximum() - this.getVisibleAmount() - this.getMinimum()) * proportionalValue)));
    }

    public void scrollToMinimum() {
        this.output.printTrace("Scroll JScrollBar to minimum value\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollBar to minimum value");
        this.initOperators();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                JScrollBarOperator.this.driver.scrollToMinimum(JScrollBarOperator.this, JScrollBarOperator.this.getOrientation());
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JScrollBarOperator.WholeScrollTimeout"));
    }

    public void scrollToMaximum() {
        this.output.printTrace("Scroll JScrollBar to maximum value\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollBar to maximum value");
        this.initOperators();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                JScrollBarOperator.this.driver.scrollToMaximum(JScrollBarOperator.this, JScrollBarOperator.this.getOrientation());
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JScrollBarOperator.WholeScrollTimeout"));
    }

    public JButtonOperator getDecreaseButton() {
        this.initOperators();
        return this.minButtOperator;
    }

    public JButtonOperator getIncreaseButton() {
        this.initOperators();
        return this.maxButtOperator;
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        result.put(MINIMUM_DPROP, Integer.toString(((JScrollBar)this.getSource()).getMinimum()));
        result.put(MAXIMUM_DPROP, Integer.toString(((JScrollBar)this.getSource()).getMaximum()));
        result.put(ORIENTATION_DPROP, ((JScrollBar)this.getSource()).getOrientation() == 0 ? HORIZONTAL_ORIENTATION_DPROP_VALUE : VERTICAL_ORIENTATION_DPROP_VALUE);
        result.put(VALUE_DPROP, Integer.toString(((JScrollBar)this.getSource()).getValue()));
        return result;
    }

    public void addAdjustmentListener(final AdjustmentListener adjustmentListener) {
        this.runMapping(new Operator.MapVoidAction("addAdjustmentListener"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).addAdjustmentListener(adjustmentListener);
            }
        });
    }

    public int getBlockIncrement() {
        return this.runMapping(new Operator.MapIntegerAction("getBlockIncrement"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getBlockIncrement();
            }
        });
    }

    public int getBlockIncrement(final int i) {
        return this.runMapping(new Operator.MapIntegerAction("getBlockIncrement"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getBlockIncrement(i);
            }
        });
    }

    public int getMaximum() {
        return this.runMapping(new Operator.MapIntegerAction("getMaximum"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getMaximum();
            }
        });
    }

    public int getMinimum() {
        return this.runMapping(new Operator.MapIntegerAction("getMinimum"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getMinimum();
            }
        });
    }

    public BoundedRangeModel getModel() {
        return (BoundedRangeModel)this.runMapping(new Operator.MapAction("getModel"){

            public Object map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getModel();
            }
        });
    }

    public int getOrientation() {
        return this.runMapping(new Operator.MapIntegerAction("getOrientation"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getOrientation();
            }
        });
    }

    public ScrollBarUI getUI() {
        return (ScrollBarUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getUI();
            }
        });
    }

    public int getUnitIncrement() {
        return this.runMapping(new Operator.MapIntegerAction("getUnitIncrement"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getUnitIncrement();
            }
        });
    }

    public int getUnitIncrement(final int i) {
        return this.runMapping(new Operator.MapIntegerAction("getUnitIncrement"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getUnitIncrement(i);
            }
        });
    }

    public int getValue() {
        return this.runMapping(new Operator.MapIntegerAction("getValue"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getValue();
            }
        });
    }

    public boolean getValueIsAdjusting() {
        return this.runMapping(new Operator.MapBooleanAction("getValueIsAdjusting"){

            public boolean map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getValueIsAdjusting();
            }
        });
    }

    public int getVisibleAmount() {
        return this.runMapping(new Operator.MapIntegerAction("getVisibleAmount"){

            public int map() {
                return ((JScrollBar)JScrollBarOperator.this.getSource()).getVisibleAmount();
            }
        });
    }

    public void removeAdjustmentListener(final AdjustmentListener adjustmentListener) {
        this.runMapping(new Operator.MapVoidAction("removeAdjustmentListener"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).removeAdjustmentListener(adjustmentListener);
            }
        });
    }

    public void setBlockIncrement(final int i) {
        this.runMapping(new Operator.MapVoidAction("setBlockIncrement"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setBlockIncrement(i);
            }
        });
    }

    public void setMaximum(final int i) {
        this.runMapping(new Operator.MapVoidAction("setMaximum"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setMaximum(i);
            }
        });
    }

    public void setMinimum(final int i) {
        this.runMapping(new Operator.MapVoidAction("setMinimum"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setMinimum(i);
            }
        });
    }

    public void setModel(final BoundedRangeModel boundedRangeModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setModel(boundedRangeModel);
            }
        });
    }

    public void setOrientation(final int i) {
        this.runMapping(new Operator.MapVoidAction("setOrientation"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setOrientation(i);
            }
        });
    }

    public void setUnitIncrement(final int i) {
        this.runMapping(new Operator.MapVoidAction("setUnitIncrement"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setUnitIncrement(i);
            }
        });
    }

    public void setValue(final int i) {
        this.runMapping(new Operator.MapVoidAction("setValue"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setValue(i);
            }
        });
    }

    public void setValueIsAdjusting(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setValueIsAdjusting"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setValueIsAdjusting(b);
            }
        });
    }

    public void setValues(final int i, final int i1, final int i2, final int i3) {
        this.runMapping(new Operator.MapVoidAction("setValues"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setValues(i, i1, i2, i3);
            }
        });
    }

    public void setVisibleAmount(final int i) {
        this.runMapping(new Operator.MapVoidAction("setVisibleAmount"){

            public void map() {
                ((JScrollBar)JScrollBarOperator.this.getSource()).setVisibleAmount(i);
            }
        });
    }

    private void initOperators() {
        JButton maxButt;
        JButton minButt;
        if (this.minButtOperator != null && this.maxButtOperator != null) {
            return;
        }
        ComponentChooser chooser = new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp instanceof JButton;
            }

            public String getDescription() {
                return "";
            }
        };
        ComponentSearcher searcher = new ComponentSearcher((Container)this.getSource());
        searcher.setOutput(this.output.createErrorOutput());
        JButton butt0 = (JButton)searcher.findComponent(chooser, 0);
        JButton butt1 = (JButton)searcher.findComponent(chooser, 1);
        if (butt0 == null || butt1 == null) {
            this.minButtOperator = null;
            this.maxButtOperator = null;
            return;
        }
        if (((JScrollBar)this.getSource()).getOrientation() == 0) {
            if (butt0.getX() < butt1.getX()) {
                minButt = butt0;
                maxButt = butt1;
            } else {
                minButt = butt1;
                maxButt = butt0;
            }
        } else if (butt0.getY() < butt1.getY()) {
            minButt = butt0;
            maxButt = butt1;
        } else {
            minButt = butt1;
            maxButt = butt0;
        }
        this.minButtOperator = new JButtonOperator(minButt);
        this.maxButtOperator = new JButtonOperator(maxButt);
        this.minButtOperator.copyEnvironment(this);
        this.maxButtOperator.copyEnvironment(this);
        this.minButtOperator.setOutput(this.output.createErrorOutput());
        this.maxButtOperator.setOutput(this.output.createErrorOutput());
        Timeouts times = this.timeouts.cloneThis();
        times.setTimeout("AbstractButtonOperator.PushButtonTimeout", times.getTimeout("JScrollBarOperator.OneScrollClickTimeout"));
        this.minButtOperator.setTimeouts(times);
        this.maxButtOperator.setTimeouts(times);
        this.minButtOperator.setVisualizer(new EmptyVisualizer());
        this.maxButtOperator.setVisualizer(new EmptyVisualizer());
    }

    static {
        Timeouts.initDefault("JScrollBarOperator.OneScrollClickTimeout", 0L);
        Timeouts.initDefault("JScrollBarOperator.WholeScrollTimeout", 60000L);
        Timeouts.initDefault("JScrollBarOperator.BeforeDropTimeout", 0L);
        Timeouts.initDefault("JScrollBarOperator.DragAndDropScrollingDelta", 0L);
    }

    public static class JScrollBarFinder
    extends Operator.Finder {
        public JScrollBarFinder(ComponentChooser sf) {
            super(JScrollBar.class, sf);
        }

        public JScrollBarFinder() {
            super(JScrollBar.class);
        }
    }

    private class CheckerAdjustable
    implements ScrollAdjuster {
        ScrollChecker checker;
        JScrollBarOperator oper;

        public CheckerAdjustable(ScrollChecker checker, JScrollBarOperator oper) {
            this.checker = checker;
            this.oper = oper;
        }

        public int getScrollDirection() {
            return this.checker.getScrollDirection(this.oper);
        }

        public int getScrollOrientation() {
            return JScrollBarOperator.this.getOrientation();
        }

        public String getDescription() {
            return this.checker.getDescription();
        }
    }

    private class WaitableChecker
    implements ScrollAdjuster {
        Waitable w;
        Object waitParam;
        boolean increase;
        boolean reached = false;
        JScrollBarOperator oper;

        public WaitableChecker(Waitable w, Object waitParam, boolean increase, JScrollBarOperator oper) {
            this.w = w;
            this.waitParam = waitParam;
            this.increase = increase;
            this.oper = oper;
        }

        public int getScrollDirection() {
            if (!this.reached && this.w.actionProduced(this.waitParam) != null) {
                this.reached = true;
            }
            if (this.reached) {
                return 0;
            }
            return this.increase ? 1 : -1;
        }

        public int getScrollOrientation() {
            return JScrollBarOperator.this.getOrientation();
        }

        public String getDescription() {
            return this.w.getDescription();
        }
    }

    private class ValueScrollAdjuster
    implements ScrollAdjuster {
        int value;

        public ValueScrollAdjuster(int value) {
            this.value = value;
        }

        public int getScrollDirection() {
            if (JScrollBarOperator.this.getValue() == this.value) {
                return 0;
            }
            return JScrollBarOperator.this.getValue() < this.value ? 1 : -1;
        }

        public int getScrollOrientation() {
            return JScrollBarOperator.this.getOrientation();
        }

        public String getDescription() {
            return "Scroll to " + Integer.toString(this.value) + " value";
        }
    }

    public static interface ScrollChecker {
        public int getScrollDirection(JScrollBarOperator var1);

        public String getDescription();
    }
}

