/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.semantic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.EditHistory;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.gsfret.editor.semantic.ColoringManager;
import org.netbeans.modules.gsfret.editor.semantic.GsfSemanticLayer;
import org.netbeans.modules.gsfret.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.gsfret.editor.semantic.SequenceElement;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class SemanticHighlighter
extends ScanningCancellableTask<CompilationInfo> {
    private FileObject file;

    SemanticHighlighter(FileObject file) {
        this.file = file;
    }

    public Document getDocument() {
        return DataLoadersBridge.getDefault().getDocument(this.file);
    }

    @Override
    public void run(CompilationInfo info) {
        this.resume();
        Document doc = this.getDocument();
        if (doc == null) {
            Logger.global.log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        this.process(info, doc);
    }

    boolean process(CompilationInfo info, Document doc) {
        final TreeSet<SequenceElement> newColoring = new TreeSet<SequenceElement>();
        if (this.isCancelled() || info.hasInvalidResults()) {
            return true;
        }
        long start = System.currentTimeMillis();
        Set<String> mimeTypes = info.getEmbeddedMimeTypes();
        EditHistory currentHistory = info.getHistory();
        final int version = currentHistory.getVersion();
        LanguageRegistry registry = LanguageRegistry.getInstance();
        final GsfSemanticLayer layer = GsfSemanticLayer.getLayer(SemanticHighlighter.class, doc);
        SortedSet<SequenceElement> colorings = layer.getColorings();
        int previousVersion = layer.getVersion();
        if (mimeTypes.size() > 1 && info.hasUnchangedResults() && colorings.size() > 0) {
            HashMap elements = new HashMap();
            ArrayList<SequenceElement> prevList = null;
            Language prevLanguage = null;
            for (SequenceElement element : colorings) {
                List<SequenceElement> list;
                if (element.language == prevLanguage) {
                    list = prevList;
                } else {
                    list = (List)elements.get(element.language);
                    if (list == null) {
                        list = new ArrayList<SequenceElement>();
                        elements.put(element.language, list);
                        prevLanguage = element.language;
                        prevList = list;
                    }
                }
                list.add(element);
            }
            EditHistory history = EditHistory.getCombinedEdits((int)previousVersion, (EditHistory)currentHistory);
            if (history != null) {
                int offset = history.getStart();
                for (String mimeType : mimeTypes) {
                    if (this.isCancelled()) {
                        return true;
                    }
                    Language language = registry.getLanguageByMimeType(mimeType);
                    if (language == null) continue;
                    ParserResult result = info.getEmbeddedResult(mimeType, 0);
                    if (result != null && result.getUpdateState().isUnchanged()) {
                        List list = (List)elements.get(language);
                        if (list == null) continue;
                        for (SequenceElement element : list) {
                            if (element.language != language) continue;
                            OffsetRange range = element.range;
                            if (range.getStart() > offset) {
                                element.range = new OffsetRange(history.convertOriginalToEdited(range.getStart()), history.convertOriginalToEdited(range.getEnd()));
                            }
                            newColoring.add(element);
                        }
                        continue;
                    }
                    ColoringManager manager = language.getColoringManager();
                    SemanticAnalyzer task = language.getSemanticAnalyzer();
                    if (task == null) continue;
                    try {
                        task.run((Object)info);
                    }
                    catch (Exception ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                    if (this.isCancelled()) {
                        task.cancel();
                        return true;
                    }
                    Map highlights = task.getHighlights();
                    if (highlights == null) continue;
                    for (OffsetRange range : highlights.keySet()) {
                        Set colors = (Set)highlights.get(range);
                        if (colors == null) continue;
                        ColoringAttributes.Coloring c = manager.getColoring(colors);
                        newColoring.add(new SequenceElement(language, range, c));
                    }
                }
                layer.setColorings(newColoring, version);
                return true;
            }
        }
        for (String mimeType : mimeTypes) {
            if (this.isCancelled()) {
                return true;
            }
            long startTime = System.currentTimeMillis();
            Language language = registry.getLanguageByMimeType(mimeType);
            if (language == null) continue;
            ColoringManager manager = language.getColoringManager();
            SemanticAnalyzer task = language.getSemanticAnalyzer();
            if (task != null) {
                try {
                    task.run((Object)info);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                if (this.isCancelled()) {
                    task.cancel();
                    return true;
                }
                Map highlights = task.getHighlights();
                if (highlights != null) {
                    for (OffsetRange range : highlights.keySet()) {
                        Set colors = (Set)highlights.get(range);
                        if (colors == null) continue;
                        ColoringAttributes.Coloring c = manager.getColoring(colors);
                        newColoring.add(new SequenceElement(language, range, c));
                    }
                }
            }
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Semantic (" + mimeType + ")", new Object[]{info.getFileObject(), endTime - startTime});
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                layer.setColorings(newColoring, version);
            }
        });
        return false;
    }
}

