/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import org.netbeans.microedition.svg.SVGAbstractButton;
import org.netbeans.microedition.svg.SVGForm;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;

public class SVGRadioButton
extends SVGAbstractButton {
    private static final String DOT = "dot";
    private static final String DOT_SUFFIX = "_dot";
    private SVGLocatableElement myDotElement;
    private boolean isSelected;

    public SVGRadioButton(SVGForm form, String elemId) {
        super(form, elemId);
        this.initNestedElements();
        this.updateTrait();
    }

    private void initNestedElements() {
        if (this.getElement().getId() != null) {
            this.myDotElement = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + DOT_SUFFIX);
        }
        if (this.myDotElement == null) {
            this.myDotElement = (SVGLocatableElement)this.getNestedElementByMeta((SVGElement)this.getElement(), "type", DOT);
        }
    }

    public void setSelected(boolean selected) {
        if (this.isSelected != selected) {
            this.isSelected = selected;
            this.updateTrait();
            this.fireActionPerformed();
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void pressButton() {
        if (!this.isSelected) {
            this.form.activate(this);
            this.setSelected(true);
        }
    }

    private void updateTrait() {
        this.setTraitSafely((SVGElement)this.myDotElement, "visibility", this.isSelected ? "visible" : "hidden");
    }
}

