/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.ui.components.table.CustomSortableHeaderRenderer;

public abstract class SortableTableModel
extends AbstractTableModel {
    public static final boolean SORT_ORDER_DESC = false;
    public static final boolean SORT_ORDER_ASC = true;
    private CustomSortableHeaderRenderer headerRenderer;
    private HeaderListener headerListener;
    private ImageIcon sortAscIcon = new ImageIcon(SortableTableModel.class.getResource("/org/netbeans/lib/profiler/ui/resources/sortAsc.png"));
    private ImageIcon sortDescIcon = new ImageIcon(SortableTableModel.class.getResource("/org/netbeans/lib/profiler/ui/resources/sortDesc.png"));
    private JTableHeader tableHeader;
    private int lastFocusedColumn = -1;

    public SortableTableModel() {
        this.headerListener = new HeaderListener();
        this.headerRenderer = new CustomSortableHeaderRenderer(this.sortAscIcon, this.sortDescIcon);
    }

    public void setInitialSorting(int sortingColumn, boolean sortingOrder) {
        if (this.headerRenderer != null) {
            this.headerRenderer.setSortingColumn(sortingColumn);
            this.headerRenderer.setSortingOrder(sortingOrder);
        }
    }

    public abstract boolean getInitialSorting(int var1);

    public int getSortingColumn() {
        return this.headerRenderer.getSortingColumn();
    }

    public boolean getSortingOrder() {
        return this.headerRenderer.getSortingOrder();
    }

    public void setTable(JTable table) {
        TableColumnModel tableModel = table.getColumnModel();
        int n = tableModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            tableModel.getColumn(i).setHeaderRenderer(this.headerRenderer);
        }
        if (this.tableHeader != table.getTableHeader()) {
            if (this.tableHeader != null) {
                this.tableHeader.removeMouseListener(this.headerListener);
                this.tableHeader.removeMouseMotionListener(this.headerListener);
                this.lastFocusedColumn = -1;
            }
            this.tableHeader = table.getTableHeader();
            this.tableHeader.setReorderingAllowed(false);
            this.tableHeader.addMouseListener(this.headerListener);
            this.tableHeader.addMouseMotionListener(this.headerListener);
        }
    }

    public abstract void sortByColumn(int var1, boolean var2);

    public String getColumnToolTipText(int column) {
        return null;
    }

    private class HeaderListener
    extends MouseAdapter
    implements MouseMotionListener {
        private HeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getModifiers() == 16) {
                int sortingColumn;
                int column = SortableTableModel.this.tableHeader.columnAtPoint(e.getPoint());
                if (column == (sortingColumn = SortableTableModel.this.headerRenderer.getSortingColumn())) {
                    SortableTableModel.this.headerRenderer.reverseSortingOrder();
                } else {
                    SortableTableModel.this.headerRenderer.setSortingColumn(column);
                    if (SortableTableModel.this.getInitialSorting(column)) {
                        SortableTableModel.this.headerRenderer.setSortingOrder(true);
                    } else {
                        SortableTableModel.this.headerRenderer.setSortingOrder(false);
                    }
                }
                SortableTableModel.this.tableHeader.repaint();
                SortableTableModel.this.sortByColumn(column, SortableTableModel.this.headerRenderer.getSortingOrder());
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int focusedColumn = SortableTableModel.this.tableHeader.columnAtPoint(e.getPoint());
            if (focusedColumn != SortableTableModel.this.lastFocusedColumn && focusedColumn != -1) {
                SortableTableModel.this.tableHeader.setToolTipText(SortableTableModel.this.getColumnToolTipText(focusedColumn));
                SortableTableModel.this.lastFocusedColumn = focusedColumn;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getModifiers() == 16 && SortableTableModel.this.tableHeader.getResizingColumn() == null) {
                SortableTableModel.this.headerRenderer.setPressedColumn(SortableTableModel.this.tableHeader.columnAtPoint(e.getPoint()));
                SortableTableModel.this.tableHeader.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getModifiers() == 16) {
                SortableTableModel.this.headerRenderer.setPressedColumn(-1);
                SortableTableModel.this.tableHeader.repaint();
            }
        }
    }
}

