/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.ui.PathUiSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerIgnorePath
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = 32813080125323378L;
    private final ProjectCustomizer.Category category;
    private final PhpProject project;
    private JButton addButton;
    private JLabel ignorePathLabel;
    private JList ignorePathList;
    private JScrollPane ignorePathScrollPane;
    private JButton removeButton;

    public CustomizerIgnorePath(ProjectCustomizer.Category category, PhpProjectProperties uiProps) {
        this.category = category;
        this.project = uiProps.getProject();
        this.initComponents();
        PathUiSupport.EditMediator.FileChooserDirectoryHandler directoryHandler = new PathUiSupport.EditMediator.FileChooserDirectoryHandler(){

            @Override
            public File getCurrentDirectory() {
                return FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(CustomizerIgnorePath.this.project));
            }

            @Override
            public void setCurrentDirectory(File currentDirectory) {
            }
        };
        this.ignorePathList.setModel(uiProps.getIgnorePathListModel());
        this.ignorePathList.setCellRenderer(uiProps.getIgnorePathListRenderer());
        PathUiSupport.EditMediator.register(uiProps.getProject(), this.ignorePathList, this.addButton.getModel(), this.removeButton.getModel(), directoryHandler);
        this.ignorePathList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                CustomizerIgnorePath.this.validateData();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                CustomizerIgnorePath.this.validateData();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                CustomizerIgnorePath.this.validateData();
            }
        });
    }

    void validateData() {
        int size = this.ignorePathList.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            BasePathSupport.Item item = (BasePathSupport.Item)this.ignorePathList.getModel().getElementAt(i);
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(item.getFilePath())));
            if (fo == null || CommandUtils.isUnderAnySourceGroup(this.project, fo, false)) continue;
            this.category.setErrorMessage(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"MSG_NotSourceGroupSubdirectory", (Object)fo.getNameExt()));
            this.category.setValid(false);
            return;
        }
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    private void initComponents() {
        this.ignorePathLabel = new JLabel();
        this.ignorePathScrollPane = new JScrollPane();
        this.ignorePathList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setFocusTraversalPolicy(null);
        this.ignorePathLabel.setLabelFor(this.ignorePathList);
        Mnemonics.setLocalizedText((JLabel)this.ignorePathLabel, (String)NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathLabel.text"));
        this.ignorePathScrollPane.setViewportView(this.ignorePathList);
        this.ignorePathList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathList.AccessibleContext.accessibleName"));
        this.ignorePathList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.addButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.removeButton.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ignorePathLabel).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.ignorePathScrollPane, -1, 271, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.removeButton).addComponent(this.addButton)).addGap(0, 0, 0)));
        layout.linkSize(0, this.addButton, this.removeButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.ignorePathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton)).addComponent(this.ignorePathScrollPane, -1, 143, Short.MAX_VALUE)).addGap(0, 0, 0)));
        this.ignorePathLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathLabel.AccessibleContext.accessibleName"));
        this.ignorePathLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathLabel.AccessibleContext.accessibleDescription"));
        this.ignorePathScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathScrollPane.AccessibleContext.accessibleName"));
        this.ignorePathScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathScrollPane.AccessibleContext.accessibleDescription"));
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.addButton.AccessibleContext.accessibleName"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.addButton.AccessibleContext.accessibleDescription"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.removeButton.AccessibleContext.accessibleName"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.removeButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.AccessibleContext.accessibleDescription"));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerIgnorePath.class);
    }
}

