/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.samples;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.derby.spi.support.DerbySupport;
import org.netbeans.modules.maven.samples.CRUDSampleDbPersistencePanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CRUDSampleDbPersistenceVisual
extends JPanel
implements DocumentListener {
    public static final String[] SUPPORTED_PU_LIBRARIES = new String[]{"eclipselink", "toplink"};
    public static final String JAVADB_HOME = "javadb.home";
    private final CRUDSampleDbPersistencePanel panel;
    private Map<String, Library> dn2lib = new HashMap<String, Library>();
    JButton bDerby;
    JComboBox cbLibrary;
    JLabel lDerby;
    JLabel lDerbyHint;
    JLabel lLibarary;
    JTextField tfDerby;

    public CRUDSampleDbPersistenceVisual(CRUDSampleDbPersistencePanel panel) {
        this.initComponents();
        this.panel = panel;
        this.cbLibrary.setModel(new DefaultComboBoxModel<String>(this.getLibrariesDN()));
        this.tfDerby.setText(CRUDSampleDbPersistenceVisual.getDerbyInstallation());
        this.tfDerby.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.lDerby = new JLabel();
        this.tfDerby = new JTextField();
        this.bDerby = new JButton();
        this.lDerbyHint = new JLabel();
        this.lLibarary = new JLabel();
        this.cbLibrary = new JComboBox();
        this.lDerby.setLabelFor(this.tfDerby);
        Mnemonics.setLocalizedText((JLabel)this.lDerby, (String)NbBundle.getMessage(CRUDSampleDbPersistenceVisual.class, (String)"CRUDSampleDbPersistenceVisual.lDerby.text"));
        this.tfDerby.setColumns(280);
        this.tfDerby.setText(NbBundle.getMessage(CRUDSampleDbPersistenceVisual.class, (String)"CRUDSampleDbPersistenceVisual.tfDerby.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bDerby, (String)NbBundle.getMessage(CRUDSampleDbPersistenceVisual.class, (String)"CRUDSampleDbPersistenceVisual.bDerby.text"));
        this.bDerby.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CRUDSampleDbPersistenceVisual.this.bDerbyActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lDerbyHint, (String)NbBundle.getMessage(CRUDSampleDbPersistenceVisual.class, (String)"CRUDSampleDbPersistenceVisual.lDerbyHint.text"));
        this.lLibarary.setLabelFor(this.cbLibrary);
        Mnemonics.setLocalizedText((JLabel)this.lLibarary, (String)NbBundle.getMessage(CRUDSampleDbPersistenceVisual.class, (String)"CRUDSampleDbPersistenceVisual.lLibarary.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lDerby).addComponent(this.lLibarary)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lDerbyHint).addGroup(layout.createSequentialGroup().addComponent(this.tfDerby, -1, 202, Short.MAX_VALUE).addGap(9, 9, 9).addComponent(this.bDerby)).addGroup(layout.createSequentialGroup().addComponent(this.cbLibrary, 0, 202, Short.MAX_VALUE).addGap(79, 79, 79))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lDerby).addComponent(this.tfDerby, -2, -1, -2).addComponent(this.bDerby)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lDerbyHint).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lLibarary).addComponent(this.cbLibrary, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void bDerbyActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(null);
        chooser.setDialogTitle(NbBundle.getMessage(CRUDSampleDbPersistenceVisual.class, (String)"CRUDSampleDbPersistenceVisual.select_derby_location"));
        chooser.setFileSelectionMode(1);
        String path = this.tfDerby.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            this.tfDerby.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
        }
        this.panel.fireChangeEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (!CRUDSampleDbPersistenceVisual.validateDerby(this.tfDerby.getText())) {
            if (wizardDescriptor != null) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(CRUDSampleDbPersistenceVisual.class, (String)"CRUDSampleDbPersistenceVisual.invalid_derby_location"));
            }
            return false;
        }
        if (!this.validatePersistenceLibrary()) {
            if (wizardDescriptor != null) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(CRUDSampleDbPersistenceVisual.class, (String)"CRUDSampleDbPersistenceVisual.invalid_persistence_libraries"));
            }
            return false;
        }
        if (wizardDescriptor != null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        }
        return true;
    }

    void validate(WizardDescriptor wizardDescriptor) {
    }

    private String[] getLibrariesDN() {
        ArrayList<String> res = new ArrayList<String>();
        for (String name : SUPPORTED_PU_LIBRARIES) {
            Library l = LibraryManager.getDefault().getLibrary(name);
            Logger.getLogger(CRUDSampleDbPersistenceVisual.class.getName()).log(Level.FINE, "Name {0} has library {1}", new Object[]{name, l});
            if (l == null) continue;
            res.add(l.getDisplayName());
            this.dn2lib.put(l.getDisplayName(), l);
        }
        return res.toArray(new String[0]);
    }

    private Library getLibrary(String dn) {
        assert (this.dn2lib.get(dn) != null) : "Library " + dn + " found in " + this.dn2lib;
        return this.dn2lib.get(dn);
    }

    private static String getDerbyInstallation() {
        String path;
        File f = null;
        String javaDBHome = System.getProperty(JAVADB_HOME);
        Logger.getLogger(CRUDSampleDbPersistenceVisual.class.getName()).finest("System.getProperty(\"javadb.home\") returns " + javaDBHome);
        if (javaDBHome == null) {
            String javaDBLoc = DerbySupport.getLocation();
            Logger.getLogger(CRUDSampleDbPersistenceVisual.class.getName()).finer("DerbySupport.getLocation() returns " + javaDBLoc);
            if (javaDBLoc != null && javaDBLoc.length() > 0) {
                f = new File(javaDBLoc);
            }
            if (f == null || !f.exists()) {
                String javaHome = System.getProperty("java.home");
                f = new File(javaHome + File.separator + ".." + File.separator + "db" + File.separator);
                Logger.getLogger(CRUDSampleDbPersistenceVisual.class.getName()).finer("JavaDB in JDK6 is " + f);
            }
        } else {
            f = new File(javaDBHome);
        }
        try {
            path = f != null && f.exists() ? f.getCanonicalPath() : null;
        }
        catch (IOException ex) {
            path = f != null && f.exists() ? f.getAbsolutePath() : null;
        }
        Logger.getLogger(CRUDSampleDbPersistenceVisual.class.getName()).fine("Java DB installation is " + path);
        return path;
    }

    private static boolean validateDerby(String path) {
        boolean res;
        boolean bl = res = path != null;
        if (res) {
            File dir = new File(path);
            boolean bl2 = res = dir.exists() && dir.isDirectory();
            if (res) {
                File f = new File(dir, "lib" + File.separator + "derbyclient.jar");
                res = f.exists() && f.isFile();
            }
        }
        return res;
    }

    private boolean validatePersistenceLibrary() {
        return this.getLibrariesDN().length > 0;
    }

    String getDerbyLocation() {
        assert (CRUDSampleDbPersistenceVisual.validateDerby(this.tfDerby.getText())) : "DB Location " + this.tfDerby.getText() + " must contain lib/derbyclient.jar";
        return this.tfDerby.getText();
    }

    Library getSelectedLibrary() {
        assert (this.getLibrary((String)this.cbLibrary.getSelectedItem()) != null) : "Some Persistence Library must found.";
        Logger.getLogger(CRUDSampleDbPersistenceVisual.class.getName()).log(Level.FINE, "Selected library in {0} is {1}", new Object[]{this.cbLibrary.getSelectedItem(), this.getLibrary((String)this.cbLibrary.getSelectedItem())});
        return this.getLibrary((String)this.cbLibrary.getSelectedItem());
    }
}

