/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.impl;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.impl.TimeSeriesIndicatorConfigurationFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class TimeSeriesDescriptorFactory {
    private TimeSeriesDescriptorFactory() {
    }

    static Collection<TimeSeriesDescriptor> createList(Map<?, ?> map) {
        FileObject[] descriptors;
        ArrayList<TimeSeriesDescriptor> result = new ArrayList<TimeSeriesDescriptor>();
        FileObject rootFolder = FileUtil.getConfigRoot();
        String itemsPath = (String)map.get("items");
        FileObject itemsFolder = rootFolder.getFileObject(itemsPath);
        for (FileObject fo : descriptors = itemsFolder.getChildren()) {
            TimeSeriesDescriptor descr = TimeSeriesIndicatorConfigurationFactory.createInstance(fo, TimeSeriesDescriptor.class);
            if (descr == null) continue;
            result.add(descr);
        }
        return result;
    }

    static TimeSeriesDescriptor createTimeSeriesDescriptor(Map<?, ?> map) {
        String name = TimeSeriesDescriptorFactory.getString(map, "name");
        String displayName = TimeSeriesDescriptorFactory.getString(map, "displayName");
        Color color = TimeSeriesDescriptorFactory.decodeColor(TimeSeriesDescriptorFactory.getString(map, "color"));
        TimeSeriesDescriptor.Kind kind = TimeSeriesDescriptor.Kind.valueOf(TimeSeriesDescriptorFactory.getString(map, "kind"));
        TimeSeriesDescriptor descriptor = new TimeSeriesDescriptor(name, displayName, color, kind);
        DataTableMetadata.Column column = TimeSeriesIndicatorConfigurationFactory.createInstance(TimeSeriesDescriptorFactory.getString(map, "column"), DataTableMetadata.Column.class);
        if (column != null) {
            descriptor.setSourceColumns(Collections.singleton(column));
        }
        return descriptor;
    }

    private static String getString(Map<?, ?> map, String key) {
        return (String)map.get(key);
    }

    private static Color decodeColor(String color) {
        if (color == null) {
            return null;
        }
        try {
            return Color.decode(color);
        }
        catch (NumberFormatException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        try {
            Field field = Color.class.getDeclaredField(color);
            if ((field.getModifiers() & 8) != 0 && field.getType() == Color.class) {
                return (Color)field.get(null);
            }
        }
        catch (NoSuchFieldException ex) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return Color.BLACK;
    }
}

