/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analyzer.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.AbstractAction;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.java.hints.analyzer.ui.AnalyzerTopComponent;
import org.netbeans.modules.java.hints.analyzer.ui.FixDescription;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class PreviousError
extends AbstractAction
implements PropertyChangeListener {
    private AnalyzerTopComponent comp;

    public PreviousError(AnalyzerTopComponent analyzerTopComponent) {
        this.comp = analyzerTopComponent;
        this.comp.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public boolean isEnabled() {
        boolean bl;
        Node node = this.getNextMeaningfullNode();
        boolean bl2 = bl = node != null;
        if (node != null) {
            this.comp.seenNodes.add(0, node);
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Node node = this.getNextMeaningfullNode();
        this.comp.nodesForNext.add(0, node);
        FixDescription fixDescription = (FixDescription)node.getLookup().lookup(FixDescription.class);
        assert (fixDescription != null);
        try {
            this.comp.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException propertyVetoException) {
            Exceptions.printStackTrace((Throwable)propertyVetoException);
        }
        ErrorDescription errorDescription = fixDescription.getErrors();
        UiUtils.open((FileObject)errorDescription.getFile(), (int)errorDescription.getRange().getBegin().getOffset());
        this.fireEnabledChanged();
    }

    void fireEnabledChanged() {
        this.firePropertyChange("enabled", null, this.isEnabled());
    }

    private Node getNextMeaningfullNode() {
        List<Node> list = this.comp.seenNodes;
        if (list == null || list.isEmpty()) {
            return null;
        }
        while (list != null && !list.isEmpty()) {
            Node node = this.comp.seenNodes.remove(0);
            FixDescription fixDescription = (FixDescription)node.getLookup().lookup(FixDescription.class);
            if (fixDescription == null) continue;
            Node[] nodeArray = this.comp.getExplorerManager().getSelectedNodes();
            if (nodeArray.length == 1 && nodeArray[0] == node) {
                this.comp.nodesForNext.add(0, node);
                continue;
            }
            if (this.comp.goOverFixed() && !fixDescription.isFixed()) {
                this.comp.nodesForNext.add(0, node);
                continue;
            }
            return node;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireEnabledChanged();
    }
}

