/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class StringBuilderAppend {
    public static ErrorDescription builder(HintContext hintContext) {
        return StringBuilderAppend.hint(hintContext, "StringBuilder");
    }

    public static ErrorDescription buffer(HintContext hintContext) {
        return StringBuilderAppend.hint(hintContext, "StringBuffer");
    }

    private static ErrorDescription hint(HintContext hintContext, String string) {
        CompilationInfo compilationInfo = hintContext.getInfo();
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)hintContext.getPath().getLeaf();
        ExpressionTree expressionTree = methodInvocationTree.getArguments().get(0);
        List<List<TreePath>> list = Utilities.splitStringConcatenationToElements(compilationInfo, new TreePath(hintContext.getPath(), expressionTree));
        if (list.size() > 1) {
            String string2 = NbBundle.getMessage(StringBuilderAppend.class, (String)"ERR_StringBuilderAppend", (Object)string);
            return ErrorDescriptionFactory.forTree(hintContext, expressionTree, string2, new FixImpl(compilationInfo.getSnapshot().getSource(), TreePathHandle.create((TreePath)hintContext.getPath(), (CompilationInfo)compilationInfo)));
        }
        return null;
    }

    private static final class FixImpl
    implements Fix {
        private final Source source;
        private final TreePathHandle tph;

        public FixImpl(Source source, TreePathHandle treePathHandle) {
            this.source = source;
            this.tph = treePathHandle;
        }

        public String getText() {
            return NbBundle.getMessage(StringBuilderAppend.class, (String)"FIX_StringBuilderAppend");
        }

        public ChangeInfo implement() throws Exception {
            ModificationResult.runModificationTask(Collections.singletonList(this.source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    WorkingCopy workingCopy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                    if (workingCopy == null) {
                        return;
                    }
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath treePath = FixImpl.this.tph.resolve((CompilationInfo)workingCopy);
                    if (treePath == null) {
                        return;
                    }
                    MethodInvocationTree methodInvocationTree = (MethodInvocationTree)treePath.getLeaf();
                    ExpressionTree expressionTree = methodInvocationTree.getArguments().get(0);
                    List<List<TreePath>> list = Utilities.splitStringConcatenationToElements((CompilationInfo)workingCopy, new TreePath(treePath, expressionTree));
                    ExpressionTree expressionTree2 = ((MemberSelectTree)methodInvocationTree.getMethodSelect()).getExpression();
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    for (List<TreePath> list2 : list) {
                        ExpressionTree expressionTree3 = (ExpressionTree)list2.remove(0).getLeaf();
                        while (!list2.isEmpty()) {
                            expressionTree3 = treeMaker.Binary(Tree.Kind.PLUS, expressionTree3, (ExpressionTree)list2.remove(0).getLeaf());
                        }
                        while (expressionTree3.getKind() == Tree.Kind.PARENTHESIZED) {
                            expressionTree3 = ((ParenthesizedTree)expressionTree3).getExpression();
                        }
                        expressionTree2 = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect(expressionTree2, (CharSequence)"append"), Collections.singletonList(expressionTree3));
                    }
                    workingCopy.rewrite((Tree)methodInvocationTree, (Tree)expressionTree2);
                }
            }).commit();
            return null;
        }
    }
}

