/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Component;
import java.awt.Container;

public class LayoutStyle {
    public static final int RELATED = 0;
    public static final int UNRELATED = 1;
    public static final int INDENT = 3;
    private static LayoutStyle layoutStyle;

    public static void setSharedInstance(LayoutStyle layoutStyle) {
    }

    public static LayoutStyle getSharedInstance() {
        Object layoutImpl = null;
        if (layoutImpl != null && layoutImpl instanceof LayoutStyle) {
            return layoutImpl;
        }
        layoutStyle = new LayoutStyle();
        return layoutStyle;
    }

    public int getPreferredGap(Component component1, Component component2, int type, int position, Container parent) {
        if (position != 1 && position != 5 && position != 7 && position != 3) {
            throw new IllegalArgumentException("Invalid position");
        }
        if (component1 == null || component2 == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        if (type != 0 && type != 1 && type != 3) {
            throw new IllegalArgumentException("Invalid type");
        }
        return 4;
    }

    public int getContainerGap(Component component, int position, Container parent) {
        if (position != 1 && position != 5 && position != 7 && position != 3) {
            throw new IllegalArgumentException("Invalid position");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component must be non-null");
        }
        return 2;
    }

    boolean isDialog(Component component) {
        String name = component.getName();
        return name != null && name.endsWith(".contentPane");
    }

    int getCBRBPadding(Component source, Component target, int position, int offset) {
        if ((offset -= this.getCBRBPadding(source, position)) > 0) {
            offset -= this.getCBRBPadding(target, this.flipDirection(position));
        }
        if (offset < 0) {
            return 0;
        }
        return offset;
    }

    int getCBRBPadding(Component source, int position, int offset) {
        return Math.max(offset -= this.getCBRBPadding(source, position), 0);
    }

    int flipDirection(int position) {
        switch (position) {
            case 1: {
                return 5;
            }
            case 5: {
                return 1;
            }
            case 3: {
                return 7;
            }
            case 7: {
                return 3;
            }
        }
        return 0;
    }

    private int getCBRBPadding(Component c, int position) {
        return 0;
    }

    private int getInset(Component c, int position) {
        return 5;
    }

    int getButtonChildIndent(Component c, int position) {
        return 0;
    }
}

