/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.doxygensupport;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeExitStatus;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.completion.doxygensupport.Man2HTML;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ManDocumentation {
    private static final Map<String, String> TRANSLATE = new HashMap<String, String>();

    public static CompletionDocumentation getDocumentation(CsmObject obj, CsmFile file) throws IOException {
        if (obj instanceof CsmFunction) {
            return ManDocumentation.getDocumentation(((Object)((CsmFunction)obj).getName()).toString(), file);
        }
        return null;
    }

    public static CompletionDocumentation getDocumentation(String name, CsmFile file) throws IOException {
        return ManDocumentation.getDocumentation(name, 3, file);
    }

    public static CompletionDocumentation getDocumentation(String name, int chapter, CsmFile file) throws IOException {
        String doc = ManDocumentation.getDocumentationForName(name, chapter, file);
        if (doc == null) {
            return null;
        }
        return new CompletionDocumentationImpl(doc, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDocumentationForName(String name, int chapter, CsmFile file) throws IOException {
        NativeProject np = ManDocumentation.getNativeProject(file);
        if (np == null) {
            return "";
        }
        String platformName = np.getPlatformName();
        File cache = ManDocumentation.getCacheFile(name, chapter, platformName);
        if (cache.exists()) {
            return ManDocumentation.readFile(cache);
        }
        String doc = ManDocumentation.createDocumentationForName(name, chapter, np);
        if (doc != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(cache);
                ((OutputStream)out).write(doc.getBytes());
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return doc;
        }
        return null;
    }

    private static File getCacheDir() {
        String nbuser = System.getProperty("netbeans.user");
        File cache = new File(nbuser, "var/cache/cnd/manpages");
        cache.mkdirs();
        return cache;
    }

    private static File getCacheFile(String name, int chapter, String platformName) {
        String safeName;
        try {
            safeName = URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            safeName = name;
        }
        return new File(ManDocumentation.getCacheDir(), safeName + "." + platformName + "." + chapter);
    }

    static NativeProject getNativeProject(CsmFile csmFile) {
        NativeProject nativeProject = null;
        if (csmFile != null) {
            CsmProject csmProject = csmFile.getProject();
            if (csmProject.getPlatformProject() instanceof NativeProject) {
                nativeProject = (NativeProject)csmProject.getPlatformProject();
            } else {
                block0: for (CsmProject project : CsmModelAccessor.getModel().projects()) {
                    for (CsmProject lib : project.getLibraries()) {
                        if (!lib.equals(csmProject) || !(project.getPlatformProject() instanceof NativeProject)) continue;
                        nativeProject = (NativeProject)project.getPlatformProject();
                        break block0;
                    }
                }
            }
        }
        return nativeProject;
    }

    private static String createDocumentationForName(String name, int chapter, NativeProject np) throws IOException {
        NativeExitStatus exitStatus = null;
        if (np.getPlatformName() == null) {
            exitStatus = np.execute("man", new String[]{"MANWIDTH=65"}, new String[]{name});
        } else if (np.getPlatformName().contains("Solaris")) {
            NativeExitStatus es = np.execute("man", null, new String[]{"-l", name});
            String section = null;
            String output = es.output;
            int index1 = output.indexOf("(3");
            while (section == null && index1 >= 0) {
                if (output.charAt(index1 + 2) != 'f') {
                    int index2 = output.substring(index1).indexOf(")");
                    section = output.substring(index1 + 1, index1 + index2);
                    break;
                }
                output = output.substring(index1 + 1);
                index1 = output.indexOf("(3");
            }
            exitStatus = section != null ? np.execute("man", null, new String[]{"-s" + section, name}) : np.execute("man", null, new String[]{name});
        } else {
            exitStatus = np.execute("man", new String[]{"MANWIDTH=65"}, new String[]{"-S3", name});
        }
        if (exitStatus != null) {
            if (!exitStatus.isOK() || exitStatus.output.length() <= 0) {
                throw new IOException(exitStatus.error);
            }
        } else {
            return null;
        }
        StringReader sr = new StringReader(exitStatus.output);
        BufferedReader br = new BufferedReader(sr);
        String text = new Man2HTML(br).getHTML();
        br.close();
        sr.close();
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File f) throws IOException {
        FileInputStream fin = null;
        InputStream in = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            fin = new FileInputStream(f);
            in = f.getName().endsWith(".gz") ? new GZIPInputStream(fin) : fin;
            FileUtil.copy((InputStream)in, (OutputStream)out);
            String string = out.toString();
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            if (fin != null) {
                try {
                    ((InputStream)fin).close();
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            try {
                out.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static String getString(String s) {
        return NbBundle.getBundle(ManDocumentation.class).getString(s);
    }

    static {
        TRANSLATE.put("&minus;", "-");
        TRANSLATE.put("&lsquo;", "'");
        TRANSLATE.put("&rsquo;", "'");
    }

    private static final class CompletionDocumentationImpl
    implements CompletionDocumentation {
        private String doc;
        private CsmFile file;

        public CompletionDocumentationImpl(String doc, CsmFile file) {
            this.doc = doc;
            this.file = file;
        }

        public String getText() {
            return this.doc;
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            String[] parts = link.split("\\?");
            if (parts.length != 2) {
                return null;
            }
            String[] chapterAndName = parts[1].split("\\+");
            if (chapterAndName.length != 2) {
                return null;
            }
            int chapter = Integer.parseInt(chapterAndName[0]);
            String name = chapterAndName[1];
            try {
                return ManDocumentation.getDocumentation(name, chapter, this.file);
            }
            catch (IOException ioe) {
                return new CompletionDocumentationImpl(ioe.getMessage(), this.file);
            }
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }
}

