/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil.ui;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;

public class ElementNode
extends AbstractNode {
    private Description description;
    private boolean singleSelection;
    private static final Action[] EMPTY_ACTIONS = new Action[0];

    public ElementNode(Description description) {
        this(description, false);
    }

    private ElementNode(Description description, boolean sortChildren) {
        super((Children)(description.subs == null ? Children.LEAF : new ElementChilren(description.subs, sortChildren)), Lookups.singleton((Object)description));
        this.description = description;
        description.node = this;
        this.setDisplayName(description.name);
    }

    public void setSingleSelection(boolean singleSelection) {
        this.singleSelection = singleSelection;
    }

    public Image getIcon(int type) {
        if (this.description.iconElementHandle == null) {
            return super.getIcon(type);
        }
        if (CsmKindUtilities.isFile((CsmObject)this.description.iconElementHandle)) {
            CsmFile file = (CsmFile)this.description.iconElementHandle;
            CharSequence absolutePath = file.getAbsolutePath();
            FileObject fo = FileUtil.toFileObject((File)new File(((Object)absolutePath).toString()));
            if (fo != null) {
                try {
                    DataObject dob = DataObject.find((FileObject)fo);
                    Node node = dob.getNodeDelegate();
                    if (node != null) {
                        return node.getIcon(type);
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    // empty catch block
                }
            }
            return super.getIcon(type);
        }
        return ImageUtilities.icon2Image((Icon)CsmImageLoader.getIcon(this.description.iconElementHandle));
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getDisplayName() {
        return this.description.name;
    }

    public String getHtmlDisplayName() {
        return this.description.htmlHeader;
    }

    public Action[] getActions(boolean context) {
        return EMPTY_ACTIONS;
    }

    public void assureSingleSelection() {
        Description d;
        Node pn = this.getParentNode();
        if (pn == null && this.singleSelection) {
            this.description.deepSetSelected(false);
        } else if (pn != null && (d = (Description)pn.getLookup().lookup(Description.class)) != null) {
            d.node.assureSingleSelection();
        }
    }

    public static Node getWaitNode(String displayName) {
        return new WaitNode(displayName);
    }

    private static class WaitNode
    extends AbstractNode {
        private final Image waitIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/modelutil/resources/wait.gif");
        private final String displayName;

        WaitNode(String displayName) {
            super(Children.LEAF);
            this.displayName = displayName;
        }

        public Image getIcon(int type) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getHtmlDisplayName() {
            return this.displayName;
        }
    }

    public static final class Description {
        public static final Comparator<Description> ALPHA_COMPARATOR = new DescriptionComparator();
        private ElementNode node;
        private final String name;
        private final CsmDeclaration elementHandle;
        private final CsmObject iconElementHandle;
        private final Set<CsmVisibility> modifiers;
        private final List<Description> subs;
        private final String htmlHeader;
        private boolean isSelected;
        private final boolean isSelectable;

        public static Description create(List<Description> subs) {
            return new Description("<root>", null, null, subs, null, false, false);
        }

        public static Description create(CsmObject element, List<Description> subs, boolean isSelectable, boolean isSelected) {
            CsmNamespace ns;
            String name = "";
            if (CsmKindUtilities.isNamedElement((CsmObject)element)) {
                name = ((Object)((CsmNamedElement)element).getName()).toString();
            }
            String htmlHeader = name;
            if (CsmKindUtilities.isVariable((CsmObject)element)) {
                CsmVariable field = (CsmVariable)element;
                htmlHeader = ((Object)field.getName()).toString() + " : " + field.getType().getText();
            } else if (CsmKindUtilities.isFunction((CsmObject)element)) {
                CsmFunction method = (CsmFunction)element;
                htmlHeader = method.getSignature() + " : " + method.getReturnType().getText();
            } else if (CsmKindUtilities.isNamespace((Object)element) && !(ns = (CsmNamespace)element).isGlobal()) {
                htmlHeader = ((Object)ns.getQualifiedName()).toString();
            }
            return new Description(name, element, Collections.<CsmVisibility>emptySet(), subs, htmlHeader, isSelectable, isSelected);
        }

        private Description(String name, CsmObject elementHandle, Set<CsmVisibility> modifiers, List<Description> subs, String htmlHeader, boolean isSelectable, boolean isSelected) {
            this.name = name;
            this.iconElementHandle = elementHandle;
            this.elementHandle = CsmKindUtilities.isDeclaration((CsmObject)elementHandle) ? (CsmDeclaration)elementHandle : null;
            this.modifiers = modifiers;
            this.subs = subs;
            this.htmlHeader = htmlHeader;
            this.isSelectable = isSelectable;
            this.isSelected = isSelected;
        }

        public boolean isSelectable() {
            return this.isSelectable;
        }

        public boolean hasSelectableSubs() {
            if (null == this.subs) {
                return false;
            }
            for (Description d : this.getSubs()) {
                if (!d.isSelectable()) continue;
                return true;
            }
            return false;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public List<Description> getSubs() {
            return this.subs;
        }

        public void setSelected(boolean selected) {
            if (selected && this.node != null) {
                this.node.assureSingleSelection();
            }
            this.isSelected = selected;
            if (this.node != null) {
                this.node.fireDisplayNameChange(null, null);
            }
        }

        public void deepSetSelected(boolean value) {
            if (this.isSelectable() && value != this.isSelected()) {
                this.setSelected(value);
            }
            if (this.subs != null) {
                for (Description s : this.subs) {
                    s.deepSetSelected(value);
                }
            }
        }

        public CsmDeclaration getElementHandle() {
            return this.elementHandle;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Description)) {
                return false;
            }
            Description d = (Description)o;
            if (!this.name.equals(d.name)) {
                return false;
            }
            if (this.elementHandle != d.elementHandle) {
                if (this.elementHandle == null || d.elementHandle == null) {
                    return false;
                }
                if (this.elementHandle.getKind() != d.elementHandle.getKind()) {
                    return false;
                }
                if (!this.elementHandle.equals(d.elementHandle)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 29 * hash + (this.elementHandle != null ? this.elementHandle.getKind().hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.name + " " + this.isSelected;
        }

        public String getName() {
            return this.name;
        }

        public static Description deepCopy(Description d) {
            ArrayList<Description> subsCopy;
            if (d.subs == null) {
                subsCopy = null;
            } else {
                subsCopy = new ArrayList<Description>(d.subs.size());
                for (Description s : d.subs) {
                    subsCopy.add(Description.deepCopy(s));
                }
            }
            return new Description(d.name, (CsmObject)d.elementHandle, d.modifiers, subsCopy, d.htmlHeader, d.isSelectable, d.isSelected);
        }

        private static class DescriptionComparator
        implements Comparator<Description> {
            private DescriptionComparator() {
            }

            @Override
            public int compare(Description d1, Description d2) {
                if (this.k2i(d1.elementHandle.getKind()) != this.k2i(d2.elementHandle.getKind())) {
                    return this.k2i(d1.elementHandle.getKind()) - this.k2i(d2.elementHandle.getKind());
                }
                return d1.name.compareTo(d2.name);
            }

            int k2i(CsmDeclaration.Kind kind) {
                switch (kind) {
                    case FUNCTION: 
                    case FUNCTION_FRIEND: {
                        return 1;
                    }
                    case FUNCTION_DEFINITION: 
                    case FUNCTION_FRIEND_DEFINITION: {
                        return 2;
                    }
                    case VARIABLE: 
                    case VARIABLE_DEFINITION: {
                        return 3;
                    }
                    case CLASS: {
                        return 4;
                    }
                    case STRUCT: {
                        return 5;
                    }
                    case UNION: {
                        return 6;
                    }
                    case ENUM: {
                        return 7;
                    }
                }
                return 100;
            }
        }
    }

    private static final class ElementChilren
    extends Children.Keys<Description> {
        public ElementChilren(List<Description> descriptions, boolean sortChildren) {
            if (sortChildren) {
                Collections.sort(descriptions, Description.ALPHA_COMPARATOR);
            }
            this.setKeys(descriptions);
        }

        protected Node[] createNodes(Description key) {
            return new Node[]{new ElementNode(key, true)};
        }
    }
}

