/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;

public class MultiPropertyFolder {
    protected BaseOptions base;
    protected DataFolder folder;

    public MultiPropertyFolder(DataFolder fld, BaseOptions option) {
        this.base = option;
        this.folder = fld;
    }

    List getProperties() {
        ArrayList<DataObject> newSettings = new ArrayList<DataObject>();
        DataObject[] dob = this.folder.getChildren();
        for (int i = 0; i < dob.length; ++i) {
            newSettings.add(dob[i]);
        }
        return newSettings;
    }

    void setProperties(List newProps) {
    }

    public String getName() {
        return this.folder.getName();
    }

    public DataFolder getDataFolder() {
        return this.folder;
    }

    protected void deleteFile(final String fileToDelete, final String ext) {
        try {
            this.folder.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileObject delFO = MultiPropertyFolder.this.folder.getPrimaryFile().getFileObject(fileToDelete, ext);
                    if (delFO != null) {
                        FileLock lock = delFO.lock();
                        try {
                            delFO.delete(lock);
                        }
                        finally {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (FileStateInvalidException fsie) {
            fsie.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void createEmptyXMLFiles(final List fileName, String tagRoot, String publicID, String systemID) {
        final Document doc = XMLUtil.createDocument((String)tagRoot, null, (String)publicID, (String)systemID);
        try {
            this.folder.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    for (int i = 0; i < fileName.size(); ++i) {
                        if (MultiPropertyFolder.this.folder.getPrimaryFile().getFileObject((String)fileName.get(i), "xml") != null) continue;
                        FileObject fo = MultiPropertyFolder.this.folder.getPrimaryFile().createData((String)fileName.get(i), "xml");
                        FileLock lock = fo.lock();
                        try {
                            OutputStream os = fo.getOutputStream(lock);
                            try {
                                XMLUtil.write((Document)doc, (OutputStream)fo.getOutputStream(lock), (String)"UTF-8");
                                continue;
                            }
                            finally {
                                os.close();
                            }
                        }
                        finally {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (FileStateInvalidException fsie) {
            fsie.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

