/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;

public class InstanceVariable
extends AbstractVariable {
    private static String pattern = "@([a-zA-Z]|_)([a-zA-Z]|_|\\d)*";

    public static BiVariable getInstance(Ruby runtime2, String name2, Object ... javaObject) {
        if (name2.matches(pattern)) {
            return new InstanceVariable(runtime2, name2, javaObject);
        }
        return null;
    }

    private InstanceVariable(Ruby runtime2, String name2, Object ... javaObject) {
        super(runtime2, name2, javaObject);
    }

    public InstanceVariable(IRubyObject origin, String name2, IRubyObject irubyObject) {
        super(origin, name2, irubyObject);
    }

    public static void retrieve(Ruby runtime2, IRubyObject receiver2, BiVariableMap vars) {
        if (receiver2 == null) {
            receiver2 = runtime2.getTopSelf();
        }
        InstanceVariables ivars = receiver2.getInstanceVariables();
        List<String> names2 = ivars.getInstanceVariableNameList();
        for (String name2 : names2) {
            BiVariable var = null;
            IRubyObject value2 = ivars.fastGetInstanceVariable(name2);
            List<String> savedNames = vars.getNames();
            for (int i = 0; i < savedNames.size(); ++i) {
                if (!name2.equals(savedNames.get(i))) continue;
                var = vars.getVariables().get(i);
                if (receiver2 == var.getOrigin()) {
                    var = vars.getVariable(name2);
                    var.setRubyObject(value2);
                    break;
                }
                var = null;
            }
            if (var != null) continue;
            var = new InstanceVariable(receiver2, name2, value2);
            vars.update(name2, var);
        }
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.InstanceVariable;
    }

    public static boolean isValidName(Object name2) {
        return InstanceVariable.isValidName(pattern, name2);
    }

    public void inject(Ruby runtime2, IRubyObject receiver2) {
        if (this.origin != null && this.origin != receiver2) {
            return;
        }
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject rubyReceiver = receiver2 != null ? receiver2 : context.getFrameSelf();
        IRubyObject rubyName = JavaEmbedUtils.javaToRuby(runtime2, this.name);
        ((RubyObject)rubyReceiver).instance_variable_set(rubyName, this.irubyObject);
    }

    public void remove(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject self = context.getFrameSelf();
        self.getInstanceVariables().removeInstanceVariable(this.name);
    }
}

