/*
 * Decompiled with CFR 0.152.
 */
package jruby.objectweb.asm.commons;

import jruby.objectweb.asm.AnnotationVisitor;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.commons.LocalVariablesSorter;
import jruby.objectweb.asm.commons.Remapper;
import jruby.objectweb.asm.commons.RemappingAnnotationAdapter;

public class RemappingMethodAdapter
extends LocalVariablesSorter {
    protected final Remapper remapper;

    public RemappingMethodAdapter(int n, String string2, MethodVisitor methodVisitor, Remapper remapper) {
        super(n, string2, methodVisitor);
        this.remapper = remapper;
    }

    public void visitFieldInsn(int n, String string2, String string3, String string4) {
        super.visitFieldInsn(n, this.remapper.mapType(string2), this.remapper.mapFieldName(string2, string3, string4), this.remapper.mapDesc(string4));
    }

    public void visitMethodInsn(int n, String string2, String string3, String string4) {
        super.visitMethodInsn(n, this.remapper.mapType(string2), this.remapper.mapMethodName(string2, string3, string4), this.remapper.mapMethodDesc(string4));
    }

    public void visitTypeInsn(int n, String string2) {
        super.visitTypeInsn(n, this.remapper.mapType(string2));
    }

    public void visitLdcInsn(Object object) {
        super.visitLdcInsn(this.remapper.mapValue(object));
    }

    public void visitMultiANewArrayInsn(String string2, int n) {
        super.visitMultiANewArrayInsn(this.remapper.mapDesc(string2), n);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string2) {
        super.visitTryCatchBlock(label, label2, label3, string2 == null ? null : this.remapper.mapType(string2));
    }

    public void visitLocalVariable(String string2, String string3, String string4, Label label, Label label2, int n) {
        super.visitLocalVariable(string2, this.remapper.mapDesc(string3), this.remapper.mapSignature(string4, true), label, label2, n);
    }

    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        AnnotationVisitor annotationVisitor = this.mv.visitAnnotation(string2, bl);
        return annotationVisitor == null ? annotationVisitor : new RemappingAnnotationAdapter(annotationVisitor, this.remapper);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor annotationVisitor = this.mv.visitAnnotationDefault();
        return annotationVisitor == null ? annotationVisitor : new RemappingAnnotationAdapter(annotationVisitor, this.remapper);
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string2, boolean bl) {
        AnnotationVisitor annotationVisitor = this.mv.visitParameterAnnotation(n, string2, bl);
        return annotationVisitor == null ? annotationVisitor : new RemappingAnnotationAdapter(annotationVisitor, this.remapper);
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        super.visitFrame(n, n2, this.remapEntries(n2, objectArray), n3, this.remapEntries(n3, objectArray2));
    }

    private Object[] remapEntries(int n, Object[] objectArray) {
        for (int i = 0; i < n; ++i) {
            if (!(objectArray[i] instanceof String)) continue;
            Object[] objectArray2 = new Object[n];
            if (i > 0) {
                System.arraycopy(objectArray, 0, objectArray2, 0, i);
            }
            do {
                Object object = objectArray[i];
                Object object2 = objectArray2[i++] = object instanceof String ? this.remapper.mapType((String)object) : object;
            } while (i < n);
            return objectArray2;
        }
        return objectArray;
    }
}

