/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.util.concurrent.Callable;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.netbeans.modules.ruby.rubyproject.TestNotifierLineConvertor;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AutoTestSupport {
    private Project project;
    private Lookup context;
    private String charsetName;
    private String classPath;

    public AutoTestSupport(Lookup context, Project project, String charsetName) {
        this.context = context;
        this.project = project;
        this.charsetName = charsetName;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public static boolean isInstalled(Project project, TestRunner.TestType type) {
        RubyPlatform platform = RubyPlatform.platformFor((Project)project);
        if (platform == null) {
            return false;
        }
        if (type == TestRunner.TestType.AUTOTEST) {
            return platform.hasValidAutoTest(false);
        }
        if (type == TestRunner.TestType.AUTOSPEC) {
            return platform.hasValidAutoSpec(false);
        }
        return false;
    }

    public void start(TestRunner.TestType type) {
        TestRunner autotestRunner = Util.getTestRunner(type);
        if (autotestRunner != null) {
            autotestRunner.runAllTests(this.project, false);
            return;
        }
        RubyPlatform platform = RubyPlatform.platformFor((Project)this.project);
        if (!platform.hasValidAutoTest(true)) {
            return;
        }
        File pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        String executable = TestRunner.TestType.AUTOSPEC == type ? platform.getAutoSpec() : platform.getAutoTest();
        String bundleKey = TestRunner.TestType.AUTOSPEC == type ? "AutoSpec" : "AutoTest";
        RubyFileLocator fileLocator = new RubyFileLocator(this.context, this.project);
        String displayName = NbBundle.getMessage(AutoTestSupport.class, (String)bundleKey);
        RubyExecutionDescriptor desc = new RubyExecutionDescriptor(platform, displayName, pwd, executable);
        desc.additionalArgs(new String[]{"-v"});
        desc.fileLocator((LineConvertors.FileLocator)fileLocator);
        desc.classPath(this.classPath);
        desc.showProgress(false);
        desc.addStandardRecognizers();
        TestNotifierLineConvertor testNotifier = new TestNotifierLineConvertor(false, false);
        desc.addOutConvertor((LineConvertor)testNotifier);
        desc.addErrConvertor((LineConvertor)testNotifier);
        RubyProcessCreator rpc = new RubyProcessCreator(desc, this.charsetName);
        ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)desc.toExecutionDescriptor(), (String)displayName).run();
    }
}

