/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.spi;

import java.net.URI;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.util.Utilities;
import org.openide.util.Lookup;

public abstract class ProjectHudsonProvider {
    public static ProjectHudsonProvider getDefault() {
        return new ProjectHudsonProvider(){

            @Override
            public Association findAssociation(Project p) {
                for (ProjectHudsonProvider php : Lookup.getDefault().lookupAll(ProjectHudsonProvider.class)) {
                    Association a = php.findAssociation(p);
                    if (a == null) continue;
                    return a;
                }
                return null;
            }

            @Override
            public boolean recordAssociation(Project p, Association a) {
                for (ProjectHudsonProvider php : Lookup.getDefault().lookupAll(ProjectHudsonProvider.class)) {
                    if (!php.recordAssociation(p, a)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public abstract Association findAssociation(Project var1);

    public Project findAssociatedProject(Association assoc) {
        Project p;
        HashMap<Association, Project> assocs = new HashMap<Association, Project>();
        for (Project p2 : OpenProjects.getDefault().getOpenProjects()) {
            Association found = this.findAssociation(p2);
            if (assoc.equals(found)) {
                return p2;
            }
            if (!assocs.containsKey(assoc)) {
                assocs.put(found, p2);
                continue;
            }
            assocs.put(found, null);
        }
        if (assoc.getJobName() != null && (p = (Project)assocs.get(Association.fromString(assoc.getServerUrl()))) != null) {
            return p;
        }
        return null;
    }

    public abstract boolean recordAssociation(Project var1, Association var2);

    public static final class Association {
        private final String serverURL;
        private final String jobName;

        public Association(String serverURL, String jobName) throws IllegalArgumentException {
            URI.create(serverURL);
            if (!serverURL.endsWith("/")) {
                throw new IllegalArgumentException(serverURL + " must end in a slash");
            }
            if (!(jobName == null || jobName.length() != 0 && jobName.trim().equals(jobName))) {
                throw new IllegalArgumentException("Must provide a nonempty or null job name: " + jobName);
            }
            this.serverURL = serverURL;
            this.jobName = jobName;
        }

        public static Association forJob(HudsonJob job) {
            return new Association(job.getInstance().getUrl(), job.getName());
        }

        public String getServerUrl() {
            return this.serverURL;
        }

        public String getJobName() {
            return this.jobName;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Association)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.jobName != null ? this.serverURL + "job/" + Utilities.uriEncode(this.jobName) + "/" : this.serverURL;
        }

        public static Association fromString(String s) {
            Matcher m = Pattern.compile("(https?://.+?/)(?:job/([^/]+)/?)?").matcher(s);
            if (!m.matches()) {
                return null;
            }
            String jobNameRaw = m.group(2);
            return new Association(m.group(1), jobNameRaw != null ? Utilities.uriDecode(jobNameRaw) : null);
        }
    }
}

