/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NbPlatformCustomizerHarness
extends JPanel {
    private NbPlatform plaf;
    private JButton browseButton;
    private ButtonGroup buttonGroup;
    private JRadioButton ideButton;
    private JRadioButton otherButton;
    private JTextField otherText;
    private JRadioButton platformButton;
    private JLabel versionLabel;
    private JTextField versionText;

    public NbPlatformCustomizerHarness() {
        this.initComponents();
    }

    void setPlatform(NbPlatform plaf) {
        this.plaf = plaf;
        if (plaf.isDefault()) {
            this.ideButton.setSelected(true);
        } else {
            File harnessLocation = plaf.getHarnessLocation();
            NbPlatform dflt = NbPlatform.getDefaultPlatform();
            if (dflt != null && harnessLocation.equals(dflt.getHarnessLocation())) {
                this.ideButton.setSelected(true);
            } else if (harnessLocation.equals(plaf.getBundledHarnessLocation())) {
                this.platformButton.setSelected(true);
            } else {
                this.otherButton.setSelected(true);
            }
        }
        this.update();
        UIUtil.setText(this.otherText, plaf.getHarnessLocation().getAbsolutePath());
    }

    private void update() {
        this.versionText.setText(this.plaf.getHarnessVersion().getDisplayName());
        if (this.plaf.isDefault()) {
            this.platformButton.setEnabled(false);
            this.otherButton.setEnabled(false);
        } else {
            this.platformButton.setEnabled(true);
            this.otherButton.setEnabled(true);
        }
        this.browseButton.setEnabled(this.otherButton.isSelected());
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.ideButton = new JRadioButton();
        this.platformButton = new JRadioButton();
        this.otherButton = new JRadioButton();
        this.otherText = new JTextField();
        this.browseButton = new JButton();
        this.versionLabel = new JLabel();
        this.versionText = new JTextField();
        this.buttonGroup.add(this.ideButton);
        this.ideButton.setMnemonic('I');
        Mnemonics.setLocalizedText((AbstractButton)this.ideButton, (String)NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPCH.ideButton"));
        this.ideButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ideButton.setMargin(new Insets(0, 0, 0, 0));
        this.ideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerHarness.this.ideButtonActionPerformed(evt);
            }
        });
        this.buttonGroup.add(this.platformButton);
        this.platformButton.setMnemonic('P');
        Mnemonics.setLocalizedText((AbstractButton)this.platformButton, (String)NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPCH.platformButton"));
        this.platformButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.platformButton.setMargin(new Insets(0, 0, 0, 0));
        this.platformButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerHarness.this.platformButtonActionPerformed(evt);
            }
        });
        this.buttonGroup.add(this.otherButton);
        this.otherButton.setMnemonic('O');
        Mnemonics.setLocalizedText((AbstractButton)this.otherButton, (String)NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPCH.otherButton"));
        this.otherButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.otherButton.setMargin(new Insets(0, 0, 0, 0));
        this.otherButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerHarness.this.otherButtonActionPerformed(evt);
            }
        });
        this.otherText.setEditable(false);
        this.browseButton.setMnemonic('B');
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPCH.browseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerHarness.this.browseButtonActionPerformed(evt);
            }
        });
        this.versionLabel.setDisplayedMnemonic('V');
        this.versionLabel.setLabelFor(this.versionText);
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPCH.versionLabel"));
        this.versionText.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ideButton).addComponent(this.platformButton).addGroup(layout.createSequentialGroup().addComponent(this.otherButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.otherText, -1, 254, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(layout.createSequentialGroup().addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionText, -1, 231, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.ideButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.platformButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.otherButton).addComponent(this.browseButton).addComponent(this.otherText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionLabel).addComponent(this.versionText, -2, -1, -2)).addContainerGap(196, Short.MAX_VALUE)));
        this.ideButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"ACS_HarnessSuppliedIDE"));
        this.platformButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"ACS_HarnessSuppliedPlatform"));
        this.otherButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"ACS_HarnessOther"));
        this.otherText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPlatformCustomizerHarness.otherText.AccessibleContext.accessibleName"));
        this.otherText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPlatformCustomizerHarness.otherText.AccessibleContext.accessibleDescription"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPlatformCustomizerHarness.browseButton.AccessibleContext.accessibleDescription"));
        this.versionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"ACS_HarnessVersion"));
        this.versionText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPlatformCustomizerHarness.versionText.AccessibleContext.accessibleName"));
        this.versionText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPlatformCustomizerHarness.versionText.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPlatformCustomizerHarness.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPlatformCustomizerHarness.AccessibleContext.accessibleDescription"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(){

            @Override
            public void approveSelection() {
                File dir = FileUtil.normalizeFile((File)this.getSelectedFile());
                if (NbPlatform.isHarness(dir)) {
                    super.approveSelection();
                } else {
                    this.setCurrentDirectory(dir);
                }
            }
        };
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jfc, null);
        jfc.setFileSelectionMode(1);
        jfc.setSelectedFile(this.plaf.getHarnessLocation());
        if (jfc.showOpenDialog(this) == 0) {
            try {
                this.plaf.setHarnessLocation(FileUtil.normalizeFile((File)jfc.getSelectedFile()));
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        this.update();
        UIUtil.setText(this.otherText, this.plaf.getHarnessLocation().getAbsolutePath());
    }

    private void otherButtonActionPerformed(ActionEvent evt) {
        try {
            this.plaf.setHarnessLocation(FileUtil.normalizeFile((File)new File(this.otherText.getText())));
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        this.update();
    }

    private void platformButtonActionPerformed(ActionEvent evt) {
        try {
            this.plaf.setHarnessLocation(this.plaf.getBundledHarnessLocation());
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        this.update();
    }

    private void ideButtonActionPerformed(ActionEvent evt) {
        try {
            assert (this.plaf != null);
            NbPlatform dflt = NbPlatform.getDefaultPlatform();
            if (dflt != null) {
                this.plaf.setHarnessLocation(dflt.getHarnessLocation());
            } else {
                Logger.getLogger(NbPlatformCustomizerHarness.class.getName()).warning("No default platform found");
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        this.update();
    }
}

