/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.branding;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.apisupport.project.ui.branding.AbstractBrandingPanel;
import org.netbeans.modules.apisupport.project.ui.branding.BasicBrandingModel;
import org.netbeans.modules.apisupport.project.ui.branding.BasicBrandingPanel;
import org.netbeans.modules.apisupport.project.ui.branding.SplashUISupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WindowSystemBrandingPanel
extends AbstractBrandingPanel {
    private JCheckBox cbEnableDnd;
    private JCheckBox cbEnableEditorClosing;
    private JCheckBox cbEnableFloating;
    private JCheckBox cbEnableMaximization;
    private JCheckBox cbEnableMinimumSize;
    private JCheckBox cbEnableResizing;
    private JCheckBox cbEnableSliding;
    private JCheckBox cbEnableViewClosing;
    private JLabel jLabel1;

    public WindowSystemBrandingPanel(BasicBrandingModel model) {
        super(NbBundle.getMessage(BasicBrandingPanel.class, (String)"LBL_WindowSystemTab"), model);
        this.initComponents();
        this.refresh();
        this.enableDisableComponents();
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                WindowSystemBrandingPanel.this.setModified();
            }
        };
        this.cbEnableDnd.addItemListener(listener);
        this.cbEnableEditorClosing.addItemListener(listener);
        this.cbEnableFloating.addItemListener(listener);
        this.cbEnableMaximization.addItemListener(listener);
        this.cbEnableMinimumSize.addItemListener(listener);
        this.cbEnableResizing.addItemListener(listener);
        this.cbEnableSliding.addItemListener(listener);
        this.cbEnableViewClosing.addItemListener(listener);
    }

    @Override
    public void store() {
        BasicBrandingModel branding = this.getBranding();
        SplashUISupport.setValue(branding.getWsEnableClosingEditors(), Boolean.toString(this.cbEnableEditorClosing.isSelected()));
        SplashUISupport.setValue(branding.getWsEnableClosingViews(), Boolean.toString(this.cbEnableViewClosing.isSelected()));
        SplashUISupport.setValue(branding.getWsEnableDragAndDrop(), Boolean.toString(this.cbEnableDnd.isSelected()));
        SplashUISupport.setValue(branding.getWsEnableFloating(), Boolean.toString(this.cbEnableFloating.isSelected()));
        SplashUISupport.setValue(branding.getWsEnableMaximization(), Boolean.toString(this.cbEnableMaximization.isSelected()));
        SplashUISupport.setValue(branding.getWsEnableMinimumSize(), Boolean.toString(this.cbEnableMinimumSize.isSelected()));
        SplashUISupport.setValue(branding.getWsEnableResizing(), Boolean.toString(this.cbEnableResizing.isSelected()));
        SplashUISupport.setValue(branding.getWsEnableSliding(), Boolean.toString(this.cbEnableSliding.isSelected()));
    }

    void refresh() {
        BasicBrandingModel branding = this.getBranding();
        this.cbEnableDnd.setSelected(SplashUISupport.bundleKeyToBoolean(branding.getWsEnableDragAndDrop()));
        this.cbEnableEditorClosing.setSelected(SplashUISupport.bundleKeyToBoolean(branding.getWsEnableClosingEditors()));
        this.cbEnableFloating.setSelected(SplashUISupport.bundleKeyToBoolean(branding.getWsEnableFloating()));
        this.cbEnableMaximization.setSelected(SplashUISupport.bundleKeyToBoolean(branding.getWsEnableMaximization()));
        this.cbEnableMinimumSize.setSelected(SplashUISupport.bundleKeyToBoolean(branding.getWsEnableMinimumSize()));
        this.cbEnableResizing.setSelected(SplashUISupport.bundleKeyToBoolean(branding.getWsEnableResizing()));
        this.cbEnableSliding.setSelected(SplashUISupport.bundleKeyToBoolean(branding.getWsEnableSliding()));
        this.cbEnableViewClosing.setSelected(SplashUISupport.bundleKeyToBoolean(branding.getWsEnableClosingViews()));
        this.enableDisableComponents();
    }

    private void enableDisableComponents() {
        BasicBrandingModel branding = this.getBranding();
        this.cbEnableDnd.setEnabled(branding.isBrandingEnabled());
        this.cbEnableEditorClosing.setEnabled(branding.isBrandingEnabled());
        this.cbEnableFloating.setEnabled(branding.isBrandingEnabled());
        this.cbEnableMinimumSize.setEnabled(branding.isBrandingEnabled());
        this.cbEnableResizing.setEnabled(branding.isBrandingEnabled());
        this.cbEnableSliding.setEnabled(branding.isBrandingEnabled());
        this.cbEnableViewClosing.setEnabled(branding.isBrandingEnabled());
        this.cbEnableMaximization.setEnabled(branding.isBrandingEnabled());
    }

    private void initComponents() {
        this.cbEnableDnd = new JCheckBox();
        this.cbEnableFloating = new JCheckBox();
        this.cbEnableSliding = new JCheckBox();
        this.cbEnableViewClosing = new JCheckBox();
        this.cbEnableEditorClosing = new JCheckBox();
        this.cbEnableResizing = new JCheckBox();
        this.cbEnableMinimumSize = new JCheckBox();
        this.cbEnableMaximization = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.cbEnableDnd.setMnemonic('D');
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnableDnd, (String)NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"LBL_EnableDnD"));
        this.cbEnableFloating.setMnemonic('F');
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnableFloating, (String)NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"LBL_EnableFloating"));
        this.cbEnableSliding.setMnemonic('S');
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnableSliding, (String)NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"LBL_EnableSliding"));
        this.cbEnableViewClosing.setMnemonic('N');
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnableViewClosing, (String)NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"LBL_EnableViewClosing"));
        this.cbEnableEditorClosing.setMnemonic('C');
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnableEditorClosing, (String)NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"LBL_EnableEditorClosing"));
        this.cbEnableResizing.setMnemonic('R');
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnableResizing, (String)NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"LBL_EnableResizing"));
        this.cbEnableMinimumSize.setMnemonic('E');
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnableMinimumSize, (String)NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"LBL_EnableMinimumSize"));
        this.cbEnableMaximization.setMnemonic('M');
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnableMaximization, (String)NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"LBL_EnableMaximization"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"SuiteCustomizerWindowSystemBranding.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbEnableEditorClosing).addComponent(this.cbEnableMinimumSize).addComponent(this.cbEnableFloating).addComponent(this.cbEnableSliding).addComponent(this.cbEnableMaximization).addComponent(this.cbEnableViewClosing).addComponent(this.cbEnableResizing).addComponent(this.cbEnableDnd)).addContainerGap(137, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbEnableDnd)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbEnableFloating).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbEnableSliding).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbEnableMaximization).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbEnableViewClosing).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbEnableEditorClosing, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbEnableResizing).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbEnableMinimumSize).addContainerGap(32, Short.MAX_VALUE)));
        this.cbEnableDnd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"ACSD_EnableDnD"));
        this.cbEnableFloating.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"ACSD_EnableFloating"));
        this.cbEnableSliding.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"SuiteCustomizerWindowSystemBranding.cbEnableSliding.AccessibleContext.accessibleName"));
        this.cbEnableSliding.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"ACSD_EnableSliding"));
        this.cbEnableViewClosing.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"ACSD_EnableViewClosing"));
        this.cbEnableEditorClosing.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"ACSD_EnableEditorClosing"));
        this.cbEnableResizing.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"ACSD_EnableResizing"));
        this.cbEnableMinimumSize.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"ACSD_EnableMinimumSize"));
        this.cbEnableMaximization.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"SuiteCustomizerWindowSystemBranding.cbEnableMaximization.AccessibleContext.accessibleName"));
        this.cbEnableMaximization.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"ACSD_EnableMaximization"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"SuiteCustomizerWindowSystemBranding.jLabel1.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WindowSystemBrandingPanel.class, (String)"SuiteCustomizerWindowSystemBranding.AccessibleContext.accessibleName"));
    }
}

